/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.cybersource.service.payment.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class CyberSourceMethodType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, CyberSourceMethodType> TYPES = new HashMap<String, CyberSourceMethodType>();
    public static final CyberSourceMethodType CREDITCARD = new CyberSourceMethodType("CREDITCARD", "Credit Card");
    public static final CyberSourceMethodType BANKACCOUNT = new CyberSourceMethodType("BANKACCOUNT", "Bank Account");
    public static final CyberSourceMethodType PAYPAL = new CyberSourceMethodType("PAYPAL", "PayPal");
    private String type;
    private String friendlyType;

    public static CyberSourceMethodType getInstance(String type) {
        return TYPES.get(type);
    }

    public CyberSourceMethodType() {
    }

    public CyberSourceMethodType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CyberSourceMethodType other = (CyberSourceMethodType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

