/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.cybersource.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.FileProvider;
import org.broadleafcommerce.common.vendor.service.monitor.ServiceStatusDetectable;
import org.broadleafcommerce.common.vendor.service.type.ServiceStatusType;
import org.broadleafcommerce.profile.core.service.IdGenerationService;
import org.broadleafcommerce.vendor.cybersource.service.api.ITransactionProcessorStub;
import org.broadleafcommerce.vendor.cybersource.service.api.ReplyMessage;
import org.broadleafcommerce.vendor.cybersource.service.api.RequestMessage;
import org.broadleafcommerce.vendor.cybersource.service.api.TransactionProcessorLocator;

public abstract class AbstractCyberSourceService
implements ServiceStatusDetectable {
    protected String merchantId;
    protected String serverUrl;
    protected String libVersion;
    protected Integer failureReportingThreshold;
    protected Integer failureCount = 0;
    protected Boolean isUp = true;
    protected IdGenerationService idGenerationService;

    protected ReplyMessage sendRequest(RequestMessage request) throws AxisFault, MalformedURLException, RemoteException, ServiceException {
        FileProvider config = new FileProvider("CyberSourceDeploy.wsdd");
        TransactionProcessorLocator service = new TransactionProcessorLocator((EngineConfiguration)config);
        URL endpoint = new URL(this.getServerUrl());
        ITransactionProcessorStub stub = (ITransactionProcessorStub)service.getportXML(endpoint);
        stub._setProperty("user", (Object)request.getMerchantID());
        ReplyMessage reply = stub.runTransaction(request);
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearStatus() {
        Integer n = this.failureCount;
        synchronized (n) {
            this.isUp = true;
            this.failureCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementFailure() {
        Integer n = this.failureCount;
        synchronized (n) {
            if (this.failureCount >= this.failureReportingThreshold) {
                this.isUp = false;
            } else {
                Integer n2 = this.failureCount;
                Integer n3 = this.failureCount = Integer.valueOf(this.failureCount + 1);
            }
        }
    }

    public Integer getFailureReportingThreshold() {
        return this.failureReportingThreshold;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getLibVersion() {
        return this.libVersion;
    }

    public String getServiceName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceStatusType getServiceStatus() {
        Integer n = this.failureCount;
        synchronized (n) {
            if (this.isUp.booleanValue()) {
                return ServiceStatusType.UP;
            }
            return ServiceStatusType.DOWN;
        }
    }

    public void setFailureReportingThreshold(Integer failureReportingThreshold) {
        this.failureReportingThreshold = failureReportingThreshold;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setLibVersion(String libVersion) {
        this.libVersion = libVersion;
    }

    public IdGenerationService getIdGenerationService() {
        return this.idGenerationService;
    }

    public void setIdGenerationService(IdGenerationService idGenerationService) {
        this.idGenerationService = idGenerationService;
    }
}

