/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.cybersource.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.FileProvider;
import org.broadleafcommerce.profile.service.IdGenerationService;
import org.broadleafcommerce.vendor.cybersource.service.api.ITransactionProcessorStub;
import org.broadleafcommerce.vendor.cybersource.service.api.PurchaseTotals;
import org.broadleafcommerce.vendor.cybersource.service.api.ReplyMessage;
import org.broadleafcommerce.vendor.cybersource.service.api.RequestMessage;
import org.broadleafcommerce.vendor.cybersource.service.api.TransactionProcessorLocator;
import org.broadleafcommerce.vendor.cybersource.service.payment.message.CyberSourcePaymentRequest;
import org.broadleafcommerce.vendor.service.monitor.ServiceStatusDetectable;
import org.broadleafcommerce.vendor.service.type.ServiceStatusType;

public abstract class AbstractCyberSourcePaymentService
implements ServiceStatusDetectable {
    private String merchantId;
    private String serverUrl;
    private String libVersion;
    protected Integer failureReportingThreshold;
    protected Integer failureCount = 0;
    protected Boolean isUp = true;
    private IdGenerationService idGenerationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearStatus() {
        Integer n = this.failureCount;
        synchronized (n) {
            this.isUp = true;
            this.failureCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementFailure() {
        Integer n = this.failureCount;
        synchronized (n) {
            if (this.failureCount >= this.failureReportingThreshold) {
                this.isUp = false;
            } else {
                Integer n2 = this.failureCount;
                Integer n3 = this.failureCount = Integer.valueOf(this.failureCount + 1);
            }
        }
    }

    public Integer getFailureReportingThreshold() {
        return this.failureReportingThreshold;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getLibVersion() {
        return this.libVersion;
    }

    public String getServiceName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceStatusType getServiceStatus() {
        Integer n = this.failureCount;
        synchronized (n) {
            if (this.isUp.booleanValue()) {
                return ServiceStatusType.UP;
            }
            return ServiceStatusType.DOWN;
        }
    }

    public void setFailureReportingThreshold(Integer failureReportingThreshold) {
        this.failureReportingThreshold = failureReportingThreshold;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setLibVersion(String libVersion) {
        this.libVersion = libVersion;
    }

    public IdGenerationService getIdGenerationService() {
        return this.idGenerationService;
    }

    public void setIdGenerationService(IdGenerationService idGenerationService) {
        this.idGenerationService = idGenerationService;
    }

    protected ReplyMessage sendRequest(RequestMessage request) throws AxisFault, MalformedURLException, RemoteException, ServiceException {
        FileProvider config = new FileProvider("CyberSourceDeploy.wsdd");
        TransactionProcessorLocator service = new TransactionProcessorLocator((EngineConfiguration)config);
        URL endpoint = new URL(this.serverUrl);
        ITransactionProcessorStub stub = (ITransactionProcessorStub)service.getportXML(endpoint);
        stub._setProperty("user", (Object)request.getMerchantID());
        ReplyMessage reply = stub.runTransaction(request);
        return reply;
    }

    protected RequestMessage buildRequestMessage(CyberSourcePaymentRequest paymentRequest) {
        RequestMessage request = new RequestMessage();
        request.setMerchantID(this.merchantId);
        request.setMerchantReferenceCode(this.idGenerationService.findNextId("org.broadleafcommerce.vendor.cybersource.service.CyberSourceService").toString());
        request.setClientLibrary("Java Axis WSS4J");
        request.setClientLibraryVersion(this.libVersion);
        request.setClientEnvironment(System.getProperty("os.name") + "/" + System.getProperty("os.version") + "/" + System.getProperty("java.vendor") + "/" + System.getProperty("java.version"));
        PurchaseTotals purchaseTotals = new PurchaseTotals();
        purchaseTotals.setCurrency(paymentRequest.getCurrency());
        request.setPurchaseTotals(purchaseTotals);
        return request;
    }
}

