/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.page.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.cms.page.dao.PageDao;
import org.broadleafcommerce.cms.page.domain.Page;
import org.broadleafcommerce.cms.page.domain.PageField;
import org.broadleafcommerce.cms.page.domain.PageTemplate;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxImpl;
import org.broadleafcommerce.openadmin.server.domain.SandBoxType;
import org.springframework.stereotype.Repository;

@Repository(value="blPageDao")
public class PageDaoImpl
implements PageDao {
    private static SandBox DUMMY_SANDBOX = new SandBoxImpl();
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    public PageDaoImpl() {
        DUMMY_SANDBOX.setId(Long.valueOf(-1L));
    }

    @Override
    public Page readPageById(Long id) {
        return (Page)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.cms.page.domain.Page"), (Object)id);
    }

    @Override
    public PageTemplate readPageTemplateById(Long id) {
        return (PageTemplate)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.cms.page.domain.PageTemplate"), (Object)id);
    }

    @Override
    public Map<String, PageField> readPageFieldsByPage(Page page) {
        Query query = this.em.createNamedQuery("BC_READ_PAGE_FIELDS_BY_PAGE_ID");
        query.setParameter("page", (Object)page);
        query.setHint("org.hibernate.cacheable", (Object)true);
        List pageFields = query.getResultList();
        HashMap<String, PageField> pageFieldMap = new HashMap<String, PageField>();
        for (PageField pageField : pageFields) {
            pageFieldMap.put(pageField.getFieldKey(), pageField);
        }
        return pageFieldMap;
    }

    @Override
    public Page updatePage(Page page) {
        return (Page)this.em.merge((Object)page);
    }

    @Override
    public void delete(Page page) {
        if (!this.em.contains((Object)page)) {
            page = this.readPageById(page.getId());
        }
        this.em.remove((Object)page);
    }

    @Override
    public Page addPage(Page clonedPage) {
        return (Page)this.em.merge((Object)clonedPage);
    }

    @Override
    public Page findPageByURI(SandBox sandBox, Locale locale, String uri) {
        Query query;
        if (sandBox == null) {
            query = this.em.createNamedQuery("BC_READ_PAGE_BY_URI");
            query.setParameter("uri", (Object)uri);
            query.setParameter("locale", (Object)locale);
        } else if (SandBoxType.PRODUCTION.equals((Object)sandBox)) {
            query = this.em.createNamedQuery("BC_READ_PAGE_BY_URI_AND_PRODUCTION_SANDBOX");
            query.setParameter("sandbox", (Object)sandBox);
            query.setParameter("locale", (Object)locale);
            query.setParameter("uri", (Object)uri);
        } else {
            query = this.em.createNamedQuery("BC_READ_PAGE_BY_URI_AND_USER_SANDBOX");
            query.setParameter("sandbox", (Object)sandBox);
            query.setParameter("locale", (Object)locale);
            query.setParameter("uri", (Object)uri);
        }
        query.setHint("org.hibernate.cacheable", (Object)true);
        List results = query.getResultList();
        if (results != null && !results.isEmpty()) {
            return (Page)results.get(0);
        }
        return null;
    }

    @Override
    public void detachPage(Page page) {
        this.em.detach((Object)page);
    }
}

