/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.common;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxType;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.Subqueries;

public class AbstractContentService {
    private static final Log LOG = LogFactory.getLog(AbstractContentService.class);

    public <T, U> List<T> findItems(SandBox sandbox, Criteria c, Class<T> baseClass, Class<U> concreteClass, String originalIdProperty) {
        c.add((Criterion)Restrictions.eq((String)"archivedFlag", (Object)false));
        if (sandbox == null) {
            c.add(Restrictions.isNull((String)"sandbox"));
            return c.list();
        }
        if (SandBoxType.PRODUCTION.equals((Object)sandbox.getSandBoxType())) {
            c.add((Criterion)Restrictions.eq((String)"sandbox", (Object)sandbox));
            return c.list();
        }
        this.addSandboxCriteria(sandbox, c, concreteClass, originalIdProperty);
        return c.list();
    }

    public <T> Long countItems(SandBox sandbox, Criteria c, Class<T> concreteClass, String originalIdProperty) {
        c.add((Criterion)Restrictions.eq((String)"archivedFlag", (Object)false));
        c.setProjection(Projections.rowCount());
        if (sandbox == null) {
            c.add(Restrictions.isNull((String)"sandbox"));
            return (Long)c.uniqueResult();
        }
        if (SandBoxType.PRODUCTION.equals((Object)sandbox.getSandBoxType())) {
            c.add((Criterion)Restrictions.eq((String)"sandbox", (Object)sandbox));
            return (Long)c.uniqueResult();
        }
        this.addSandboxCriteria(sandbox, c, concreteClass, originalIdProperty);
        return (Long)c.uniqueResult();
    }

    private <T> void addSandboxCriteria(SandBox sandbox, Criteria c, Class<T> type, String originalIdProperty) {
        SimpleExpression originalSandboxExpression = Restrictions.eq((String)"originalSandBox", (Object)sandbox);
        SimpleExpression currentSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox);
        LogicalExpression userSandboxExpression = Restrictions.or((Criterion)currentSandboxExpression, (Criterion)originalSandboxExpression);
        Object productionSandboxExpression = null;
        productionSandboxExpression = sandbox.getSite() == null || sandbox.getSite().getProductionSandbox() == null ? Restrictions.isNull((String)"sandbox") : Restrictions.eq((String)"sandbox", (Object)sandbox.getSite().getProductionSandbox());
        if (productionSandboxExpression != null) {
            c.add((Criterion)Restrictions.or((Criterion)userSandboxExpression, (Criterion)productionSandboxExpression));
        } else {
            c.add((Criterion)userSandboxExpression);
        }
        DetachedCriteria existsInSboxCriteria = DetachedCriteria.forClass(type, (String)"sboxItem");
        existsInSboxCriteria.add((Criterion)userSandboxExpression);
        existsInSboxCriteria.add((Criterion)Restrictions.eq((String)"archivedFlag", (Object)false));
        String outerAlias = c.getAlias();
        existsInSboxCriteria.add((Criterion)Property.forName((String)(outerAlias + ".id")).eqProperty("sboxItem." + originalIdProperty));
        existsInSboxCriteria.setProjection((Projection)Projections.id());
        c.add(Subqueries.notExists((DetachedCriteria)existsInSboxCriteria));
    }
}

