/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.server.handler;

import com.anasoft.os.daofusion.criteria.PersistentEntityCriteria;
import com.anasoft.os.daofusion.cto.client.CriteriaTransferObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.admin.server.handler.SandBoxItemCustomPersistenceHandler;
import org.broadleafcommerce.openadmin.client.dto.DynamicResultSet;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.server.cto.BaseCtoConverter;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItem;
import org.broadleafcommerce.openadmin.server.security.domain.AdminPermission;
import org.broadleafcommerce.openadmin.server.security.domain.AdminRole;
import org.broadleafcommerce.openadmin.server.security.domain.AdminUser;
import org.broadleafcommerce.openadmin.server.service.persistence.module.RecordHelper;

public class PendingSandBoxItemCustomPersistenceHandler
extends SandBoxItemCustomPersistenceHandler {
    private Log LOG = LogFactory.getLog(PendingSandBoxItemCustomPersistenceHandler.class);

    @Override
    public Boolean canHandleFetch(PersistencePackage persistencePackage) {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        boolean isSandboxItem = SandBoxItem.class.getName().equals(ceilingEntityFullyQualifiedClassname);
        if (isSandboxItem) {
            return persistencePackage.getCustomCriteria()[4].equals("pending");
        }
        return false;
    }

    @Override
    public DynamicResultSet fetch(PersistencePackage persistencePackage, CriteriaTransferObject cto, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        Object[] customCriteria = persistencePackage.getCustomCriteria();
        if (ArrayUtils.isEmpty((Object[])customCriteria) || customCriteria.length != 5) {
            ServiceException e = new ServiceException("Invalid request for entity: " + ceilingEntityFullyQualifiedClassname);
            this.LOG.error((Object)("Invalid request for entity: " + ceilingEntityFullyQualifiedClassname), (Throwable)e);
            throw e;
        }
        AdminUser adminUser = this.adminRemoteSecurityService.getPersistentAdminUser();
        if (adminUser == null) {
            ServiceException e = new ServiceException("Unable to determine current user logged in status");
            this.LOG.error((Object)"Unable to determine current user logged in status", (Throwable)e);
            throw e;
        }
        try {
            List<SandBoxItem> items;
            Object operation = customCriteria[1];
            ArrayList<Long> targets = new ArrayList<Long>();
            if (!StringUtils.isEmpty((String)customCriteria[2])) {
                String[] parts;
                for (String part : parts = ((String)customCriteria[2]).split(",")) {
                    try {
                        targets.add(Long.valueOf(part));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            String requiredPermission = "PERMISSION_ALL_USER_SANDBOX";
            boolean allowOperation = false;
            block5: for (AdminRole role : adminUser.getAllRoles()) {
                for (AdminPermission permission : role.getAllPermissions()) {
                    if (!permission.getName().equals(requiredPermission)) continue;
                    allowOperation = true;
                    continue block5;
                }
            }
            if (!allowOperation) {
                ServiceException e = new ServiceException("Current user does not have permission to perform operation");
                this.LOG.error((Object)"Current user does not have permission to perform operation", (Throwable)e);
                throw e;
            }
            SandBox mySandBox = this.sandBoxService.retrieveUserSandBox(null, adminUser);
            SandBox approvalSandBox = this.sandBoxService.retrieveApprovalSandBox(mySandBox);
            if (((String)operation).equals("releaseAll")) {
                this.sandBoxService.revertAllSandBoxItems(mySandBox, approvalSandBox);
            } else if (((String)operation).equals("releaseSelected")) {
                items = this.retrieveSandBoxItems(targets, dynamicEntityDao, mySandBox);
                this.sandBoxService.revertSelectedSandBoxItems(approvalSandBox, items);
            } else if (((String)operation).equals("reclaimAll")) {
                this.sandBoxService.rejectAllSandBoxItems(mySandBox, approvalSandBox, "reclaiming sandbox items");
            } else if (((String)operation).equals("reclaimSelected")) {
                items = this.retrieveSandBoxItems(targets, dynamicEntityDao, mySandBox);
                this.sandBoxService.rejectSelectedSandBoxItems(approvalSandBox, "reclaiming sandbox item", items);
            }
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map originalProps = helper.getSimpleMergedProperties(SandBoxItem.class.getName(), persistencePerspective);
            cto.get("originalSandBox").setFilterValue(mySandBox.getId().toString());
            cto.get("archivedFlag").setFilterValue(Boolean.FALSE.toString());
            BaseCtoConverter ctoConverter = helper.getCtoConverter(persistencePerspective, cto, SandBoxItem.class.getName(), originalProps);
            PersistentEntityCriteria queryCriteria = ctoConverter.convert(cto, SandBoxItem.class.getName());
            List records = dynamicEntityDao.query(queryCriteria, SandBoxItem.class);
            Entity[] results = helper.getRecords(originalProps, records);
            int totalRecords = helper.getTotalRecords(SandBoxItem.class.getName(), cto, ctoConverter);
            DynamicResultSet response = new DynamicResultSet(results, Integer.valueOf(totalRecords));
            return response;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to execute persistence activity", (Throwable)e);
            throw new ServiceException("Unable to execute persistence activity for entity: " + ceilingEntityFullyQualifiedClassname, (Throwable)e);
        }
    }
}

