/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.client.presenter.structure;

import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.DSCallback;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.rpc.RPCResponse;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.FilterBuilder;
import com.smartgwt.client.widgets.form.fields.FormItem;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.cms.admin.client.datasource.structure.StructuredContentTypeFormListDataSource;
import org.broadleafcommerce.cms.admin.client.presenter.structure.FilterType;
import org.broadleafcommerce.cms.admin.client.presenter.structure.StructuredContentPresenter;
import org.broadleafcommerce.cms.admin.client.presenter.structure.StructuredContentPresenterInitializer;
import org.broadleafcommerce.cms.admin.client.view.structure.StructuredContentDisplay;
import org.broadleafcommerce.openadmin.client.translation.AdvancedCriteriaToMVELTranslator;
import org.broadleafcommerce.openadmin.client.translation.IncompatibleMVELTranslationException;
import org.broadleafcommerce.openadmin.client.view.dynamic.ItemBuilderDisplay;
import org.broadleafcommerce.openadmin.client.view.dynamic.form.FormOnlyView;
import org.broadleafcommerce.openadmin.client.view.dynamic.form.RichTextCanvasItem;
import org.broadleafcommerce.openadmin.client.view.dynamic.form.RichTextHTMLPane;

public class StructuredContentPresenterExtractor {
    private static Map<FilterType, String> MVELKEYWORDMAP = new HashMap<FilterType, String>();
    private static final AdvancedCriteriaToMVELTranslator TRANSLATOR;
    protected StructuredContentPresenter presenter;

    public StructuredContentPresenterExtractor(StructuredContentPresenter presenter) {
        this.presenter = presenter;
    }

    protected StructuredContentDisplay getDisplay() {
        return this.presenter.getDisplay();
    }

    public void removeItemQualifer(final ItemBuilderDisplay builder) {
        if (builder.getRecord() != null) {
            this.presenter.getPresenterSequenceSetupManager().getDataSource("scItemCriteriaDS").removeData(builder.getRecord(), new DSCallback(){

                public void execute(DSResponse response, Object rawData, DSRequest request) {
                    StructuredContentPresenterExtractor.this.getDisplay().removeItemBuilder(builder);
                }
            });
        } else {
            this.getDisplay().removeItemBuilder(builder);
        }
    }

    protected void extractData(Record selectedRecord, Map<String, Object> dirtyValues, String property, FilterBuilder filterBuilder, String keyWord) throws IncompatibleMVELTranslationException {
        this.setData(selectedRecord, property, TRANSLATOR.createMVEL(keyWord, filterBuilder.getCriteria(), filterBuilder.getDataSource()), dirtyValues);
    }

    protected void setData(Record record, String fieldName, Object value, Map<String, Object> dirtyValues) {
        String val;
        String attr = record.getAttribute(fieldName);
        String string = val = value == null ? null : String.valueOf(value);
        if (!(attr == val || attr != null && val != null && attr.equals(val))) {
            record.setAttribute(fieldName, value);
            dirtyValues.put(fieldName, value);
        }
    }

    public void applyData(Record selectedRecord) {
        try {
            final HashMap<String, Object> dirtyValues = new HashMap<String, Object>();
            this.extractData(selectedRecord, dirtyValues, StructuredContentPresenterInitializer.ATTRIBUTEMAP.get((Object)FilterType.CUSTOMER), this.getDisplay().getCustomerFilterBuilder(), MVELKEYWORDMAP.get((Object)FilterType.CUSTOMER));
            this.extractData(selectedRecord, dirtyValues, StructuredContentPresenterInitializer.ATTRIBUTEMAP.get((Object)FilterType.PRODUCT), this.getDisplay().getProductFilterBuilder(), MVELKEYWORDMAP.get((Object)FilterType.PRODUCT));
            this.extractData(selectedRecord, dirtyValues, StructuredContentPresenterInitializer.ATTRIBUTEMAP.get((Object)FilterType.REQUEST), this.getDisplay().getRequestFilterBuilder(), MVELKEYWORDMAP.get((Object)FilterType.REQUEST));
            this.extractData(selectedRecord, dirtyValues, StructuredContentPresenterInitializer.ATTRIBUTEMAP.get((Object)FilterType.TIME), this.getDisplay().getTimeFilterBuilder(), MVELKEYWORDMAP.get((Object)FilterType.TIME));
            this.extractQualifierData(null, true, dirtyValues);
            DSRequest requestProperties = new DSRequest();
            requestProperties.setAttribute("dirtyValues", dirtyValues);
            for (String key : dirtyValues.keySet()) {
                this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().setValue(key, (String)dirtyValues.get(key));
            }
            this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().saveData(new DSCallback(){

                public void execute(DSResponse response, Object rawData, DSRequest request) {
                    if (response.getStatus() != RPCResponse.STATUS_FAILURE) {
                        final String newId = response.getAttribute("newId");
                        FormOnlyView legacyForm = (FormOnlyView)((FormOnlyView)StructuredContentPresenterExtractor.this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay()).getMember("contentTypeForm");
                        DynamicForm form = legacyForm.getForm();
                        for (FormItem formItem : form.getFields()) {
                            if (!(formItem instanceof RichTextCanvasItem)) continue;
                            form.setValue(formItem.getFieldName(), ((RichTextHTMLPane)((RichTextCanvasItem)formItem).getCanvas()).getValue());
                        }
                        StructuredContentTypeFormListDataSource dataSource = (StructuredContentTypeFormListDataSource)form.getDataSource();
                        dataSource.setCustomCriteria(new String[]{"constructForm", newId});
                        form.saveData(new DSCallback(){

                            public void execute(DSResponse response, Object rawData, DSRequest request) {
                                if (response.getStatus() != RPCResponse.STATUS_FAILURE) {
                                    try {
                                        StructuredContentPresenterExtractor.this.extractQualifierData(newId, false, dirtyValues);
                                        StructuredContentPresenterExtractor.this.getDisplay().getDynamicFormDisplay().getSaveButton().disable();
                                        StructuredContentPresenterExtractor.this.getDisplay().getDynamicFormDisplay().getRefreshButton().disable();
                                        StructuredContentPresenterExtractor.this.getDisplay().getStructuredContentSaveButton().disable();
                                        StructuredContentPresenterExtractor.this.getDisplay().getStructuredContentRefreshButton().disable();
                                        if (!StructuredContentPresenterExtractor.this.presenter.currentStructuredContentId.equals(newId)) {
                                            Record myRecord = StructuredContentPresenterExtractor.this.getDisplay().getListDisplay().getGrid().getResultSet().find("id", StructuredContentPresenterExtractor.this.presenter.currentStructuredContentId);
                                            if (myRecord != null) {
                                                myRecord.setAttribute("id", newId);
                                                StructuredContentPresenterExtractor.this.presenter.currentStructuredContentRecord = myRecord;
                                                StructuredContentPresenterExtractor.this.presenter.currentStructuredContentId = newId;
                                            } else {
                                                String primaryKey = StructuredContentPresenterExtractor.this.getDisplay().getListDisplay().getGrid().getDataSource().getPrimaryKeyFieldName();
                                                StructuredContentPresenterExtractor.this.getDisplay().getListDisplay().getGrid().getDataSource().fetchData(new Criteria(primaryKey, newId), new DSCallback(){

                                                    public void execute(DSResponse response, Object rawData, DSRequest request) {
                                                        StructuredContentPresenterExtractor.this.getDisplay().getListDisplay().getGrid().clearCriteria();
                                                        StructuredContentPresenterExtractor.this.getDisplay().getListDisplay().getGrid().setData(response.getData());
                                                        StructuredContentPresenterExtractor.this.getDisplay().getListDisplay().getGrid().selectRecord(0);
                                                    }
                                                });
                                                SC.say((String)"Current item no longer matches the search criteria.  Clearing filter criteria.");
                                            }
                                        }
                                        StructuredContentPresenterExtractor.this.getDisplay().getListDisplay().getGrid().selectRecord(StructuredContentPresenterExtractor.this.getDisplay().getListDisplay().getGrid().getRecordIndex(StructuredContentPresenterExtractor.this.presenter.currentStructuredContentRecord));
                                    }
                                    catch (IncompatibleMVELTranslationException e) {
                                        SC.warn((String)e.getMessage());
                                    }
                                }
                            }
                        });
                    }
                }
            }, requestProperties);
        }
        catch (IncompatibleMVELTranslationException e) {
            SC.warn((String)e.getMessage());
        }
    }

    protected void extractQualifierData(String id, boolean isValidation, Map<String, Object> dirtyValues) throws IncompatibleMVELTranslationException {
        for (final ItemBuilderDisplay builder : this.getDisplay().getItemBuilderViews()) {
            if (!builder.getDirty().booleanValue()) continue;
            String temper = builder.getItemQuantity().getValue().toString();
            Integer quantity = Integer.parseInt(temper);
            String mvel = TRANSLATOR.createMVEL(MVELKEYWORDMAP.get((Object)FilterType.ORDER_ITEM), builder.getItemFilterBuilder().getCriteria(), builder.getItemFilterBuilder().getDataSource());
            if (isValidation) continue;
            if (builder.getRecord() != null) {
                this.setData(builder.getRecord(), "quantity", quantity, dirtyValues);
                this.setData(builder.getRecord(), "orderItemMatchRule", mvel, dirtyValues);
                this.presenter.getPresenterSequenceSetupManager().getDataSource("scItemCriteriaDS").updateData(builder.getRecord(), new DSCallback(){

                    public void execute(DSResponse response, Object rawData, DSRequest request) {
                        builder.setDirty(Boolean.valueOf(false));
                        StructuredContentPresenterExtractor.this.getDisplay().getDynamicFormDisplay().getSaveButton().enable();
                        StructuredContentPresenterExtractor.this.getDisplay().getDynamicFormDisplay().getRefreshButton().enable();
                        StructuredContentPresenterExtractor.this.getDisplay().getStructuredContentSaveButton().enable();
                        StructuredContentPresenterExtractor.this.getDisplay().getStructuredContentRefreshButton().enable();
                    }
                });
                continue;
            }
            final Record temp = new Record();
            temp.setAttribute("quantity", quantity);
            temp.setAttribute("orderItemMatchRule", mvel);
            temp.setAttribute("_type", new String[]{this.presenter.getPresenterSequenceSetupManager().getDataSource("scItemCriteriaDS").getDefaultNewEntityFullyQualifiedClassname()});
            temp.setAttribute("structuredContent", id);
            temp.setAttribute("id", "");
            this.presenter.getPresenterSequenceSetupManager().getDataSource("scItemCriteriaDS").setLinkedValue(id);
            this.presenter.getPresenterSequenceSetupManager().getDataSource("scItemCriteriaDS").addData(temp, new DSCallback(){

                public void execute(DSResponse response, Object rawData, DSRequest request) {
                    builder.setDirty(Boolean.valueOf(false));
                    builder.setRecord(temp);
                    StructuredContentPresenterExtractor.this.getDisplay().getDynamicFormDisplay().getSaveButton().enable();
                    StructuredContentPresenterExtractor.this.getDisplay().getDynamicFormDisplay().getRefreshButton().enable();
                    StructuredContentPresenterExtractor.this.getDisplay().getStructuredContentSaveButton().enable();
                    StructuredContentPresenterExtractor.this.getDisplay().getStructuredContentRefreshButton().enable();
                }
            });
        }
    }

    static {
        MVELKEYWORDMAP.put(FilterType.PRODUCT, "product");
        MVELKEYWORDMAP.put(FilterType.ORDER_ITEM, "discreteOrderItem");
        MVELKEYWORDMAP.put(FilterType.REQUEST, "request");
        MVELKEYWORDMAP.put(FilterType.CUSTOMER, "customer");
        MVELKEYWORDMAP.put(FilterType.TIME, "time");
        TRANSLATOR = new AdvancedCriteriaToMVELTranslator();
    }
}

