/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.web.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.broadleafcommerce.cms.file.service.StaticAssetService;
import org.broadleafcommerce.cms.structure.domain.StructuredContentType;
import org.broadleafcommerce.cms.structure.dto.StructuredContentDTO;
import org.broadleafcommerce.cms.structure.service.StructuredContentService;
import org.broadleafcommerce.cms.web.BroadleafProcessURLFilter;
import org.broadleafcommerce.common.RequestDTO;
import org.broadleafcommerce.common.TimeDTO;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DisplayContentTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    public static final String BLC_RULE_MAP_PARAM = "blRuleMap";
    public static final String REQUEST_DTO = "blRequestDTO";
    private String contentType;
    private String contentName;
    private Object product;
    private Integer count;
    private String contentListVar;
    private String contentItemVar;
    private String numResultsVar;
    private Locale locale;
    private StructuredContentService structuredContentService;
    private StaticAssetService staticAssetService;

    public DisplayContentTag() {
        this.initVariables();
    }

    private Map<String, Object> buildMvelParameters(HttpServletRequest request) {
        TimeDTO timeDto = new TimeDTO(SystemTime.asCalendar());
        RequestDTO requestDto = (RequestDTO)request.getAttribute(REQUEST_DTO);
        HashMap<String, Object> mvelParameters = new HashMap<String, Object>();
        mvelParameters.put("time", timeDto);
        mvelParameters.put("request", requestDto);
        Map blcRuleMap = (Map)request.getAttribute(BLC_RULE_MAP_PARAM);
        if (blcRuleMap != null) {
            for (String mapKey : blcRuleMap.keySet()) {
                mvelParameters.put(mapKey, blcRuleMap.get(mapKey));
            }
        }
        if (this.product != null) {
            mvelParameters.put("product", this.product);
        }
        return mvelParameters;
    }

    protected void initServices() {
        if (this.structuredContentService == null || this.staticAssetService == null) {
            WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.pageContext.getServletContext());
            this.structuredContentService = (StructuredContentService)applicationContext.getBean("blStructuredContentService");
            this.staticAssetService = (StaticAssetService)applicationContext.getBean("blStaticAssetService");
        }
    }

    public boolean isSecure(HttpServletRequest request) {
        boolean secure = false;
        if (request != null) {
            secure = "HTTPS".equalsIgnoreCase(request.getScheme()) || request.isSecure();
        }
        return secure;
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Map<String, Object> mvelParameters = this.buildMvelParameters(request);
        SandBox currentSandbox = (SandBox)request.getAttribute(BroadleafProcessURLFilter.SANDBOX_VAR);
        this.initServices();
        StructuredContentType structuredContentType = this.structuredContentService.findStructuredContentTypeByName(this.contentType);
        if (this.locale == null) {
            this.locale = (Locale)request.getAttribute(BroadleafProcessURLFilter.LOCALE_VAR);
        }
        int cnt = this.count == null ? Integer.MAX_VALUE : this.count;
        List<StructuredContentDTO> contentItems = this.contentName == null || "".equals(this.contentName) ? this.structuredContentService.lookupStructuredContentItemsByType(currentSandbox, structuredContentType, this.locale, cnt, mvelParameters, this.isSecure(request)) : this.structuredContentService.lookupStructuredContentItemsByName(currentSandbox, structuredContentType, this.contentName, this.locale, cnt, mvelParameters, this.isSecure(request));
        this.pageContext.setAttribute(this.getNumResultsVar(), (Object)contentItems.size());
        if (contentItems.size() > 0) {
            ArrayList<Map> contentItemFields = new ArrayList<Map>();
            for (StructuredContentDTO item : contentItems) {
                contentItemFields.add(item.getValues());
            }
            this.pageContext.setAttribute(this.contentItemVar, contentItemFields.get(0));
            this.pageContext.setAttribute(this.contentListVar, contentItemFields);
            this.pageContext.setAttribute("structuredContentList", contentItems);
            this.pageContext.setAttribute(this.numResultsVar, (Object)contentItems.size());
        } else {
            this.pageContext.setAttribute(this.contentItemVar, null);
            this.pageContext.setAttribute(this.contentListVar, null);
            this.pageContext.setAttribute("structuredContentList", null);
            this.pageContext.setAttribute(this.numResultsVar, (Object)0);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        int returnVal = super.doEndTag();
        this.initVariables();
        return returnVal;
    }

    private void initVariables() {
        this.contentType = null;
        this.contentName = null;
        this.product = null;
        this.count = null;
        this.locale = null;
        this.contentListVar = "contentList";
        this.contentItemVar = "contentItem";
        this.numResultsVar = "numResults";
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentName() {
        return this.contentName;
    }

    public void setContentName(String contentName) {
        this.contentName = contentName;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public String getContentListVar() {
        return this.contentListVar;
    }

    public void setContentListVar(String contentVar) {
        this.contentListVar = contentVar;
    }

    public String getContentItemVar() {
        return this.contentItemVar;
    }

    public void setContentItemVar(String contentItemVar) {
        this.contentItemVar = contentItemVar;
    }

    public String getNumResultsVar() {
        return this.numResultsVar;
    }

    public void setNumResultsVar(String numResultsVar) {
        this.numResultsVar = numResultsVar;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Object getProduct() {
        return this.product;
    }

    public void setProduct(Object product) {
        this.product = product;
    }
}

