/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.structure.domain;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.cms.structure.domain.StructuredContent;
import org.broadleafcommerce.cms.structure.domain.StructuredContentField;
import org.broadleafcommerce.cms.structure.domain.StructuredContentImpl;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.openadmin.audit.AdminAuditable;
import org.broadleafcommerce.openadmin.audit.AdminAuditableListener;
import org.hibernate.annotations.Type;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SC_FLD")
@EntityListeners(value={AdminAuditableListener.class})
public class StructuredContentFieldImpl
implements StructuredContentField {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="StructuredContentFieldId", strategy=GenerationType.TABLE)
    @TableGenerator(name="StructuredContentFieldId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="StructuredContentFieldImpl", allocationSize=10)
    @Column(name="SC_FLD_ID")
    protected Long id;
    @Embedded
    @AdminPresentation(excluded=true)
    protected AdminAuditable auditable = new AdminAuditable();
    @Column(name="FLD_KEY")
    protected String fieldKey;
    @ManyToOne(targetEntity=StructuredContentImpl.class)
    @JoinColumn(name="SC_ID")
    protected StructuredContent structuredContent;
    @Column(name="VALUE")
    protected String stringValue;
    @Column(name="LOB_VALUE")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    protected String lobValue;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getFieldKey() {
        return this.fieldKey;
    }

    @Override
    public void setFieldKey(String fieldKey) {
        this.fieldKey = fieldKey;
    }

    @Override
    public StructuredContent getStructuredContent() {
        return this.structuredContent;
    }

    @Override
    public void setStructuredContent(StructuredContent structuredContent) {
        this.structuredContent = structuredContent;
    }

    @Override
    public String getValue() {
        if (this.stringValue != null && this.stringValue.length() > 0) {
            return this.stringValue;
        }
        return this.lobValue;
    }

    @Override
    public void setValue(String value) {
        if (value != null) {
            if (value.length() <= 256) {
                this.stringValue = value;
                this.lobValue = null;
            } else {
                this.stringValue = null;
                this.lobValue = value;
            }
        } else {
            this.lobValue = null;
            this.stringValue = null;
        }
    }

    @Override
    public StructuredContentField cloneEntity() {
        StructuredContentFieldImpl newContentField = new StructuredContentFieldImpl();
        newContentField.fieldKey = this.fieldKey;
        newContentField.structuredContent = this.structuredContent;
        newContentField.lobValue = this.lobValue;
        newContentField.stringValue = this.stringValue;
        return newContentField;
    }

    @Override
    public AdminAuditable getAuditable() {
        return this.auditable;
    }

    @Override
    public void setAuditable(AdminAuditable auditable) {
        this.auditable = auditable;
    }
}

