/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.page.service;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.common.AbstractContentService;
import org.broadleafcommerce.cms.file.service.StaticAssetService;
import org.broadleafcommerce.cms.page.dao.PageDao;
import org.broadleafcommerce.cms.page.domain.Page;
import org.broadleafcommerce.cms.page.domain.PageField;
import org.broadleafcommerce.cms.page.domain.PageImpl;
import org.broadleafcommerce.cms.page.domain.PageTemplate;
import org.broadleafcommerce.cms.page.dto.PageDTO;
import org.broadleafcommerce.cms.page.message.ArchivedPagePublisher;
import org.broadleafcommerce.cms.page.service.PageService;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.openadmin.server.dao.SandBoxDao;
import org.broadleafcommerce.openadmin.server.dao.SandBoxItemDao;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItem;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItemListener;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItemType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxOperationType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxType;
import org.hibernate.Criteria;
import org.springframework.stereotype.Service;

@Service(value="blPageService")
public class PageServiceImpl
extends AbstractContentService
implements PageService,
SandBoxItemListener {
    private static final Log LOG = LogFactory.getLog(PageServiceImpl.class);
    @Resource(name="blPageDao")
    protected PageDao pageDao;
    @Resource(name="blSandBoxItemDao")
    protected SandBoxItemDao sandBoxItemDao;
    @Resource(name="blSandBoxDao")
    protected SandBoxDao sandBoxDao;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;
    @Resource(name="blStaticAssetService")
    protected StaticAssetService staticAssetService;
    protected Cache pageCache;
    protected List<ArchivedPagePublisher> archivedPageListeners;

    @Override
    public Page findPageById(Long pageId) {
        return this.pageDao.readPageById(pageId);
    }

    @Override
    public PageTemplate findPageTemplateById(Long id) {
        return this.pageDao.readPageTemplateById(id);
    }

    @Override
    public Map<String, PageField> findPageFieldsByPageId(Long pageId) {
        Page page = this.findPageById(pageId);
        return this.pageDao.readPageFieldsByPage(page);
    }

    @Override
    public Page addPage(Page page, SandBox destinationSandbox) {
        page.setSandbox(destinationSandbox);
        page.setArchivedFlag(false);
        page.setDeletedFlag(false);
        Page newPage = this.pageDao.addPage(page);
        if (!this.isProductionSandBox(destinationSandbox)) {
            this.sandBoxItemDao.addSandBoxItem(destinationSandbox, SandBoxOperationType.ADD, SandBoxItemType.PAGE, newPage.getFullUrl(), newPage.getId(), null);
        }
        return newPage;
    }

    @Override
    public Page updatePage(Page page, SandBox destSandbox) {
        if (page.getLockedFlag().booleanValue()) {
            throw new IllegalArgumentException("Unable to update a locked record");
        }
        if (this.checkForSandboxMatch(page.getSandbox(), destSandbox)) {
            if (page.getDeletedFlag().booleanValue()) {
                SandBoxItem item = this.sandBoxItemDao.retrieveBySandboxAndTemporaryItemId(page.getSandbox(), SandBoxItemType.PAGE, page.getId());
                if (page.getOriginalPageId() == null) {
                    item.setArchivedFlag(Boolean.valueOf(true));
                    page.setArchivedFlag(true);
                } else {
                    item.setSandBoxOperationType(SandBoxOperationType.DELETE);
                    this.sandBoxItemDao.updateSandBoxItem(item);
                }
            }
            return this.pageDao.updatePage(page);
        }
        if (this.isProductionSandBox(page.getSandbox())) {
            Page clonedPage = page.cloneEntity();
            clonedPage.setOriginalPageId(page.getId());
            clonedPage.setSandbox(destSandbox);
            this.pageDao.detachPage(page);
            Page returnPage = this.pageDao.addPage(clonedPage);
            Page prod = this.findPageById(page.getId());
            prod.setLockedFlag(true);
            this.pageDao.updatePage(prod);
            SandBoxOperationType type = SandBoxOperationType.UPDATE;
            if (clonedPage.getDeletedFlag().booleanValue()) {
                type = SandBoxOperationType.DELETE;
            }
            this.sandBoxItemDao.addSandBoxItem(destSandbox, type, SandBoxItemType.PAGE, clonedPage.getFullUrl(), returnPage.getId(), returnPage.getOriginalPageId());
            return returnPage;
        }
        throw new IllegalArgumentException("Update called when promote or reject was expected.");
    }

    private boolean checkForSandboxMatch(SandBox src, SandBox dest) {
        if (src != null && dest != null) {
            return src.getId().equals(dest.getId());
        }
        return src == null && dest == null;
    }

    private boolean isProductionSandBox(SandBox dest) {
        if (dest == null) {
            return true;
        }
        return SandBoxType.PRODUCTION.equals((Object)dest.getSandBoxType());
    }

    @Override
    public void deletePage(Page page, SandBox destinationSandbox) {
        page.setDeletedFlag(true);
        this.updatePage(page, destinationSandbox);
    }

    private PageDTO buildPageDTO(Page page, boolean secure) {
        String envPrefix;
        PageDTO pageDTO = new PageDTO();
        pageDTO.setId(page.getId());
        pageDTO.setDescription(page.getDescription());
        pageDTO.setUrl(page.getFullUrl());
        if (page.getSandbox() != null) {
            pageDTO.setSandboxId(page.getSandbox().getId());
        }
        if (page.getPageTemplate() != null) {
            pageDTO.setTemplatePath(page.getPageTemplate().getTemplatePath());
            if (page.getPageTemplate().getLocale() != null) {
                pageDTO.setLocaleCode(page.getPageTemplate().getLocale().getLocaleCode());
            }
        }
        if ((envPrefix = this.staticAssetService.getStaticAssetEnvironmentUrlPrefix()) != null && secure) {
            envPrefix = this.staticAssetService.getStaticAssetEnvironmentSecureUrlPrefix();
        }
        String cmsPrefix = this.staticAssetService.getStaticAssetUrlPrefix();
        for (String fieldKey : page.getPageFields().keySet()) {
            PageField pf = page.getPageFields().get(fieldKey);
            String originalValue = pf.getValue();
            if (envPrefix != null && originalValue != null && originalValue.contains(cmsPrefix)) {
                String fldValue = originalValue.replaceAll(cmsPrefix, envPrefix + cmsPrefix);
                pageDTO.getPageFields().put(fieldKey, fldValue);
                continue;
            }
            pageDTO.getPageFields().put(fieldKey, originalValue);
        }
        return pageDTO;
    }

    @Override
    public PageDTO findPageByURI(SandBox currentSandbox, Locale locale, String uri, boolean secure) {
        PageDTO productionPageDTO = null;
        if (uri != null) {
            SandBox productionSandbox = null;
            if (currentSandbox != null && currentSandbox.getSite() != null) {
                productionSandbox = currentSandbox.getSite().getProductionSandbox();
            }
            String key = this.buildKey(productionSandbox, locale, uri);
            productionPageDTO = this.getPageFromCache(key = key + "-" + secure);
            if (productionPageDTO == null) {
                Page productionPage;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Page not found in cache, searching DB for key: " + key));
                }
                if ((productionPage = this.pageDao.findPageByURI(productionSandbox, locale, uri)) != null) {
                    productionPageDTO = this.buildPageDTO(productionPage, secure);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Page found, adding page to cache with key: " + key));
                    }
                    productionPageDTO = this.buildPageDTO(productionPage, secure);
                    this.addPageToCache(productionPageDTO, key);
                } else {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("No match found for passed in URI, locale, and sandbox.  Key = " + key));
                    }
                    productionPageDTO = null;
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Production page found in cache.  Key = " + key));
            }
            if (currentSandbox != null && !currentSandbox.getSandBoxType().equals((Object)SandBoxType.PRODUCTION)) {
                Page sandboxPage = this.pageDao.findPageByURI(currentSandbox, locale, uri);
                if (sandboxPage != null) {
                    if (sandboxPage.getDeletedFlag().booleanValue()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Returning null because user has requested to delete the page in the current SandBox.  Key = " + key));
                        }
                        return null;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Found page in SandBox for key = " + key));
                    }
                    PageDTO sandboxDTO = this.buildPageDTO(sandboxPage, secure);
                    return sandboxDTO;
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Production page found in cache for key = " + key));
            }
        }
        return productionPageDTO;
    }

    @Override
    public List<Page> findPages(SandBox sandbox, Criteria c) {
        return this.findItems(sandbox, c, Page.class, PageImpl.class, "originalPageId");
    }

    @Override
    public Long countPages(SandBox sandbox, Criteria c) {
        return this.countItems(sandbox, c, PageImpl.class, "originalPageId");
    }

    protected void productionItemArchived(Page page) {
        this.removePageFromCache(page);
        if (this.archivedPageListeners != null) {
            for (ArchivedPagePublisher listener : this.archivedPageListeners) {
                listener.processPageArchive(page, this.buildKey(page));
            }
        }
    }

    public void itemPromoted(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.PAGE.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        Page page = this.pageDao.readPageById(sandBoxItem.getTemporaryItemId());
        if (page == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Page not found " + sandBoxItem.getTemporaryItemId()));
            }
        } else {
            boolean productionSandBox = this.isProductionSandBox(destinationSandBox);
            if (productionSandBox) {
                page.setLockedFlag(false);
            } else {
                page.setLockedFlag(true);
            }
            if (productionSandBox && page.getOriginalPageId() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Page promoted to production.  " + page.getId() + ".  Archiving original page " + page.getOriginalPageId()));
                }
                Page originalPage = this.pageDao.readPageById(page.getOriginalPageId());
                originalPage.setArchivedFlag(Boolean.TRUE);
                this.pageDao.updatePage(originalPage);
                this.productionItemArchived(originalPage);
                page.setOriginalPageId(null);
                if (page.getDeletedFlag().booleanValue()) {
                    page.setArchivedFlag(true);
                }
            }
        }
        if (page.getOriginalSandBox() == null) {
            page.setOriginalSandBox(page.getSandbox());
        }
        page.setSandbox(destinationSandBox);
        this.pageDao.updatePage(page);
    }

    public void itemRejected(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.PAGE.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        Page page = this.pageDao.readPageById(sandBoxItem.getTemporaryItemId());
        if (page != null) {
            page.setSandbox(destinationSandBox);
            page.setOriginalSandBox(null);
            page.setLockedFlag(false);
            this.pageDao.updatePage(page);
        }
    }

    public void itemReverted(SandBoxItem sandBoxItem) {
        if (!SandBoxItemType.PAGE.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        Page page = this.pageDao.readPageById(sandBoxItem.getTemporaryItemId());
        if (page != null) {
            page.setArchivedFlag(Boolean.TRUE);
            page.setLockedFlag(false);
            this.pageDao.updatePage(page);
            if (page.getOriginalPageId() != null) {
                Page originalPage = this.pageDao.readPageById(page.getOriginalPageId());
                originalPage.setLockedFlag(false);
                this.pageDao.updatePage(originalPage);
            }
        }
    }

    private Cache getPageCache() {
        if (this.pageCache == null) {
            this.pageCache = CacheManager.getInstance().getCache("cmsPageCache");
        }
        return this.pageCache;
    }

    private String buildKey(SandBox currentSandbox, Locale locale, String uri) {
        StringBuffer key = new StringBuffer(uri);
        if (locale != null) {
            key.append("-").append(locale.getLocaleCode());
        }
        if (currentSandbox != null) {
            key.append("-").append(currentSandbox.getId());
        }
        return key.toString();
    }

    private String buildKey(Page page) {
        return this.buildKey(page.getSandbox(), page.getPageTemplate().getLocale(), page.getFullUrl());
    }

    private void addPageToCache(PageDTO page, String key) {
        this.getPageCache().put(new Element((Serializable)((Object)key), (Serializable)page));
    }

    private PageDTO getPageFromCache(String key) {
        Element cacheElement = this.getPageCache().get((Serializable)((Object)key));
        if (cacheElement != null) {
            return (PageDTO)this.getPageCache().get((Serializable)((Object)key)).getValue();
        }
        return null;
    }

    public void removePageFromCache(Page p) {
        this.removePageFromCache(this.buildKey(p));
    }

    @Override
    public void removePageFromCache(String baseKey) {
        this.getPageCache().remove((Serializable)((Object)(baseKey + "-" + true)));
        this.getPageCache().remove((Serializable)((Object)(baseKey + "-" + false)));
    }

    @Override
    public List<ArchivedPagePublisher> getArchivedPageListeners() {
        return this.archivedPageListeners;
    }

    @Override
    public void setArchivedPageListeners(List<ArchivedPagePublisher> archivedPageListeners) {
        this.archivedPageListeners = archivedPageListeners;
    }
}

