/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.file.dao;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.cms.file.dao.StaticAssetStorageDao;
import org.broadleafcommerce.cms.file.domain.StaticAssetStorage;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.hibernate.ejb.HibernateEntityManager;
import org.springframework.stereotype.Repository;
import org.springframework.web.multipart.MultipartFile;

@Repository(value="blStaticAssetStorageDao")
public class StaticAssetStorageDaoImpl
implements StaticAssetStorageDao {
    @PersistenceContext(unitName="blCMSStorage")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public StaticAssetStorage create() {
        return (StaticAssetStorage)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.cms.file.domain.StaticAssetStorage");
    }

    @Override
    public Blob createBlob(MultipartFile uploadedFile) throws IOException {
        Long size = uploadedFile.getSize();
        InputStream inputStream = uploadedFile.getInputStream();
        return ((HibernateEntityManager)this.em).getSession().getLobHelper().createBlob(inputStream, size.longValue());
    }

    @Override
    public StaticAssetStorage readStaticAssetStorageById(Long id) {
        return (StaticAssetStorage)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.cms.file.domain.StaticAssetStorage"), (Object)id);
    }

    @Override
    public StaticAssetStorage readStaticAssetStorageByStaticAssetId(Long id) {
        Query query = this.em.createNamedQuery("BC_READ_STATIC_ASSET_STORAGE_BY_STATIC_ASSET_ID");
        query.setParameter("id", (Object)id);
        return (StaticAssetStorage)query.getSingleResult();
    }

    @Override
    public StaticAssetStorage save(StaticAssetStorage assetStorage) {
        if (this.em.contains((Object)assetStorage)) {
            return (StaticAssetStorage)this.em.merge((Object)assetStorage);
        }
        this.em.persist((Object)assetStorage);
        this.em.flush();
        return assetStorage;
    }

    @Override
    public void delete(StaticAssetStorage assetStorage) {
        if (!this.em.contains((Object)assetStorage)) {
            assetStorage = this.readStaticAssetStorageById(assetStorage.getId());
        }
        this.em.remove((Object)assetStorage);
    }
}

