/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.server.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.TimeDTO;
import org.broadleafcommerce.openadmin.client.dto.ClassMetadata;
import org.broadleafcommerce.openadmin.client.dto.DynamicResultSet;
import org.broadleafcommerce.openadmin.client.dto.MergedPropertyType;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.service.handler.CustomPersistenceHandlerAdapter;
import org.broadleafcommerce.openadmin.server.service.persistence.module.InspectHelper;

public class TimeDTOCustomPersistenceHandler
extends CustomPersistenceHandlerAdapter {
    private static final Log LOG = LogFactory.getLog(TimeDTOCustomPersistenceHandler.class);

    public Boolean canHandleFetch(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleAdd(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleRemove(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleUpdate(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleInspect(PersistencePackage persistencePackage) {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        return TimeDTO.class.getName().equals(ceilingEntityFullyQualifiedClassname);
    }

    public DynamicResultSet inspect(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, InspectHelper helper) throws ServiceException {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        try {
            HashMap<MergedPropertyType, Map> allMergedProperties = new HashMap<MergedPropertyType, Map>();
            Map mergedProperties = dynamicEntityDao.getSimpleMergedProperties(ceilingEntityFullyQualifiedClassname, persistencePackage.getPersistencePerspective());
            allMergedProperties.put(MergedPropertyType.PRIMARY, mergedProperties);
            ClassMetadata mergedMetadata = helper.getMergedClassMetadata(new Class[]{Class.forName(ceilingEntityFullyQualifiedClassname)}, allMergedProperties);
            DynamicResultSet results = new DynamicResultSet(mergedMetadata);
            return results;
        }
        catch (Exception e) {
            ServiceException ex = new ServiceException("Unable to retrieve inspection results for " + persistencePackage.getCeilingEntityFullyQualifiedClassname(), (Throwable)e);
            LOG.error((Object)("Unable to retrieve inspection results for " + persistencePackage.getCeilingEntityFullyQualifiedClassname()), (Throwable)ex);
            throw ex;
        }
    }
}

