/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.server.handler;

import com.anasoft.os.daofusion.criteria.PersistentEntityCriteria;
import com.anasoft.os.daofusion.cto.client.CriteriaTransferObject;
import com.anasoft.os.daofusion.cto.client.FilterAndSortCriteria;
import com.anasoft.os.daofusion.cto.server.CriteriaTransferObjectCountWrapper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.page.domain.Page;
import org.broadleafcommerce.cms.page.domain.PageImpl;
import org.broadleafcommerce.cms.page.domain.PageTemplate;
import org.broadleafcommerce.cms.page.domain.PageTemplateImpl;
import org.broadleafcommerce.cms.page.service.PageService;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.openadmin.client.dto.ClassMetadata;
import org.broadleafcommerce.openadmin.client.dto.DynamicResultSet;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.FieldMetadata;
import org.broadleafcommerce.openadmin.client.dto.FieldPresentationAttributes;
import org.broadleafcommerce.openadmin.client.dto.ForeignKey;
import org.broadleafcommerce.openadmin.client.dto.MergedPropertyType;
import org.broadleafcommerce.openadmin.client.dto.OperationType;
import org.broadleafcommerce.openadmin.client.dto.OperationTypes;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.dto.Property;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.server.cto.BaseCtoConverter;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.service.SandBoxContext;
import org.broadleafcommerce.openadmin.server.service.handler.CustomPersistenceHandlerAdapter;
import org.broadleafcommerce.openadmin.server.service.persistence.PersistenceManager;
import org.broadleafcommerce.openadmin.server.service.persistence.SandBoxService;
import org.broadleafcommerce.openadmin.server.service.persistence.module.InspectHelper;
import org.broadleafcommerce.openadmin.server.service.persistence.module.RecordHelper;
import org.hibernate.Criteria;

public class PagesCustomPersistenceHandler
extends CustomPersistenceHandlerAdapter {
    private static final Log LOG = LogFactory.getLog(PagesCustomPersistenceHandler.class);
    @Resource(name="blPageService")
    protected PageService pageService;
    @Resource(name="blSandBoxService")
    protected SandBoxService sandBoxService;
    private static Map<String, FieldMetadata> mergedProperties;

    protected synchronized Map<String, FieldMetadata> getModifiedProperties() {
        return mergedProperties;
    }

    public Boolean canHandleFetch(PersistencePackage persistencePackage) {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        return Page.class.getName().equals(ceilingEntityFullyQualifiedClassname);
    }

    public Boolean canHandleAdd(PersistencePackage persistencePackage) {
        return this.canHandleFetch(persistencePackage);
    }

    public Boolean canHandleRemove(PersistencePackage persistencePackage) {
        return this.canHandleFetch(persistencePackage);
    }

    public Boolean canHandleUpdate(PersistencePackage persistencePackage) {
        return this.canHandleFetch(persistencePackage);
    }

    public Boolean canHandleInspect(PersistencePackage persistencePackage) {
        return this.canHandleFetch(persistencePackage);
    }

    protected SandBox getSandBox() {
        return this.sandBoxService.retrieveSandboxById(SandBoxContext.getSandBoxContext().getSandBoxId());
    }

    public Entity add(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Page adminInstance = (Page)Class.forName(entity.getType()[0]).newInstance();
            Map adminProperties = helper.getSimpleMergedProperties(Page.class.getName(), persistencePerspective);
            adminInstance = (Page)helper.createPopulatedInstance((Serializable)adminInstance, entity, adminProperties, Boolean.valueOf(false));
            adminInstance = this.pageService.addPage(adminInstance, this.getSandBox());
            Entity adminEntity = helper.getRecord(adminProperties, (Serializable)adminInstance, null, null);
            if (adminEntity.findProperty("pageTemplate") != null) {
                Property property = new Property();
                property.setName("pageTemplate_Grid");
                property.setValue(adminEntity.findProperty("pageTemplate").getValue());
                adminEntity.addProperty(property);
            }
            return adminEntity;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to add entity for " + entity.getType()[0]), (Throwable)e);
            throw new ServiceException("Unable to add entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    public DynamicResultSet fetch(PersistencePackage persistencePackage, CriteriaTransferObject cto, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        try {
            Entity[] pageEntities;
            if (cto.get("pageTemplate_Grid").getFilterValues().length > 0) {
                CriteriaTransferObject ctoCopy = new CriteriaTransferObject();
                for (String prop : cto.getPropertyIdSet()) {
                    String propertyId = prop.equals("pageTemplate_Grid") ? "pageTemplate" : prop;
                    FilterAndSortCriteria criteria = ctoCopy.get(propertyId);
                    FilterAndSortCriteria oldCriteria = cto.get(prop);
                    criteria.setFilterValue(oldCriteria.getFilterValues()[0]);
                    criteria.setIgnoreCase(oldCriteria.getIgnoreCase());
                    criteria.setSortAscending(oldCriteria.getIgnoreCase());
                }
                cto = ctoCopy;
            }
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map originalProps = helper.getSimpleMergedProperties(Page.class.getName(), persistencePerspective);
            BaseCtoConverter ctoConverter = helper.getCtoConverter(persistencePerspective, cto, Page.class.getName(), originalProps);
            PersistentEntityCriteria queryCriteria = ctoConverter.convert(cto, Page.class.getName());
            PersistentEntityCriteria countCriteria = ctoConverter.convert(new CriteriaTransferObjectCountWrapper(cto).wrap(), Page.class.getName());
            Criteria criteria = dynamicEntityDao.getCriteria(queryCriteria, Page.class);
            Criteria count = dynamicEntityDao.getCriteria(countCriteria, Page.class);
            List<Page> pages = this.pageService.findPages(this.getSandBox(), criteria);
            Long totalRecords = this.pageService.countPages(this.getSandBox(), count);
            ArrayList<Page> convertedList = new ArrayList<Page>();
            convertedList.addAll(pages);
            for (Entity entity : pageEntities = helper.getRecords(originalProps, convertedList)) {
                Property property;
                if (entity.findProperty("pageTemplate") != null) {
                    property = new Property();
                    property.setName("pageTemplate_Grid");
                    property.setValue(entity.findProperty("pageTemplate").getValue());
                    entity.addProperty(property);
                }
                if (!"true".equals(entity.findProperty("lockedFlag").getValue())) continue;
                property = new Property();
                property.setName("locked");
                property.setValue("[ISOMORPHIC]/../admin/images/lock_page.png");
                entity.addProperty(property);
            }
            DynamicResultSet response = new DynamicResultSet(pageEntities, Integer.valueOf(totalRecords.intValue()));
            return response;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to perform fetch for entity: " + ceilingEntityFullyQualifiedClassname), (Throwable)e);
            throw new ServiceException("Unable to perform fetch for entity: " + ceilingEntityFullyQualifiedClassname, (Throwable)e);
        }
    }

    protected Map<String, FieldMetadata> getMergedProperties(Class<?> ceilingEntityFullyQualifiedClass, DynamicEntityDao dynamicEntityDao, Boolean populateManyToOneFields, String[] includeManyToOneFields, String[] excludeManyToOneFields, String configurationKey, ForeignKey[] additionalForeignKeys) throws ClassNotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] entities = dynamicEntityDao.getAllPolymorphicEntitiesFromCeiling(ceilingEntityFullyQualifiedClass);
        Map mergedProperties = dynamicEntityDao.getMergedProperties(ceilingEntityFullyQualifiedClass.getName(), entities, null, new String[0], additionalForeignKeys, MergedPropertyType.PRIMARY, populateManyToOneFields, includeManyToOneFields, excludeManyToOneFields, configurationKey, "");
        return mergedProperties;
    }

    protected synchronized void createModifiedProperties(DynamicEntityDao dynamicEntityDao, InspectHelper helper, PersistencePerspective persistencePerspective) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, ServiceException, NoSuchFieldException {
        mergedProperties = helper.getSimpleMergedProperties(Page.class.getName(), persistencePerspective);
        FieldMetadata contentTypeFieldMetadata = new FieldMetadata();
        contentTypeFieldMetadata.setFieldType(SupportedFieldType.EXPLICIT_ENUMERATION);
        contentTypeFieldMetadata.setMutable(Boolean.valueOf(true));
        contentTypeFieldMetadata.setInheritedFromType(PageTemplateImpl.class.getName());
        contentTypeFieldMetadata.setAvailableToTypes(new String[]{PageTemplateImpl.class.getName()});
        contentTypeFieldMetadata.setCollection(Boolean.valueOf(false));
        contentTypeFieldMetadata.setMergedPropertyType(MergedPropertyType.PRIMARY);
        PersistencePackage pageTemplatePersistencePackage = new PersistencePackage();
        pageTemplatePersistencePackage.setCeilingEntityFullyQualifiedClassname(PageTemplate.class.getName());
        PersistencePerspective pageTemplateFetchPerspective = new PersistencePerspective();
        pageTemplatePersistencePackage.setPersistencePerspective(pageTemplateFetchPerspective);
        pageTemplateFetchPerspective.setAdditionalForeignKeys(new ForeignKey[0]);
        pageTemplateFetchPerspective.setOperationTypes(new OperationTypes(OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY));
        pageTemplateFetchPerspective.setAdditionalNonPersistentProperties(new String[0]);
        DynamicResultSet pageTemplateResultSet = ((PersistenceManager)helper).fetch(pageTemplatePersistencePackage, new CriteriaTransferObject());
        String[][] pageTemplateEnums = new String[pageTemplateResultSet.getRecords().length][2];
        int i = 0;
        for (Entity entity : pageTemplateResultSet.getRecords()) {
            pageTemplateEnums[i][0] = entity.findProperty("id").getValue();
            pageTemplateEnums[i][1] = entity.findProperty("templateName").getValue();
            ++i;
        }
        contentTypeFieldMetadata.setEnumerationValues(pageTemplateEnums);
        FieldPresentationAttributes contentTypeAttributes = new FieldPresentationAttributes();
        contentTypeFieldMetadata.setPresentationAttributes(contentTypeAttributes);
        contentTypeAttributes.setName("pageTemplate_Grid");
        contentTypeAttributes.setFriendlyName("Page Template");
        contentTypeAttributes.setGroup("Description");
        contentTypeAttributes.setOrder(Integer.valueOf(2));
        contentTypeAttributes.setExplicitFieldType(SupportedFieldType.UNKNOWN);
        contentTypeAttributes.setProminent(Boolean.valueOf(false));
        contentTypeAttributes.setBroadleafEnumeration("");
        contentTypeAttributes.setReadOnly(Boolean.valueOf(false));
        contentTypeAttributes.setVisibility(VisibilityEnum.FORM_HIDDEN);
        contentTypeAttributes.setRequiredOverride(Boolean.valueOf(true));
        mergedProperties.put("pageTemplate_Grid", contentTypeFieldMetadata);
        FieldMetadata iconMetadata = new FieldMetadata();
        iconMetadata.setFieldType(SupportedFieldType.ASSET);
        iconMetadata.setMutable(Boolean.valueOf(true));
        iconMetadata.setInheritedFromType(PageImpl.class.getName());
        iconMetadata.setAvailableToTypes(new String[]{PageImpl.class.getName()});
        iconMetadata.setCollection(Boolean.valueOf(false));
        iconMetadata.setMergedPropertyType(MergedPropertyType.PRIMARY);
        FieldPresentationAttributes iconAttributes = new FieldPresentationAttributes();
        iconMetadata.setPresentationAttributes(iconAttributes);
        iconAttributes.setName("picture");
        iconAttributes.setFriendlyName(" ");
        iconAttributes.setGroup("Locked Details");
        iconAttributes.setExplicitFieldType(SupportedFieldType.UNKNOWN);
        iconAttributes.setProminent(Boolean.valueOf(true));
        iconAttributes.setBroadleafEnumeration("");
        iconAttributes.setReadOnly(Boolean.valueOf(false));
        iconAttributes.setVisibility(VisibilityEnum.FORM_HIDDEN);
        iconAttributes.setColumnWidth("25");
        iconAttributes.setOrder(Integer.valueOf(0));
        iconAttributes.setRequiredOverride(Boolean.valueOf(true));
        mergedProperties.put("locked", iconMetadata);
    }

    public DynamicResultSet inspect(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, InspectHelper helper) throws ServiceException {
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            HashMap<MergedPropertyType, Map<String, FieldMetadata>> allMergedProperties = new HashMap<MergedPropertyType, Map<String, FieldMetadata>>();
            if (this.getModifiedProperties() == null) {
                this.createModifiedProperties(dynamicEntityDao, helper, persistencePerspective);
            }
            Map<String, FieldMetadata> originalProps = this.getModifiedProperties();
            allMergedProperties.put(MergedPropertyType.PRIMARY, originalProps);
            Class[] entityClasses = dynamicEntityDao.getAllPolymorphicEntitiesFromCeiling(Page.class);
            ClassMetadata mergedMetadata = helper.getMergedClassMetadata(entityClasses, allMergedProperties);
            DynamicResultSet results = new DynamicResultSet(mergedMetadata, null, null);
            return results;
        }
        catch (Exception e) {
            ServiceException ex = new ServiceException("Unable to retrieve inspection results for " + persistencePackage.getCeilingEntityFullyQualifiedClassname(), (Throwable)e);
            LOG.error((Object)("Unable to retrieve inspection results for " + persistencePackage.getCeilingEntityFullyQualifiedClassname()), (Throwable)ex);
            throw ex;
        }
    }

    public Entity update(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map adminProperties = helper.getSimpleMergedProperties(Page.class.getName(), persistencePerspective);
            Object primaryKey = helper.getPrimaryKey(entity, adminProperties);
            Page adminInstance = (Page)dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            adminInstance = (Page)helper.createPopulatedInstance((Serializable)adminInstance, entity, adminProperties, Boolean.valueOf(false));
            adminInstance = this.pageService.updatePage(adminInstance, this.getSandBox());
            Entity adminEntity = helper.getRecord(adminProperties, (Serializable)adminInstance, null, null);
            if (adminEntity.findProperty("pageTemplate") != null) {
                Property property = new Property();
                property.setName("pageTemplate_Grid");
                property.setValue(adminEntity.findProperty("pageTemplate").getValue());
                adminEntity.addProperty(property);
            }
            return adminEntity;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to update entity for " + entity.getType()[0]), (Throwable)e);
            throw new ServiceException("Unable to update entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    public void remove(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map adminProperties = helper.getSimpleMergedProperties(Page.class.getName(), persistencePerspective);
            Object primaryKey = helper.getPrimaryKey(entity, adminProperties);
            Serializable persistenceObject = dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            Page adminInstance = (Page)persistenceObject;
            this.pageService.deletePage(adminInstance, this.getSandBox());
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to remove entity for " + entity.getType()[0]), (Throwable)e);
            throw new ServiceException("Unable to remove entity for " + entity.getType()[0], (Throwable)e);
        }
    }
}

