/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.client.presenter.pages;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.DSCallback;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.rpc.RPCResponse;
import com.smartgwt.client.types.Overflow;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.events.FetchDataEvent;
import com.smartgwt.client.widgets.events.FetchDataHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.events.ItemChangedEvent;
import com.smartgwt.client.widgets.form.events.ItemChangedHandler;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import org.broadleafcommerce.cms.admin.client.datasource.pages.PageDataSourceFactory;
import org.broadleafcommerce.cms.admin.client.datasource.pages.PageTemplateFormListDataSource;
import org.broadleafcommerce.cms.admin.client.datasource.pages.PageTemplateFormListDataSourceFactory;
import org.broadleafcommerce.cms.admin.client.datasource.pages.PageTemplateSearchListDataSourceFactory;
import org.broadleafcommerce.cms.admin.client.presenter.HtmlEditingPresenter;
import org.broadleafcommerce.cms.admin.client.view.pages.PagesDisplay;
import org.broadleafcommerce.openadmin.client.BLCMain;
import org.broadleafcommerce.openadmin.client.datasource.DataSourceFactory;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.ListGridDataSource;
import org.broadleafcommerce.openadmin.client.dto.OperationType;
import org.broadleafcommerce.openadmin.client.dto.OperationTypes;
import org.broadleafcommerce.openadmin.client.presenter.entity.FormItemCallback;
import org.broadleafcommerce.openadmin.client.reflection.Instantiable;
import org.broadleafcommerce.openadmin.client.setup.AsyncCallbackAdapter;
import org.broadleafcommerce.openadmin.client.setup.PresenterSetupItem;
import org.broadleafcommerce.openadmin.client.view.dynamic.dialog.EntitySearchDialog;
import org.broadleafcommerce.openadmin.client.view.dynamic.form.FormOnlyView;
import org.broadleafcommerce.openadmin.client.view.dynamic.form.RichTextCanvasItem;
import org.broadleafcommerce.openadmin.client.view.dynamic.form.RichTextHTMLPane;

public class PagesPresenter
extends HtmlEditingPresenter
implements Instantiable {
    protected HandlerRegistration saveButtonHandlerRegistration;
    protected HandlerRegistration refreshButtonHandlerRegistration;
    protected Record currentPageRecord;
    protected String currentPageId;
    protected EntitySearchDialog pageTemplateDialogView;

    protected void removeClicked() {
        ListGridRecord selectedRecord = this.display.getListDisplay().getGrid().getSelectedRecord();
        String primaryKey = this.display.getListDisplay().getGrid().getDataSource().getPrimaryKeyFieldName();
        String id = selectedRecord.getAttribute(primaryKey);
        this.display.getListDisplay().getGrid().removeSelectedData(new DSCallback(){

            public void execute(DSResponse response, Object rawData, DSRequest request) {
                if (PagesPresenter.this.getDisplay().getListDisplay().getGrid().getResultSet() == null) {
                    PagesPresenter.this.getDisplay().getListDisplay().getGrid().setData(new Record[0]);
                }
                PagesPresenter.this.destroyTemplateForm();
                PagesPresenter.this.formPresenter.disable();
                PagesPresenter.this.display.getListDisplay().getRemoveButton().disable();
            }
        }, null);
    }

    protected void destroyTemplateForm() {
        Canvas legacyForm = ((FormOnlyView)this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay()).getMember("pageTemplateForm");
        if (legacyForm != null) {
            legacyForm.destroy();
        }
    }

    protected void changeSelection(Record selectedRecord) {
        if (!selectedRecord.getAttributeAsBoolean("lockedFlag").booleanValue()) {
            this.getDisplay().getListDisplay().getRemoveButton().enable();
            this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().enable();
        } else {
            this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().disable();
            this.getDisplay().getListDisplay().getRemoveButton().disable();
        }
        this.currentPageRecord = selectedRecord;
        this.currentPageId = this.getPresenterSequenceSetupManager().getDataSource("pageDS").getPrimaryKeyValue(this.currentPageRecord);
        this.loadTemplateForm(selectedRecord);
    }

    protected void loadTemplateForm(final Record selectedRecord) {
        BLCMain.NON_MODAL_PROGRESS.startProgress();
        PageTemplateFormListDataSourceFactory.createDataSource("pageTemplateFormDS", new String[]{"constructForm", selectedRecord.getAttribute("pageTemplate")}, (AsyncCallback<DataSource>)new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource dataSource) {
                PagesPresenter.this.destroyTemplateForm();
                final FormOnlyView formOnlyView = new FormOnlyView(dataSource, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                formOnlyView.getForm().addItemChangedHandler(new ItemChangedHandler(){

                    public void onItemChanged(ItemChangedEvent event) {
                        PagesPresenter.this.getDisplay().getDynamicFormDisplay().getSaveButton().enable();
                        PagesPresenter.this.getDisplay().getDynamicFormDisplay().getRefreshButton().enable();
                    }
                });
                formOnlyView.setID("pageTemplateForm");
                formOnlyView.setOverflow(Overflow.VISIBLE);
                ((FormOnlyView)PagesPresenter.this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay()).addMember((Canvas)formOnlyView);
                ((PageTemplateFormListDataSource)dataSource).setCustomCriteria(new String[]{"constructForm", selectedRecord.getAttribute("id")});
                BLCMain.NON_MODAL_PROGRESS.startProgress();
                formOnlyView.getForm().fetchData(new Criteria(), new DSCallback(){

                    public void execute(DSResponse response, Object rawData, DSRequest request) {
                        if (!selectedRecord.getAttributeAsBoolean("lockedFlag").booleanValue()) {
                            formOnlyView.getForm().enable();
                        }
                        for (FormItem formItem : formOnlyView.getForm().getFields()) {
                            if (!(formItem instanceof RichTextCanvasItem)) continue;
                            formItem.setValue(formOnlyView.getForm().getValue(formItem.getFieldName()));
                        }
                    }
                });
            }
        });
    }

    @Override
    public void bind() {
        super.bind();
        this.getSaveButtonHandlerRegistration().removeHandler();
        this.formPresenter.getRefreshButtonHandlerRegistration().removeHandler();
        this.refreshButtonHandlerRegistration = this.getDisplay().getDynamicFormDisplay().getRefreshButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    PagesPresenter.this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().reset();
                    FormOnlyView legacyForm = (FormOnlyView)((FormOnlyView)PagesPresenter.this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay()).getMember("pageTemplateForm");
                    if (legacyForm != null) {
                        legacyForm.getForm().reset();
                    }
                    for (FormItem formItem : legacyForm.getForm().getFields()) {
                        if (!(formItem instanceof RichTextCanvasItem)) continue;
                        formItem.setValue(legacyForm.getForm().getValue(formItem.getFieldName()));
                    }
                    PagesPresenter.this.getDisplay().getDynamicFormDisplay().getSaveButton().disable();
                    PagesPresenter.this.getDisplay().getDynamicFormDisplay().getRefreshButton().disable();
                }
            }
        });
        this.saveButtonHandlerRegistration = this.getDisplay().getDynamicFormDisplay().getSaveButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    DSRequest requestProperties = new DSRequest();
                    requestProperties.setAttribute("dirtyValues", PagesPresenter.this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getChangedValues());
                    PagesPresenter.this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().saveData(new DSCallback(){

                        public void execute(DSResponse response, Object rawData, DSRequest request) {
                            if (response.getStatus() != RPCResponse.STATUS_FAILURE) {
                                final String newId = response.getAttribute("newId");
                                FormOnlyView legacyForm = (FormOnlyView)((FormOnlyView)PagesPresenter.this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay()).getMember("pageTemplateForm");
                                DynamicForm form = legacyForm.getForm();
                                for (FormItem formItem : form.getFields()) {
                                    if (!(formItem instanceof RichTextCanvasItem)) continue;
                                    form.setValue(formItem.getFieldName(), ((RichTextHTMLPane)((RichTextCanvasItem)formItem).getCanvas()).getValue());
                                }
                                PageTemplateFormListDataSource dataSource = (PageTemplateFormListDataSource)form.getDataSource();
                                dataSource.setCustomCriteria(new String[]{"constructForm", newId});
                                form.saveData(new DSCallback(){

                                    public void execute(DSResponse response, Object rawData, DSRequest request) {
                                        if (response.getStatus() != RPCResponse.STATUS_FAILURE) {
                                            PagesPresenter.this.getDisplay().getDynamicFormDisplay().getSaveButton().disable();
                                            PagesPresenter.this.getDisplay().getDynamicFormDisplay().getRefreshButton().disable();
                                            if (!PagesPresenter.this.currentPageId.equals(newId)) {
                                                Record myRecord = PagesPresenter.this.getDisplay().getListDisplay().getGrid().getResultSet().find("id", PagesPresenter.this.currentPageId);
                                                if (myRecord != null) {
                                                    myRecord.setAttribute("id", newId);
                                                    PagesPresenter.this.currentPageRecord = myRecord;
                                                    PagesPresenter.this.currentPageId = newId;
                                                } else {
                                                    String primaryKey = PagesPresenter.this.getDisplay().getListDisplay().getGrid().getDataSource().getPrimaryKeyFieldName();
                                                    PagesPresenter.this.getDisplay().getListDisplay().getGrid().getDataSource().fetchData(new Criteria(primaryKey, newId), new DSCallback(){

                                                        public void execute(DSResponse response, Object rawData, DSRequest request) {
                                                            PagesPresenter.this.getDisplay().getListDisplay().getGrid().clearCriteria();
                                                            PagesPresenter.this.getDisplay().getListDisplay().getGrid().setData(response.getData());
                                                            PagesPresenter.this.getDisplay().getListDisplay().getGrid().selectRecord(0);
                                                        }
                                                    });
                                                    SC.say((String)"Current item no longer matches the search criteria.  Clearing filter criteria.");
                                                }
                                            }
                                            PagesPresenter.this.getDisplay().getListDisplay().getGrid().selectRecord(PagesPresenter.this.getDisplay().getListDisplay().getGrid().getRecordIndex(PagesPresenter.this.currentPageRecord));
                                        }
                                    }
                                });
                            }
                        }
                    }, requestProperties);
                }
            }
        });
        this.display.getListDisplay().getGrid().addFetchDataHandler(new FetchDataHandler(){

            public void onFilterData(FetchDataEvent event) {
                PagesPresenter.this.destroyTemplateForm();
            }
        });
    }

    @Override
    public void setup() {
        super.setup();
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("pageDS", (DataSourceFactory)new PageDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource top) {
                PagesPresenter.this.setupDisplayItems(top, new DataSource[0]);
                ((ListGridDataSource)top).setupGridFields(new String[]{"locked", "fullUrl", "description", "pageTemplate_Grid"});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("pageTemplateSearchDS", (DataSourceFactory)new PageTemplateSearchListDataSourceFactory(), new OperationTypes(OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY, OperationType.ENTITY), new Object[0], new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                EntitySearchDialog pageTemplateSearchView;
                ListGridDataSource pageTemplateDataSource = (ListGridDataSource)result;
                pageTemplateDataSource.resetPermanentFieldVisibility(new String[]{"templateName", "templatePath"});
                PagesPresenter.this.pageTemplateDialogView = pageTemplateSearchView = new EntitySearchDialog(pageTemplateDataSource, true);
                PagesPresenter.this.getPresenterSequenceSetupManager().getDataSource("pageDS").getFormItemCallbackHandlerManager().addSearchFormItemCallback("pageTemplate", pageTemplateSearchView, "Page Template Search", PagesPresenter.this.getDisplay().getDynamicFormDisplay(), new FormItemCallback(){

                    public void execute(FormItem formItem) {
                        if (PagesPresenter.this.currentPageRecord != null && BLCMain.ENTITY_ADD.getHidden().booleanValue()) {
                            PagesPresenter.this.destroyTemplateForm();
                            PagesPresenter.this.loadTemplateForm(PagesPresenter.this.currentPageRecord);
                        }
                    }
                });
            }
        }));
    }

    public PagesDisplay getDisplay() {
        return (PagesDisplay)this.display;
    }
}

