/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.web.file;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.file.service.StaticAssetStorageService;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.service.persistence.SandBoxService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class StaticAssetViewController
extends AbstractController {
    private static final Log LOG = LogFactory.getLog(StaticAssetViewController.class);
    private static final String SANDBOX_ADMIN_ID_VAR = "blAdminCurrentSandboxId";
    private static final String SANDBOX_ID_VAR = "blSandboxId";
    private String assetServerUrlPrefix;
    private String viewResolverName;
    @Resource(name="blStaticAssetStorageService")
    protected StaticAssetStorageService staticAssetStorageService;
    @Resource(name="blSandBoxService")
    protected SandBoxService sandBoxService;

    protected Map<String, String> convertParameterMap(Map<String, String[]> parameterMap) {
        HashMap<String, String> convertedMap = new HashMap<String, String>(parameterMap.size());
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            convertedMap.put(entry.getKey(), StringUtils.join((Object[])entry.getValue(), (char)','));
        }
        return convertedMap;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fullUrl = this.removeAssetPrefix(request.getRequestURI());
        try {
            Long sandBoxId = (Long)request.getSession().getAttribute(SANDBOX_ID_VAR);
            if (sandBoxId == null) {
                sandBoxId = (Long)request.getSession().getAttribute(SANDBOX_ADMIN_ID_VAR);
            }
            SandBox sandBox = null;
            if (sandBoxId != null) {
                sandBox = this.sandBoxService.retrieveSandboxById(sandBoxId);
            }
            Map<String, String> model = this.staticAssetStorageService.getCacheFileModel(fullUrl, sandBox, this.convertParameterMap(request.getParameterMap()));
            return new ModelAndView(this.viewResolverName, model);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to retrieve static asset", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String removeAssetPrefix(String requestURI) {
        int pos;
        String fileName = requestURI;
        if (this.assetServerUrlPrefix != null && !(fileName = fileName.substring((pos = fileName.indexOf(this.assetServerUrlPrefix)) + this.assetServerUrlPrefix.length())).startsWith("/")) {
            fileName = "/" + fileName;
        }
        return fileName;
    }

    public String getAssetServerUrlPrefix() {
        return this.assetServerUrlPrefix;
    }

    public void setAssetServerUrlPrefix(String assetServerUrlPrefix) {
        this.assetServerUrlPrefix = assetServerUrlPrefix;
    }

    public String getViewResolverName() {
        return this.viewResolverName;
    }

    public void setViewResolverName(String viewResolverName) {
        this.viewResolverName = viewResolverName;
    }
}

