/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.structure.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.common.AbstractContentService;
import org.broadleafcommerce.cms.file.service.StaticAssetService;
import org.broadleafcommerce.cms.structure.dao.StructuredContentDao;
import org.broadleafcommerce.cms.structure.domain.StructuredContent;
import org.broadleafcommerce.cms.structure.domain.StructuredContentField;
import org.broadleafcommerce.cms.structure.domain.StructuredContentImpl;
import org.broadleafcommerce.cms.structure.domain.StructuredContentItemCriteria;
import org.broadleafcommerce.cms.structure.domain.StructuredContentRule;
import org.broadleafcommerce.cms.structure.domain.StructuredContentType;
import org.broadleafcommerce.cms.structure.dto.ItemCriteriaDTO;
import org.broadleafcommerce.cms.structure.dto.StructuredContentDTO;
import org.broadleafcommerce.cms.structure.message.ArchivedStructuredContentPublisher;
import org.broadleafcommerce.cms.structure.service.StructuredContentRuleProcessor;
import org.broadleafcommerce.cms.structure.service.StructuredContentService;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.openadmin.server.dao.SandBoxDao;
import org.broadleafcommerce.openadmin.server.dao.SandBoxItemDao;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItem;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItemType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxOperationType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxType;
import org.hibernate.Criteria;
import org.springframework.stereotype.Service;

@Service(value="blStructuredContentService")
public class StructuredContentServiceImpl
extends AbstractContentService
implements StructuredContentService {
    private static final Log LOG = LogFactory.getLog(StructuredContentServiceImpl.class);
    private static String AND = " && ";
    @Resource(name="blStructuredContentDao")
    protected StructuredContentDao structuredContentDao;
    @Resource(name="blSandBoxItemDao")
    protected SandBoxItemDao sandBoxItemDao;
    @Resource(name="blSandBoxDao")
    protected SandBoxDao sandBoxDao;
    @Resource(name="blStaticAssetService")
    protected StaticAssetService staticAssetService;
    private List<StructuredContentRuleProcessor> contentRuleProcessors;
    protected Cache structuredContentCache;
    protected List<ArchivedStructuredContentPublisher> archivedStructuredContentListeners;

    @Override
    public StructuredContent findStructuredContentById(Long contentId) {
        return this.structuredContentDao.findStructuredContentById(contentId);
    }

    @Override
    public StructuredContentType findStructuredContentTypeById(Long id) {
        return this.structuredContentDao.findStructuredContentTypeById(id);
    }

    @Override
    public StructuredContentType findStructuredContentTypeByName(String name) {
        return this.structuredContentDao.findStructuredContentTypeByName(name);
    }

    @Override
    public List<StructuredContentType> retrieveAllStructuredContentTypes() {
        return this.structuredContentDao.retrieveAllStructuredContentTypes();
    }

    @Override
    public Map<String, StructuredContentField> findFieldsByContentId(Long contentId) {
        StructuredContent sc = this.findStructuredContentById(contentId);
        return this.structuredContentDao.readFieldsForStructuredContentItem(sc);
    }

    @Override
    public List<StructuredContent> findContentItems(SandBox sandbox, Criteria c) {
        return this.findItems(sandbox, c, StructuredContent.class, StructuredContentImpl.class, "originalItemId");
    }

    @Override
    public Long countContentItems(SandBox sandbox, Criteria c) {
        return this.countItems(sandbox, c, StructuredContentImpl.class, "originalItemId");
    }

    @Override
    public StructuredContent addStructuredContent(StructuredContent content, SandBox destinationSandbox) {
        content.setSandbox(destinationSandbox);
        content.setArchivedFlag(false);
        content.setDeletedFlag(false);
        StructuredContent sc = this.structuredContentDao.addOrUpdateContentItem(content);
        if (!this.isProductionSandBox(destinationSandbox)) {
            this.sandBoxItemDao.addSandBoxItem(destinationSandbox, SandBoxOperationType.ADD, SandBoxItemType.STRUCTURED_CONTENT, sc.getContentName(), sc.getId(), null);
        }
        return sc;
    }

    @Override
    public StructuredContent updateStructuredContent(StructuredContent content, SandBox destSandbox) {
        if (content.getLockedFlag().booleanValue()) {
            throw new IllegalArgumentException("Unable to update a locked record");
        }
        if (this.checkForSandboxMatch(content.getSandbox(), destSandbox)) {
            if (content.getDeletedFlag().booleanValue()) {
                SandBoxItem item = this.sandBoxItemDao.retrieveBySandboxAndTemporaryItemId(content.getSandbox(), SandBoxItemType.STRUCTURED_CONTENT, content.getId());
                if (content.getOriginalItemId() == null) {
                    content.setArchivedFlag(true);
                    item.setArchivedFlag(Boolean.valueOf(true));
                } else {
                    item.setSandBoxOperationType(SandBoxOperationType.DELETE);
                    this.sandBoxItemDao.updateSandBoxItem(item);
                }
            }
            return this.structuredContentDao.addOrUpdateContentItem(content);
        }
        if (this.checkForProductionSandbox(content.getSandbox())) {
            StructuredContent clonedContent = content.cloneEntity();
            clonedContent.setOriginalItemId(content.getId());
            clonedContent.setSandbox(destSandbox);
            this.structuredContentDao.detach(content);
            StructuredContent returnContent = this.structuredContentDao.addOrUpdateContentItem(clonedContent);
            StructuredContent prod = this.findStructuredContentById(content.getId());
            prod.setLockedFlag(true);
            prod = this.structuredContentDao.addOrUpdateContentItem(prod);
            SandBoxOperationType type = SandBoxOperationType.UPDATE;
            if (clonedContent.getDeletedFlag().booleanValue()) {
                type = SandBoxOperationType.DELETE;
            }
            this.sandBoxItemDao.addSandBoxItem(destSandbox, type, SandBoxItemType.STRUCTURED_CONTENT, returnContent.getContentName(), returnContent.getId(), returnContent.getOriginalItemId());
            return returnContent;
        }
        throw new IllegalArgumentException("Update called when promote or reject was expected.");
    }

    private boolean checkForSandboxMatch(SandBox src, SandBox dest) {
        if (src != null && dest != null) {
            return src.getId().equals(dest.getId());
        }
        return src == null && dest == null;
    }

    private boolean checkForProductionSandbox(SandBox dest) {
        boolean productionSandbox = false;
        if (dest == null) {
            productionSandbox = true;
        } else if (dest.getSite() != null && dest.getSite().getProductionSandbox() != null && dest.getSite().getProductionSandbox().getId() != null) {
            productionSandbox = dest.getSite().getProductionSandbox().getId().equals(dest.getId());
        }
        return productionSandbox;
    }

    @Override
    public void deleteStructuredContent(StructuredContent content, SandBox destinationSandbox) {
        content.setDeletedFlag(true);
        this.updateStructuredContent(content, destinationSandbox);
    }

    private String buildRuleExpression(StructuredContent sc) {
        StringBuffer ruleExpression = null;
        Map<String, StructuredContentRule> ruleMap = sc.getStructuredContentMatchRules();
        if (ruleMap != null) {
            for (String ruleKey : ruleMap.keySet()) {
                if (ruleExpression == null) {
                    ruleExpression = new StringBuffer(ruleMap.get(ruleKey).getMatchRule());
                    continue;
                }
                ruleExpression.append(AND);
                ruleExpression.append(ruleMap.get(ruleKey).getMatchRule());
            }
        }
        if (ruleExpression != null) {
            return ruleExpression.toString();
        }
        return null;
    }

    private List<ItemCriteriaDTO> buildItemCriteriaDTOList(StructuredContent sc) {
        ArrayList<ItemCriteriaDTO> itemCriteriaDTOList = new ArrayList<ItemCriteriaDTO>();
        for (StructuredContentItemCriteria criteria : sc.getQualifyingItemCriteria()) {
            ItemCriteriaDTO criteriaDTO = new ItemCriteriaDTO();
            criteriaDTO.setMatchRule(criteria.getOrderItemMatchRule());
            criteriaDTO.setQty(criteria.getQuantity());
            itemCriteriaDTOList.add(criteriaDTO);
        }
        return itemCriteriaDTOList;
    }

    private void buildFieldValues(StructuredContent sc, StructuredContentDTO scDTO, boolean secure) {
        String envPrefix = this.staticAssetService.getStaticAssetEnvironmentUrlPrefix();
        if (envPrefix != null && secure) {
            envPrefix = this.staticAssetService.getStaticAssetEnvironmentSecureUrlPrefix();
        }
        String cmsPrefix = this.staticAssetService.getStaticAssetUrlPrefix();
        for (String fieldKey : sc.getStructuredContentFields().keySet()) {
            StructuredContentField scf = sc.getStructuredContentFields().get(fieldKey);
            String originalValue = scf.getValue();
            if (envPrefix != null && originalValue != null && originalValue.contains(cmsPrefix)) {
                if (originalValue.startsWith("/")) {
                    originalValue = originalValue.substring(1);
                }
                String fldValue = originalValue.replaceAll(cmsPrefix, envPrefix + cmsPrefix);
                scDTO.getValues().put(fieldKey, fldValue);
                continue;
            }
            scDTO.getValues().put(fieldKey, originalValue);
        }
    }

    protected List<StructuredContentDTO> buildStructuredContentDTOList(List<StructuredContent> structuredContentList, boolean secure) {
        ArrayList<StructuredContentDTO> dtoList = new ArrayList<StructuredContentDTO>();
        if (structuredContentList != null) {
            for (StructuredContent sc : structuredContentList) {
                dtoList.add(this.buildStructuredContentDTO(sc, secure));
            }
        }
        return dtoList;
    }

    protected StructuredContentDTO buildStructuredContentDTO(StructuredContent sc, boolean secure) {
        StructuredContentDTO scDTO = new StructuredContentDTO();
        scDTO.setContentName(sc.getContentName());
        scDTO.setContentType(sc.getStructuredContentType().getName());
        scDTO.setId(sc.getId());
        scDTO.setPriority(sc.getPriority());
        if (sc.getLocale() != null) {
            scDTO.setLocaleCode(sc.getLocale().getLocaleCode());
        }
        if (sc.getSandbox() != null) {
            scDTO.setSandboxId(sc.getSandbox().getId());
        }
        scDTO.setRuleExpression(this.buildRuleExpression(sc));
        this.buildFieldValues(sc, scDTO, secure);
        if (sc.getQualifyingItemCriteria() != null && sc.getQualifyingItemCriteria().size() > 0) {
            scDTO.setItemCriteriaDTOList(this.buildItemCriteriaDTOList(sc));
        }
        return scDTO;
    }

    private List<StructuredContentDTO> mergeContent(List<StructuredContentDTO> productionList, List<StructuredContent> sandboxList, boolean secure) {
        if (sandboxList == null || sandboxList.size() == 0) {
            return productionList;
        }
        LinkedHashMap<Long, StructuredContentDTO> scMap = new LinkedHashMap<Long, StructuredContentDTO>();
        if (productionList != null) {
            for (StructuredContentDTO structuredContentDTO : productionList) {
                scMap.put(structuredContentDTO.getId(), structuredContentDTO);
            }
        }
        for (StructuredContent structuredContent : sandboxList) {
            if (structuredContent.getOriginalItemId() != null) {
                scMap.remove(structuredContent.getOriginalItemId());
            }
            if (structuredContent.getDeletedFlag().booleanValue() || structuredContent.getOfflineFlag().booleanValue()) continue;
            StructuredContentDTO convertedItem = this.buildStructuredContentDTO(structuredContent, secure);
            scMap.put(structuredContent.getId(), convertedItem);
        }
        ArrayList<StructuredContentDTO> returnList = new ArrayList<StructuredContentDTO>(scMap.values());
        if (returnList.size() > 1) {
            Collections.sort(returnList, new BeanComparator("priority"));
        }
        return returnList;
    }

    private List<StructuredContentDTO> evaluateAndPriortizeContent(List<StructuredContentDTO> structuredContentList, int count, Map<String, Object> ruleDTOs) {
        if (structuredContentList.size() == 1) {
            if (this.processContentRules(structuredContentList.get(0), ruleDTOs)) {
                return structuredContentList;
            }
            return new ArrayList<StructuredContentDTO>();
        }
        Iterator<StructuredContentDTO> structuredContentIterator = structuredContentList.iterator();
        ArrayList<StructuredContentDTO> returnList = new ArrayList<StructuredContentDTO>();
        ArrayList<StructuredContentDTO> tmpList = new ArrayList<StructuredContentDTO>();
        Integer lastPriority = Integer.MIN_VALUE;
        while (structuredContentIterator.hasNext()) {
            StructuredContentDTO sc = structuredContentIterator.next();
            if (!lastPriority.equals(sc.getPriority())) {
                if (tmpList.size() > 1) {
                    Collections.shuffle(tmpList);
                }
                returnList.addAll(tmpList);
                tmpList.clear();
                if (returnList.size() == count) {
                    return returnList;
                }
                if (returnList.size() > count) {
                    return returnList.subList(0, count);
                }
                if (this.processContentRules(sc, ruleDTOs)) {
                    tmpList.add(sc);
                }
            } else if (this.processContentRules(sc, ruleDTOs)) {
                tmpList.add(sc);
            }
            lastPriority = sc.getPriority();
        }
        if (tmpList.size() > 1) {
            Collections.shuffle(tmpList);
        }
        returnList.addAll(tmpList);
        if (returnList.size() > count) {
            return returnList.subList(0, count);
        }
        return returnList;
    }

    private boolean processContentRules(StructuredContentDTO sc, Map<String, Object> ruleDTOs) {
        if (this.contentRuleProcessors != null) {
            for (StructuredContentRuleProcessor processor : this.contentRuleProcessors) {
                boolean matchFound = processor.checkForMatch(sc, ruleDTOs);
                if (matchFound) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<StructuredContentDTO> lookupStructuredContentItemsByType(SandBox sandBox, StructuredContentType contentType, Locale locale, Integer count, Map<String, Object> ruleDTOs, boolean secure) {
        List<StructuredContentDTO> contentList;
        List<StructuredContent> productionContentList;
        List<StructuredContent> sandBoxContentList = null;
        String cacheKey = this.buildTypeKey(this.getProductionSandBox(sandBox), locale, contentType.getName());
        List<StructuredContentDTO> productionContentDTOList = this.getStructuredContentListFromCache(cacheKey = cacheKey + "-" + secure);
        if (productionContentDTOList == null && (productionContentDTOList = this.buildStructuredContentDTOList(productionContentList = this.structuredContentDao.findActiveStructuredContentByType(this.getProductionSandBox(sandBox), contentType, locale), secure)) != null) {
            this.addStructuredContentListToCache(cacheKey, productionContentDTOList);
        }
        if (!this.isProductionSandBox(sandBox)) {
            sandBoxContentList = this.structuredContentDao.findActiveStructuredContentByType(sandBox, contentType, locale);
            contentList = this.mergeContent(productionContentDTOList, sandBoxContentList, secure);
        } else {
            contentList = productionContentDTOList;
        }
        return this.evaluateAndPriortizeContent(contentList, count, ruleDTOs);
    }

    @Override
    public List<StructuredContentDTO> lookupStructuredContentItemsByName(SandBox sandBox, StructuredContentType contentType, String contentName, Locale locale, Integer count, Map<String, Object> ruleDTOs, boolean secure) {
        List<StructuredContentDTO> contentList;
        List<StructuredContent> productionContentList;
        List<StructuredContent> sandBoxContentList = null;
        String cacheKey = this.buildNameKey(this.getProductionSandBox(sandBox), locale, contentType.getName(), contentName);
        List<StructuredContentDTO> productionContentDTOList = this.getStructuredContentListFromCache(cacheKey = cacheKey + "-" + secure);
        if (productionContentDTOList == null && (productionContentDTOList = this.buildStructuredContentDTOList(productionContentList = this.structuredContentDao.findActiveStructuredContentByNameAndType(this.getProductionSandBox(sandBox), contentType, contentName, locale), secure)) != null) {
            this.addStructuredContentListToCache(cacheKey, productionContentDTOList);
        }
        if (!this.isProductionSandBox(sandBox)) {
            sandBoxContentList = this.structuredContentDao.findActiveStructuredContentByNameAndType(sandBox, contentType, contentName, locale);
            contentList = this.mergeContent(productionContentDTOList, sandBoxContentList, secure);
        } else {
            contentList = productionContentDTOList;
        }
        return this.evaluateAndPriortizeContent(contentList, count, ruleDTOs);
    }

    private SandBox getProductionSandBox(SandBox currentSandBox) {
        SandBox productionSandBox = null;
        if (currentSandBox == null || SandBoxType.PRODUCTION.equals((Object)currentSandBox.getSandBoxType())) {
            productionSandBox = currentSandBox;
        } else if (currentSandBox.getSite() != null) {
            productionSandBox = currentSandBox.getSite().getProductionSandbox();
        }
        return productionSandBox;
    }

    private boolean isProductionSandBox(SandBox dest) {
        if (dest == null) {
            return true;
        }
        return SandBoxType.PRODUCTION.equals((Object)dest.getSandBoxType());
    }

    protected void productionItemArchived(StructuredContent sc) {
        this.removeStructuredContentFromCache(sc);
        if (this.archivedStructuredContentListeners != null) {
            for (ArchivedStructuredContentPublisher listener : this.archivedStructuredContentListeners) {
                listener.processStructuredContentArchive(sc, this.buildTypeKey(sc), this.buildNameKey(sc));
            }
        }
    }

    public void itemPromoted(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.STRUCTURED_CONTENT.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StructuredContent sc = this.structuredContentDao.findStructuredContentById(sandBoxItem.getTemporaryItemId());
        if (sc == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Structured Content Item not found " + sandBoxItem.getTemporaryItemId()));
            }
        } else {
            boolean productionSandBox = this.isProductionSandBox(destinationSandBox);
            if (productionSandBox) {
                sc.setLockedFlag(false);
            } else {
                sc.setLockedFlag(true);
            }
            if (productionSandBox && sc.getOriginalItemId() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Structured content promoted to production.  " + sc.getId() + ".  Archiving original item " + sc.getOriginalItemId()));
                }
                StructuredContent originalSC = this.structuredContentDao.findStructuredContentById(sc.getOriginalItemId());
                originalSC.setArchivedFlag(Boolean.TRUE);
                this.structuredContentDao.addOrUpdateContentItem(originalSC);
                this.productionItemArchived(originalSC);
                if (sc.getDeletedFlag().booleanValue()) {
                    sc.setArchivedFlag(true);
                }
                sc.setOriginalItemId(null);
            }
        }
        if (sc.getOriginalSandBox() == null) {
            sc.setOriginalSandBox(sc.getSandbox());
        }
        sc.setSandbox(destinationSandBox);
        this.structuredContentDao.addOrUpdateContentItem(sc);
    }

    public void itemRejected(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.STRUCTURED_CONTENT.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StructuredContent sc = this.structuredContentDao.findStructuredContentById(sandBoxItem.getTemporaryItemId());
        if (sc != null) {
            sc.setSandbox(destinationSandBox);
            sc.setOriginalSandBox(null);
            sc.setLockedFlag(false);
            this.structuredContentDao.addOrUpdateContentItem(sc);
        }
    }

    public void itemReverted(SandBoxItem sandBoxItem) {
        if (!SandBoxItemType.STRUCTURED_CONTENT.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StructuredContent sc = this.structuredContentDao.findStructuredContentById(sandBoxItem.getTemporaryItemId());
        if (sc != null && sandBoxItem.getOriginalItemId() != null) {
            sc.setArchivedFlag(Boolean.TRUE);
            sc.setLockedFlag(Boolean.FALSE);
            this.structuredContentDao.addOrUpdateContentItem(sc);
            StructuredContent originalSc = this.structuredContentDao.findStructuredContentById(sandBoxItem.getOriginalItemId());
            originalSc.setLockedFlag(false);
            this.structuredContentDao.addOrUpdateContentItem(originalSc);
        }
    }

    public List<StructuredContentRuleProcessor> getContentRuleProcessors() {
        return this.contentRuleProcessors;
    }

    public void setContentRuleProcessors(List<StructuredContentRuleProcessor> contentRuleProcessors) {
        this.contentRuleProcessors = contentRuleProcessors;
    }

    private Cache getStructuredContentCache() {
        if (this.structuredContentCache == null) {
            this.structuredContentCache = CacheManager.getInstance().getCache("cmsStructuredContentCache");
        }
        return this.structuredContentCache;
    }

    private String buildNameKey(StructuredContent sc) {
        return this.buildNameKey(sc.getSandbox(), sc.getLocale(), sc.getStructuredContentType().getName(), sc.getContentName());
    }

    private String buildTypeKey(StructuredContent sc) {
        return this.buildTypeKey(sc.getSandbox(), sc.getLocale(), sc.getStructuredContentType().getName());
    }

    private String buildNameKey(SandBox currentSandbox, Locale locale, String contentType, String contentName) {
        StringBuffer key = new StringBuffer(contentType).append("-").append(contentName);
        if (locale != null) {
            key.append("-").append(locale.getLocaleCode());
        }
        if (currentSandbox != null) {
            key.append("-").append(currentSandbox.getId());
        }
        return key.toString();
    }

    private String buildTypeKey(SandBox currentSandbox, Locale locale, String contentType) {
        StringBuffer key = new StringBuffer(contentType);
        if (locale != null) {
            key.append("-").append(locale.getLocaleCode());
        }
        if (currentSandbox != null) {
            key.append("-").append(currentSandbox.getId());
        }
        return key.toString();
    }

    private void addStructuredContentListToCache(String key, List<StructuredContentDTO> scDTOList) {
        this.getStructuredContentCache().put(new Element((Object)key, scDTOList));
    }

    private List<StructuredContentDTO> getStructuredContentListFromCache(String key) {
        Element scElement = this.getStructuredContentCache().get((Serializable)((Object)key));
        if (scElement != null) {
            return (List)((Object)scElement.getValue());
        }
        return null;
    }

    public void removeStructuredContentFromCache(StructuredContent sc) {
        this.removeItemFromCache(this.buildNameKey(sc), this.buildTypeKey(sc));
    }

    @Override
    public void removeItemFromCache(String nameKey, String typeKey) {
        this.getStructuredContentCache().remove((Serializable)((Object)(nameKey + "-" + true)));
        this.getStructuredContentCache().remove((Serializable)((Object)(nameKey + "-" + false)));
        this.getStructuredContentCache().remove((Serializable)((Object)(typeKey + "-" + true)));
        this.getStructuredContentCache().remove((Serializable)((Object)(typeKey + "-" + false)));
    }

    public List<ArchivedStructuredContentPublisher> getArchivedStructuredContentListeners() {
        return this.archivedStructuredContentListeners;
    }

    public void setArchivedStructuredContentListeners(List<ArchivedStructuredContentPublisher> archivedStructuredContentListeners) {
        this.archivedStructuredContentListeners = archivedStructuredContentListeners;
    }
}

