/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.structure.service;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.structure.dto.StructuredContentDTO;
import org.broadleafcommerce.cms.structure.service.AbstractStructuredContentRuleProcessor;
import org.springframework.stereotype.Service;

@Service(value="blContentDefaultRuleProcessor")
public class StructuredContentDefaultRuleProcessor
extends AbstractStructuredContentRuleProcessor {
    private static final Log LOG = LogFactory.getLog(StructuredContentDefaultRuleProcessor.class);

    @Override
    public boolean checkForMatch(StructuredContentDTO sc, Map<String, Object> vars) {
        String ruleExpression = sc.getRuleExpression();
        if (ruleExpression != null) {
            boolean result;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Processing content rule for StructuredContent with id " + sc.getId() + ".   Value = " + ruleExpression));
            }
            if (!(result = this.executeExpression(ruleExpression, vars).booleanValue()) && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Content failed to pass rule and will not be included for StructuredContent with id " + sc.getId() + ".   Value = " + ruleExpression));
            }
            return result;
        }
        return true;
    }
}

