/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.structure.message.jms;

import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.broadleafcommerce.cms.structure.domain.StructuredContent;
import org.broadleafcommerce.cms.structure.message.ArchivedStructuredContentPublisher;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class JMSArchivedStructuredContentPublisher
implements ArchivedStructuredContentPublisher {
    private JmsTemplate archiveStructuredContentTemplate;
    private Destination archiveStructuredContentDestination;

    @Override
    public void processStructuredContentArchive(StructuredContent sc, final String baseNameKey, final String baseTypeKey) {
        this.archiveStructuredContentTemplate.send(this.archiveStructuredContentDestination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                HashMap<String, String> objectMap = new HashMap<String, String>(2);
                objectMap.put("nameKey", baseNameKey);
                objectMap.put("typeKey", baseTypeKey);
                return session.createObjectMessage(objectMap);
            }
        });
    }

    public JmsTemplate getArchiveStructuredContentTemplate() {
        return this.archiveStructuredContentTemplate;
    }

    public void setArchiveStructuredContentTemplate(JmsTemplate archiveStructuredContentTemplate) {
        this.archiveStructuredContentTemplate = archiveStructuredContentTemplate;
    }

    public Destination getArchiveStructuredContentDestination() {
        return this.archiveStructuredContentDestination;
    }

    public void setArchiveStructuredContentDestination(Destination archiveStructuredContentDestination) {
        this.archiveStructuredContentDestination = archiveStructuredContentDestination;
    }
}

