/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.page.message.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.broadleafcommerce.cms.page.domain.Page;
import org.broadleafcommerce.cms.page.message.ArchivedPagePublisher;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class JMSArchivedPagePublisher
implements ArchivedPagePublisher {
    private JmsTemplate archivePageTemplate;
    private Destination archivePageDestination;

    @Override
    public void processPageArchive(Page page, final String basePageKey) {
        this.archivePageTemplate.send(this.archivePageDestination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return session.createTextMessage(basePageKey);
            }
        });
    }

    public JmsTemplate getArchivePageTemplate() {
        return this.archivePageTemplate;
    }

    public void setArchivePageTemplate(JmsTemplate archivePageTemplate) {
        this.archivePageTemplate = archivePageTemplate;
    }

    public Destination getArchivePageDestination() {
        return this.archivePageDestination;
    }

    public void setArchivePageDestination(Destination archivePageDestination) {
        this.archivePageDestination = archivePageDestination;
    }
}

