/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.file.service;

import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.tools.view.ImportSupport;
import org.broadleafcommerce.cms.common.AbstractContentService;
import org.broadleafcommerce.cms.file.dao.StaticAssetDao;
import org.broadleafcommerce.cms.file.domain.StaticAsset;
import org.broadleafcommerce.cms.file.domain.StaticAssetImpl;
import org.broadleafcommerce.cms.file.service.StaticAssetService;
import org.broadleafcommerce.cms.file.service.StaticAssetStorageService;
import org.broadleafcommerce.openadmin.server.dao.SandBoxItemDao;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItem;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItemType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxOperationType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxType;
import org.hibernate.Criteria;
import org.springframework.stereotype.Service;

@Service(value="blStaticAssetService")
public class StaticAssetServiceImpl
extends AbstractContentService
implements StaticAssetService {
    private static final Log LOG = LogFactory.getLog(StaticAssetServiceImpl.class);
    protected String staticAssetUrlPrefix;
    protected String staticAssetEnvironmentUrlPrefix;
    protected String staticAssetEnvironmentSecureUrlPrefix;
    protected boolean automaticallyApproveAndPromoteStaticAssets = true;
    @Resource(name="blStaticAssetDao")
    protected StaticAssetDao staticAssetDao;
    @Resource(name="blSandBoxItemDao")
    protected SandBoxItemDao sandBoxItemDao;
    @Resource(name="blStaticAssetStorageService")
    protected StaticAssetStorageService staticAssetStorageService;

    @Override
    public StaticAsset findStaticAssetById(Long id) {
        return this.staticAssetDao.readStaticAssetById(id);
    }

    @Override
    public StaticAsset findStaticAssetByFullUrl(String fullUrl, SandBox targetSandBox) {
        return this.staticAssetDao.readStaticAssetByFullUrl(fullUrl, targetSandBox);
    }

    @Override
    public StaticAsset addStaticAsset(StaticAsset staticAsset, SandBox destinationSandbox) {
        if (this.automaticallyApproveAndPromoteStaticAssets) {
            destinationSandbox = destinationSandbox != null && destinationSandbox.getSite() != null ? destinationSandbox.getSite().getProductionSandbox() : null;
        }
        staticAsset.setSandbox((SandBox)destinationSandbox);
        staticAsset.setDeletedFlag(false);
        staticAsset.setArchivedFlag(false);
        StaticAsset newAsset = this.staticAssetDao.addOrUpdateStaticAsset(staticAsset, true);
        if (!this.isProductionSandBox((SandBox)destinationSandbox)) {
            this.sandBoxItemDao.addSandBoxItem(destinationSandbox, SandBoxOperationType.ADD, SandBoxItemType.STATIC_ASSET, newAsset.getFullUrl(), newAsset.getId(), null);
        }
        return newAsset;
    }

    @Override
    public StaticAsset updateStaticAsset(StaticAsset staticAsset, SandBox destSandbox) {
        if (staticAsset.getLockedFlag().booleanValue()) {
            throw new IllegalArgumentException("Unable to update a locked record");
        }
        if (this.automaticallyApproveAndPromoteStaticAssets) {
            destSandbox = destSandbox != null && destSandbox.getSite() != null ? destSandbox.getSite().getProductionSandbox() : null;
        }
        if (this.checkForSandboxMatch(staticAsset.getSandbox(), (SandBox)destSandbox)) {
            if (staticAsset.getDeletedFlag().booleanValue()) {
                SandBoxItem item = this.sandBoxItemDao.retrieveBySandboxAndTemporaryItemId(staticAsset.getSandbox(), SandBoxItemType.STATIC_ASSET, staticAsset.getId());
                if (staticAsset.getOriginalAssetId() == null && item != null) {
                    staticAsset.setArchivedFlag(true);
                    item.setArchivedFlag(Boolean.valueOf(true));
                } else if (item != null) {
                    item.setSandBoxOperationType(SandBoxOperationType.DELETE);
                    this.sandBoxItemDao.updateSandBoxItem(item);
                } else if (this.automaticallyApproveAndPromoteStaticAssets) {
                    staticAsset.setArchivedFlag(true);
                }
            }
            return this.staticAssetDao.addOrUpdateStaticAsset(staticAsset, true);
        }
        if (this.isProductionSandBox(staticAsset.getSandbox())) {
            StaticAsset clonedAsset = staticAsset.cloneEntity();
            clonedAsset.setOriginalAssetId(staticAsset.getId());
            clonedAsset.setSandbox((SandBox)destSandbox);
            StaticAsset returnAsset = this.staticAssetDao.addOrUpdateStaticAsset(clonedAsset, true);
            StaticAsset prod = this.findStaticAssetById(staticAsset.getId());
            prod.setLockedFlag(true);
            this.staticAssetDao.addOrUpdateStaticAsset(prod, false);
            SandBoxOperationType type = SandBoxOperationType.UPDATE;
            if (clonedAsset.getDeletedFlag().booleanValue()) {
                type = SandBoxOperationType.DELETE;
            }
            this.sandBoxItemDao.addSandBoxItem(destSandbox, type, SandBoxItemType.STATIC_ASSET, returnAsset.getFullUrl(), returnAsset.getId(), returnAsset.getOriginalAssetId());
            return returnAsset;
        }
        throw new IllegalArgumentException("Update called when promote or reject was expected.");
    }

    private boolean checkForSandboxMatch(SandBox src, SandBox dest) {
        if (src != null && dest != null) {
            return src.getId().equals(dest.getId());
        }
        return src == null && dest == null;
    }

    private boolean checkForProductionSandbox(SandBox dest) {
        boolean productionSandbox = false;
        if (dest == null) {
            productionSandbox = true;
        } else if (dest.getSite() != null && dest.getSite().getProductionSandbox() != null && dest.getSite().getProductionSandbox().getId() != null) {
            productionSandbox = dest.getSite().getProductionSandbox().getId().equals(dest.getId());
        }
        return productionSandbox;
    }

    private boolean isProductionSandBox(SandBox dest) {
        if (dest == null) {
            return true;
        }
        return SandBoxType.PRODUCTION.equals((Object)dest.getSandBoxType());
    }

    @Override
    public void deleteStaticAsset(StaticAsset staticAsset, SandBox destinationSandbox) {
        staticAsset.setDeletedFlag(true);
        this.updateStaticAsset(staticAsset, destinationSandbox);
    }

    @Override
    public List<StaticAsset> findAssets(SandBox sandbox, Criteria c) {
        return this.findItems(sandbox, c, StaticAsset.class, StaticAssetImpl.class, "originalAssetId");
    }

    @Override
    public Long countAssets(SandBox sandbox, Criteria c) {
        return this.countItems(sandbox, c, StaticAssetImpl.class, "originalAssetId");
    }

    public void itemPromoted(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.STATIC_ASSET.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StaticAsset asset = this.staticAssetDao.readStaticAssetById(sandBoxItem.getTemporaryItemId());
        if (asset == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Asset not found " + sandBoxItem.getTemporaryItemId()));
            }
        } else {
            boolean productionSandBox = this.isProductionSandBox(destinationSandBox);
            if (productionSandBox) {
                asset.setLockedFlag(false);
            } else {
                asset.setLockedFlag(true);
            }
            if (productionSandBox && asset.getOriginalAssetId() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Asset promoted to production.  " + asset.getId() + ".  Archiving original asset " + asset.getOriginalAssetId()));
                }
                StaticAsset originalAsset = this.staticAssetDao.readStaticAssetById(sandBoxItem.getTemporaryItemId());
                originalAsset.setArchivedFlag(Boolean.TRUE);
                this.staticAssetDao.addOrUpdateStaticAsset(originalAsset, false);
                asset.setOriginalAssetId(null);
                if (asset.getDeletedFlag().booleanValue()) {
                    asset.setArchivedFlag(Boolean.TRUE);
                }
            }
        }
        if (asset.getOriginalSandBox() == null) {
            asset.setOriginalSandBox(asset.getSandbox());
        }
        asset.setSandbox(destinationSandBox);
        this.staticAssetDao.addOrUpdateStaticAsset(asset, false);
    }

    public void itemRejected(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.STATIC_ASSET.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StaticAsset asset = this.staticAssetDao.readStaticAssetById(sandBoxItem.getTemporaryItemId());
        if (asset != null) {
            asset.setSandbox(destinationSandBox);
            asset.setOriginalSandBox(null);
            asset.setLockedFlag(false);
            this.staticAssetDao.addOrUpdateStaticAsset(asset, false);
        }
    }

    public void itemReverted(SandBoxItem sandBoxItem) {
        if (!SandBoxItemType.STATIC_ASSET.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StaticAsset asset = this.staticAssetDao.readStaticAssetById(sandBoxItem.getTemporaryItemId());
        if (asset != null) {
            asset.setArchivedFlag(Boolean.TRUE);
            asset.setLockedFlag(false);
            this.staticAssetDao.addOrUpdateStaticAsset(asset, false);
            StaticAsset originalAsset = this.staticAssetDao.readStaticAssetById(sandBoxItem.getOriginalItemId());
            originalAsset.setLockedFlag(false);
            this.staticAssetDao.addOrUpdateStaticAsset(originalAsset, false);
        }
    }

    @Override
    public String getStaticAssetUrlPrefix() {
        return this.staticAssetUrlPrefix;
    }

    @Override
    public void setStaticAssetUrlPrefix(String staticAssetUrlPrefix) {
        this.staticAssetUrlPrefix = staticAssetUrlPrefix;
    }

    @Override
    public String getStaticAssetEnvironmentUrlPrefix() {
        return this.fixEnvironmentUrlPrefix(this.staticAssetEnvironmentUrlPrefix);
    }

    @Override
    public void setStaticAssetEnvironmentUrlPrefix(String staticAssetEnvironmentUrlPrefix) {
        this.staticAssetEnvironmentUrlPrefix = staticAssetEnvironmentUrlPrefix;
    }

    @Override
    public String getStaticAssetEnvironmentSecureUrlPrefix() {
        if (this.staticAssetEnvironmentSecureUrlPrefix == null && this.staticAssetEnvironmentUrlPrefix != null && this.staticAssetEnvironmentUrlPrefix.indexOf("http:") >= 0) {
            this.staticAssetEnvironmentSecureUrlPrefix = this.staticAssetEnvironmentUrlPrefix.replace("http:", "https:");
        }
        return this.fixEnvironmentUrlPrefix(this.staticAssetEnvironmentSecureUrlPrefix);
    }

    public void setStaticAssetEnvironmentSecureUrlPrefix(String staticAssetEnvironmentSecureUrlPrefix) {
        this.staticAssetEnvironmentSecureUrlPrefix = staticAssetEnvironmentSecureUrlPrefix;
    }

    @Override
    public boolean getAutomaticallyApproveAndPromoteStaticAssets() {
        return this.automaticallyApproveAndPromoteStaticAssets;
    }

    @Override
    public void setAutomaticallyApproveAndPromoteStaticAssets(boolean automaticallyApproveAndPromoteStaticAssets) {
        this.automaticallyApproveAndPromoteStaticAssets = automaticallyApproveAndPromoteStaticAssets;
    }

    private String fixEnvironmentUrlPrefix(String urlPrefix) {
        if (urlPrefix != null) {
            if ("".equals(urlPrefix = urlPrefix.trim())) {
                urlPrefix = null;
            } else if (urlPrefix.equals(this.staticAssetUrlPrefix)) {
                urlPrefix = null;
            }
        }
        if (urlPrefix != null && !urlPrefix.endsWith("/")) {
            urlPrefix = urlPrefix + "/";
        }
        return urlPrefix;
    }

    @Override
    public String convertAssetPath(String assetPath, String contextPath, boolean secureRequest) {
        String returnValue = assetPath;
        if (assetPath != null && this.getStaticAssetEnvironmentUrlPrefix() != null && !"".equals(this.getStaticAssetEnvironmentUrlPrefix())) {
            String envPrefix = secureRequest ? this.getStaticAssetEnvironmentSecureUrlPrefix() : this.getStaticAssetEnvironmentUrlPrefix();
            if (envPrefix != null) {
                if (returnValue.startsWith("/")) {
                    returnValue = returnValue.substring(1);
                }
                returnValue = envPrefix + returnValue;
            }
        } else if (returnValue != null && !ImportSupport.isAbsoluteUrl((String)returnValue)) {
            if (!returnValue.startsWith("/")) {
                returnValue = "/" + returnValue;
            }
            if (contextPath != null && !contextPath.equals("") && !contextPath.equals("/")) {
                if (contextPath.endsWith("/")) {
                    returnValue = returnValue.substring(1);
                }
                returnValue = contextPath.startsWith("/") ? contextPath + returnValue : "/" + contextPath + returnValue;
            }
        }
        return returnValue;
    }
}

