/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.file.domain;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.cms.file.domain.StaticAssetDescription;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.openadmin.audit.AdminAuditable;
import org.broadleafcommerce.openadmin.audit.AdminAuditableListener;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_STATIC_ASSET_DESC")
@EntityListeners(value={AdminAuditableListener.class})
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blCMSElements")
public class StaticAssetDescriptionImpl
implements StaticAssetDescription {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="StaticAssetDescriptionId", strategy=GenerationType.TABLE)
    @TableGenerator(name="StaticAssetDescriptionId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="StaticAssetDescriptionId", allocationSize=10)
    @Column(name="STATIC_ASSET_DESC_ID")
    protected Long id;
    @Embedded
    @AdminPresentation(excluded=true)
    protected AdminAuditable auditable = new AdminAuditable();
    @Column(name="DESCRIPTION")
    @AdminPresentation(friendlyName="Description")
    protected String description;
    @Column(name="LONG_DESCRIPTION")
    @AdminPresentation(friendlyName="Long Description", largeEntry=true)
    protected String longDescription;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public StaticAssetDescription cloneEntity() {
        StaticAssetDescriptionImpl newAssetDescription = new StaticAssetDescriptionImpl();
        newAssetDescription.description = this.description;
        newAssetDescription.longDescription = this.longDescription;
        return newAssetDescription;
    }

    @Override
    public AdminAuditable getAuditable() {
        return this.auditable;
    }

    @Override
    public void setAuditable(AdminAuditable auditable) {
        this.auditable = auditable;
    }
}

