/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.server.handler;

import com.anasoft.os.daofusion.criteria.PersistentEntityCriteria;
import com.anasoft.os.daofusion.cto.client.CriteriaTransferObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.openadmin.client.dto.DynamicResultSet;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.server.cto.BaseCtoConverter;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItem;
import org.broadleafcommerce.openadmin.server.security.domain.AdminPermission;
import org.broadleafcommerce.openadmin.server.security.domain.AdminRole;
import org.broadleafcommerce.openadmin.server.security.domain.AdminUser;
import org.broadleafcommerce.openadmin.server.security.remote.AdminSecurityServiceRemote;
import org.broadleafcommerce.openadmin.server.security.service.AdminSecurityService;
import org.broadleafcommerce.openadmin.server.service.handler.CustomPersistenceHandlerAdapter;
import org.broadleafcommerce.openadmin.server.service.persistence.SandBoxService;
import org.broadleafcommerce.openadmin.server.service.persistence.module.RecordHelper;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class SandBoxItemCustomPersistenceHandler
extends CustomPersistenceHandlerAdapter {
    private Log LOG = LogFactory.getLog(SandBoxItemCustomPersistenceHandler.class);
    @Resource(name="blSandBoxService")
    protected SandBoxService sandBoxService;
    @Resource(name="blAdminSecurityService")
    protected AdminSecurityService adminSecurityService;
    @Resource(name="blAdminSecurityRemoteService")
    protected AdminSecurityServiceRemote adminRemoteSecurityService;

    public Boolean willHandleSecurity(PersistencePackage persistencePackage) {
        return true;
    }

    public Boolean canHandleFetch(PersistencePackage persistencePackage) {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        boolean isSandboxItem = SandBoxItem.class.getName().equals(ceilingEntityFullyQualifiedClassname);
        if (isSandboxItem) {
            return persistencePackage.getCustomCriteria()[4].equals("standard");
        }
        return false;
    }

    public Boolean canHandleAdd(PersistencePackage persistencePackage) {
        return this.canHandleFetch(persistencePackage);
    }

    public Boolean canHandleRemove(PersistencePackage persistencePackage) {
        return this.canHandleFetch(persistencePackage);
    }

    public Boolean canHandleUpdate(PersistencePackage persistencePackage) {
        return this.canHandleFetch(persistencePackage);
    }

    protected List<SandBoxItem> retrieveSandBoxItems(List<Long> ids, DynamicEntityDao dynamicEntityDao, SandBox mySandBox) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new IllegalArgumentException("The passed in ids parameter is empty");
        }
        Criteria criteria = dynamicEntityDao.createCriteria(SandBoxItem.class);
        criteria.add(Restrictions.in((String)"id", ids));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"originalSandBox", (Object)mySandBox), (Criterion)Restrictions.eq((String)"sandBox", (Object)mySandBox)));
        return criteria.list();
    }

    public DynamicResultSet fetch(PersistencePackage persistencePackage, CriteriaTransferObject cto, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        Object[] customCriteria = persistencePackage.getCustomCriteria();
        if (ArrayUtils.isEmpty((Object[])customCriteria) || customCriteria.length != 5) {
            ServiceException e = new ServiceException("Invalid request for entity: " + ceilingEntityFullyQualifiedClassname);
            this.LOG.error((Object)("Invalid request for entity: " + ceilingEntityFullyQualifiedClassname), (Throwable)e);
            throw e;
        }
        AdminUser adminUser = this.adminRemoteSecurityService.getPersistentAdminUser();
        if (adminUser == null) {
            ServiceException e = new ServiceException("Unable to determine current user logged in status");
            this.LOG.error((Object)"Unable to determine current user logged in status", (Throwable)e);
            throw e;
        }
        try {
            List<SandBoxItem> items;
            SandBox originalSandBox;
            SandBox currentSandBox;
            Object moduleKey = customCriteria[0];
            Object operation = customCriteria[1];
            ArrayList<Long> targets = new ArrayList<Long>();
            if (!StringUtils.isEmpty((String)customCriteria[2])) {
                String[] parts;
                for (String part : parts = ((String)customCriteria[2]).split(",")) {
                    try {
                        targets.add(Long.valueOf(part));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            Object comment = customCriteria[3];
            String requiredPermission = ((String)moduleKey).equals("userSandBox") ? "PERMISSION_ALL_USER_SANDBOX" : "PERMISSION_ALL_APPROVER_SANDBOX";
            boolean allowOperation = false;
            block5: for (AdminRole role : adminUser.getAllRoles()) {
                for (AdminPermission permission : role.getAllPermissions()) {
                    if (!permission.getName().equals(requiredPermission)) continue;
                    allowOperation = true;
                    continue block5;
                }
            }
            if (!allowOperation) {
                ServiceException e = new ServiceException("Current user does not have permission to perform operation");
                this.LOG.error((Object)"Current user does not have permission to perform operation", (Throwable)e);
                throw e;
            }
            if (((String)moduleKey).equals("userSandBox")) {
                originalSandBox = currentSandBox = this.sandBoxService.retrieveUserSandBox(null, adminUser);
            } else {
                originalSandBox = this.sandBoxService.retrieveUserSandBox(null, adminUser);
                currentSandBox = this.sandBoxService.retrieveApprovalSandBox(originalSandBox);
            }
            if (((String)operation).equals("promoteAll")) {
                this.sandBoxService.promoteAllSandBoxItems(currentSandBox, (String)comment);
            } else if (((String)operation).equals("promoteSelected")) {
                items = this.retrieveSandBoxItems(targets, dynamicEntityDao, currentSandBox);
                this.sandBoxService.promoteSelectedItems(currentSandBox, (String)comment, items);
            } else if (((String)operation).equals("revertRejectAll")) {
                if (((String)moduleKey).equals("userSandBox")) {
                    this.sandBoxService.revertAllSandBoxItems(originalSandBox, currentSandBox);
                } else {
                    this.sandBoxService.rejectAllSandBoxItems(originalSandBox, currentSandBox, (String)comment);
                }
            } else if (((String)operation).equals("revertRejectSelected")) {
                items = this.retrieveSandBoxItems(targets, dynamicEntityDao, currentSandBox);
                if (((String)moduleKey).equals("userSandBox")) {
                    this.sandBoxService.revertSelectedSandBoxItems(currentSandBox, items);
                } else {
                    this.sandBoxService.rejectSelectedSandBoxItems(currentSandBox, (String)comment, items);
                }
            }
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map originalProps = helper.getSimpleMergedProperties(SandBoxItem.class.getName(), persistencePerspective);
            cto.get("sandBox").setFilterValue(currentSandBox.getId().toString());
            cto.get("archivedFlag").setFilterValue(Boolean.FALSE.toString());
            BaseCtoConverter ctoConverter = helper.getCtoConverter(persistencePerspective, cto, SandBoxItem.class.getName(), originalProps);
            PersistentEntityCriteria queryCriteria = ctoConverter.convert(cto, SandBoxItem.class.getName());
            List records = dynamicEntityDao.query(queryCriteria, SandBoxItem.class);
            Entity[] results = helper.getRecords(originalProps, records);
            int totalRecords = helper.getTotalRecords(SandBoxItem.class.getName(), cto, ctoConverter);
            DynamicResultSet response = new DynamicResultSet(results, Integer.valueOf(totalRecords));
            return response;
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to execute persistence activity", (Throwable)e);
            throw new ServiceException("Unable to execute persistence activity for entity: " + ceilingEntityFullyQualifiedClassname, (Throwable)e);
        }
    }
}

