/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.extensibility.context.merge.handlers;

import java.util.Set;
import org.apache.xerces.impl.xs.opti.DefaultNode;
import org.broadleafcommerce.common.extensibility.context.merge.handlers.SchemaLocationNodeValueMerge;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class SchemaLocationMergeTest {
    protected static SchemaLocationNodeValueMerge merge;

    @BeforeClass
    public static void setup() {
        merge = new SchemaLocationNodeValueMerge();
    }

    @Test
    public void testReplacementRegex() {
        String val = "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-4.1.xsd     http://www.springframework.org/schema/tx http://www.springframework.org/schema/tx/spring-tx-4.1.xsd";
        String replacedVal = merge.getSanitizedValue(val);
        Assert.assertEquals((Object)replacedVal, (Object)"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd     http://www.springframework.org/schema/tx http://www.springframework.org/schema/tx/spring-tx.xsd");
    }

    @Test
    public void testNodeAttributes() {
        DummyNode node1 = new DummyNode();
        node1.setNodeValue("http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\nhttp://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-8.4.xsd\nhttp://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-9.4.xsd\nhttp://www.springframework.org/schema/tx http://www.springframework.org/schema/tx/spring-tx-4.1.xsd");
        DummyNode node2 = new DummyNode();
        node2.setNodeValue("http://www.springframework.org/schema/beans       http://www.springframework.org/schema/beans/spring-beans.xsd");
        Set mergedVals = merge.getMergedNodeValues((Node)((Object)node1), (Node)((Object)node2));
        Assert.assertArrayEquals((Object[])new String[]{"http://www.springframework.org/schema/beans", "http://www.springframework.org/schema/beans/spring-beans.xsd", "http://www.springframework.org/schema/tx", "http://www.springframework.org/schema/tx/spring-tx.xsd"}, (Object[])mergedVals.toArray());
    }

    @Test
    public void testAddedAttributes() {
        DummyNode node1 = new DummyNode();
        node1.setNodeValue("http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd");
        DummyNode node2 = new DummyNode();
        node2.setNodeValue("http://www.springframework.org/schema/tx http://www.springframework.org/schema/tx/spring-tx-4.1.xsd");
        Set mergedVals = merge.getMergedNodeValues((Node)((Object)node1), (Node)((Object)node2));
        Assert.assertArrayEquals((Object[])new String[]{"http://www.springframework.org/schema/beans", "http://www.springframework.org/schema/beans/spring-beans.xsd", "http://www.springframework.org/schema/tx", "http://www.springframework.org/schema/tx/spring-tx.xsd"}, (Object[])mergedVals.toArray());
    }

    public class DummyNode
    extends DefaultNode {
        protected String nodeValue;

        public String getNodeValue() throws DOMException {
            return this.nodeValue;
        }

        public void setNodeValue(String nodeValue) throws DOMException {
            this.nodeValue = nodeValue;
        }
    }
}

