/*
 * #%L
 * BroadleafCommerce Integration
 * %%
 * Copyright (C) 2009 - 2015 Broadleaf Commerce
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

package org.broadleafcommerce.common.payment.service;

import org.broadleafcommerce.common.vendor.service.type.ServiceStatusType;

/**
 * This interface is a lightweight replacement of gateway-specific classes extending AbstractExternalPaymentGatewayCall, and it helps expose some f the QoS inner methods, for testing purposes.
 * Notice that getServiceStatus() is overlaps a definition in ServiceStatusDetectable
 * @author gdiaz
 *
 */
public interface FailureCountExposable {

    public void clearStatus();

    public void incrementFailure();

    ServiceStatusType getServiceStatus();
    
    Integer getFailureReportingThreshold();

}
