/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.util;

import org.broadleafcommerce.common.util.StreamingTransactionCapableUtil;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class StreamTransactionCapableUtilFailureSimulator
extends StreamingTransactionCapableUtil {
    public static final String FAILURE_MODE_KEY = "failureMode";
    public static final String FAILURE_MODE_PU = "failureModePU";
    public static final String FAILURE_MODE_EXCEPTION = "failureModeException";
    private static final String blPUCheckClassName = "org.broadleafcommerce.core.catalog.domain.ProductImpl";
    private static final String blEventPUCheckClassName = "com.broadleafcommerce.jobsevents.domain.SystemEventImpl";

    public void startFailureMode(RuntimeException exceptionToThrow, String persistenceUnit) {
        this.checkPU(persistenceUnit);
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        context.getAdditionalProperties().put(FAILURE_MODE_KEY, true);
        context.getAdditionalProperties().put(FAILURE_MODE_PU, persistenceUnit);
        context.getAdditionalProperties().put(FAILURE_MODE_EXCEPTION, exceptionToThrow);
    }

    public void endFailureMode(String persistenceUnit) {
        this.checkPU(persistenceUnit);
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        context.getAdditionalProperties().remove(FAILURE_MODE_KEY);
        context.getAdditionalProperties().remove(FAILURE_MODE_PU);
        context.getAdditionalProperties().remove(FAILURE_MODE_EXCEPTION);
    }

    protected TransactionStatus startTransaction(int propagationBehavior, int isolationLevel) {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context.getAdditionalProperties().containsKey(FAILURE_MODE_KEY)) {
            String checkClassName;
            String failureModePU = (String)context.getAdditionalProperties().get(FAILURE_MODE_PU);
            String string = checkClassName = failureModePU.equals("blPU") ? blPUCheckClassName : blEventPUCheckClassName;
            if (((HibernateEntityManagerFactory)((JpaTransactionManager)this.transactionManager).getEntityManagerFactory()).getSessionFactory().getAllClassMetadata().containsKey(checkClassName)) {
                throw (RuntimeException)context.getAdditionalProperties().get(FAILURE_MODE_EXCEPTION);
            }
        }
        return super.startTransaction(propagationBehavior, isolationLevel);
    }

    protected void checkPU(String persistenceUnit) {
        if (!persistenceUnit.equals("blPU") && !persistenceUnit.equals("blEventPU")) {
            throw new UnsupportedOperationException(persistenceUnit + " not supported");
        }
    }
}

