/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.file.service;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.file.service.FileSystemFileServiceProvider;
import org.broadleafcommerce.common.site.domain.Site;
import org.broadleafcommerce.common.site.domain.SiteImpl;
import org.broadleafcommerce.common.web.BroadleafRequestContext;

public class FileSystemFileServiceProviderTest
extends TestCase {
    public void testBuildFileName() throws Exception {
        FileSystemFileServiceProvider provider = new FileSystemFileServiceProvider();
        String tmpdir = FileUtils.getTempDirectoryPath();
        if (!tmpdir.endsWith(File.separator)) {
            tmpdir = tmpdir + File.separator;
        }
        provider.fileSystemBaseDirectory = FilenameUtils.concat((String)tmpdir, (String)"test");
        provider.maxGeneratedDirectoryDepth = 2;
        File file = provider.getResource("/product/myproductimage.jpg");
        String resultPath = tmpdir + StringUtils.join((Object[])new String[]{"test", "35", "ec", "myproductimage.jpg"}, (String)File.separator);
        FileSystemFileServiceProviderTest.assertEquals((String)file.getAbsolutePath(), (String)FilenameUtils.normalize((String)resultPath));
        BroadleafRequestContext brc = new BroadleafRequestContext();
        BroadleafRequestContext.setBroadleafRequestContext((BroadleafRequestContext)brc);
        SiteImpl site = new SiteImpl();
        site.setId(Long.valueOf(125L));
        brc.setSite((Site)site);
        file = provider.getResource("/product/myproductimage.jpg");
        resultPath = tmpdir + StringUtils.join((Object[])new String[]{"test", "c8", "site-125", "35", "ec", "myproductimage.jpg"}, (String)File.separator);
        FileSystemFileServiceProviderTest.assertEquals((String)file.getAbsolutePath(), (String)resultPath);
        provider.maxGeneratedDirectoryDepth = 3;
        file = provider.getResource("/product/myproductimage.jpg");
        resultPath = tmpdir + StringUtils.join((Object[])new String[]{"test", "c8", "site-125", "35", "ec", "52", "myproductimage.jpg"}, (String)File.separator);
        FileSystemFileServiceProviderTest.assertEquals((String)file.getAbsolutePath(), (String)resultPath);
        BroadleafRequestContext.setBroadleafRequestContext(null);
    }
}

