/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.util;

import java.util.concurrent.ConcurrentHashMap;
import junit.framework.TestCase;
import org.apache.commons.collections4.map.LRUMap;
import org.broadleafcommerce.common.util.EfficientLRUMap;

public class EfficientLRUMapTest
extends TestCase {
    public void testMapSwitch() {
        EfficientLRUMap testMap = new EfficientLRUMap(5);
        testMap.put((Object)"key1", (Object)"value1");
        EfficientLRUMapTest.assertEquals((String)"The value for key1 should be value 1", (String)"value1", (String)((String)testMap.get((Object)"key1")));
        EfficientLRUMapTest.assertEquals((String)"The size() for the map should be 1", (int)1, (int)testMap.size());
        EfficientLRUMapTest.assertEquals((String)"The type of Map should be ConcurrentHashMap", (Object)testMap.getUnderlyingMapClass(), ConcurrentHashMap.class);
        testMap.put((Object)"key2", (Object)"value2");
        testMap.put((Object)"key3", (Object)"value3");
        testMap.put((Object)"key4", (Object)"value4");
        testMap.put((Object)"key5", (Object)"value5");
        EfficientLRUMapTest.assertEquals((String)"The value for key5 should be value5", (String)"value5", (String)((String)testMap.get((Object)"key5")));
        EfficientLRUMapTest.assertEquals((String)"The size() for the map should be 5", (int)5, (int)testMap.size());
        EfficientLRUMapTest.assertEquals((String)"The type of Map should be ConcurrentHashMap", (Object)testMap.getUnderlyingMapClass(), ConcurrentHashMap.class);
        testMap.put((Object)"key5", (Object)"value5b");
        EfficientLRUMapTest.assertEquals((String)"The value for key5 should now be value5b", (String)"value5b", (String)((String)testMap.get((Object)"key5")));
        EfficientLRUMapTest.assertEquals((String)"The size() for the map should be 5", (int)5, (int)testMap.size());
        EfficientLRUMapTest.assertEquals((String)"The type of Map should be ConcurrentHashMap", (Object)testMap.getUnderlyingMapClass(), ConcurrentHashMap.class);
        testMap.put((Object)"key6", (Object)"value6");
        EfficientLRUMapTest.assertEquals((String)"The value for key6 should be value6", (String)"value6", (String)((String)testMap.get((Object)"key6")));
        EfficientLRUMapTest.assertEquals((String)"The size() for the map should be 5 since we are now LRU", (int)5, (int)testMap.size());
        EfficientLRUMapTest.assertTrue((String)"The type of Map should not be a ConcurrentHashMap.   It should be a synchronized map", (!testMap.getUnderlyingMapClass().equals(LRUMap.class) ? 1 : 0) != 0);
    }
}

