/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.sitemap.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.broadleafcommerce.common.config.service.ModuleConfigurationService;
import org.broadleafcommerce.common.config.service.type.ModuleConfigurationType;
import org.broadleafcommerce.common.file.service.BroadleafFileServiceImpl;
import org.broadleafcommerce.common.file.service.FileServiceProvider;
import org.broadleafcommerce.common.file.service.FileSystemFileServiceProvider;
import org.broadleafcommerce.common.sitemap.domain.SiteMapConfiguration;
import org.broadleafcommerce.common.sitemap.domain.SiteMapConfigurationImpl;
import org.broadleafcommerce.common.sitemap.domain.SiteMapGeneratorConfiguration;
import org.broadleafcommerce.common.sitemap.exception.SiteMapException;
import org.broadleafcommerce.common.sitemap.service.SiteMapGenerationResponse;
import org.broadleafcommerce.common.sitemap.service.SiteMapGenerator;
import org.broadleafcommerce.common.sitemap.service.SiteMapServiceImpl;
import org.broadleafcommerce.common.web.BaseUrlResolver;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class SiteMapGeneratorTest {
    protected SiteMapServiceImpl siteMapService = new SiteMapServiceImpl();
    protected BroadleafFileServiceImpl fileService = new BroadleafFileServiceImpl();
    protected BaseUrlResolver baseUrlResolver = new BaseUrlResolver(){

        public String getSiteBaseUrl() {
            return "http://www.heatclinic.com";
        }

        public String getAdminBaseUrl() {
            return "http://www.heatclinic.com/admin";
        }
    };

    @Before
    public void setup() {
        FileSystemFileServiceProvider defaultFileServiceProvider = new FileSystemFileServiceProvider();
        this.fileService.setDefaultFileServiceProvider((FileServiceProvider)defaultFileServiceProvider);
        this.siteMapService.broadleafFileService = this.fileService;
        this.siteMapService.baseUrlResolver = this.baseUrlResolver;
    }

    @After
    public void deleteTempFiles() {
        this.fileService.removeResource("/sitemap_index.xml");
        this.fileService.removeResource("/sitemap1.xml");
        this.fileService.removeResource("/sitemap2.xml");
        this.fileService.removeResource("/sitemap3.xml");
        this.fileService.removeResource("/sitemap.xml");
    }

    protected void testGenerator(SiteMapGeneratorConfiguration smgc, SiteMapGenerator smg) throws SiteMapException, IOException {
        this.testGenerator(smgc, smg, 2);
    }

    protected void testGenerator(SiteMapGeneratorConfiguration smgc, SiteMapGenerator smg, int maxEntriesPerFile) throws SiteMapException, IOException {
        ArrayList<SiteMapGeneratorConfiguration> smgcList = new ArrayList<SiteMapGeneratorConfiguration>();
        smgcList.add(smgc);
        this.testGenerator(smgcList, smg, maxEntriesPerFile);
    }

    protected void testGenerator(List<SiteMapGeneratorConfiguration> smgcList, SiteMapGenerator smg, int maxEntriesPerFile) throws SiteMapException, IOException {
        if (CollectionUtils.isNotEmpty(smgcList)) {
            SiteMapConfigurationImpl smc = new SiteMapConfigurationImpl();
            smc.setMaximumUrlEntriesPerFile(Integer.valueOf(maxEntriesPerFile));
            smc.setSiteMapGeneratorConfigurations(smgcList);
            smc.setIndexedSiteMapFileName("sitemap_index.xml");
            for (SiteMapGeneratorConfiguration smgc : smgcList) {
                smgc.setSiteMapConfiguration((SiteMapConfiguration)smc);
            }
            ArrayList<SiteMapConfigurationImpl> mcList = new ArrayList<SiteMapConfigurationImpl>();
            mcList.add(smc);
            ModuleConfigurationService mcs = (ModuleConfigurationService)EasyMock.createMock(ModuleConfigurationService.class);
            EasyMock.expect((Object)mcs.findActiveConfigurationsByType(ModuleConfigurationType.SITE_MAP)).andReturn(mcList);
            EasyMock.replay((Object[])new Object[]{mcs});
            ArrayList<SiteMapGenerator> smgList = new ArrayList<SiteMapGenerator>();
            smgList.add(smg);
            this.siteMapService.setGzipSiteMapFiles(Boolean.valueOf(false));
            this.siteMapService.setModuleConfigurationService(mcs);
            this.siteMapService.setSiteMapGenerators(smgList);
            SiteMapGenerationResponse smgr = this.siteMapService.generateSiteMap();
            Assert.assertFalse((boolean)smgr.isHasError());
        }
    }

    protected void compareFiles(File file1, String pathToFile2) throws IOException {
        String actualOutput = this.convertFileToString(file1);
        String expectedOutput = this.convertFileToString(new File(pathToFile2));
        Assert.assertTrue((boolean)actualOutput.equals(expectedOutput));
    }

    protected String convertFileToString(File file) throws IOException {
        String line;
        FileInputStream fin = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader(fin));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (line.contains("</lastmod>")) continue;
            line = line.replaceAll("\\s+", "");
            sb.append(line);
        }
        br.close();
        fin.close();
        return sb.toString();
    }
}

