/*
 * #%L
 * BroadleafCommerce Common Libraries
 * %%
 * Copyright (C) 2009 - 2013 Broadleaf Commerce
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.broadleafcommerce.common.presentation.override;

/**
 * @author Jeff Fischer
 */
public class PropertyType {

    public static class AdminPresentation {
        public static final String FRIENDLYNAME = "friendlyName";
        public static final String SECURITYLEVEL = "securityLevel";
        public static final String ORDER = "order";
        public static final String GRIDORDER = "gridOrder";
        public static final String VISIBILITY = "visibility";
        public static final String FIELDTYPE = "fieldType";
        public static final String GROUP = "group";
        public static final String GROUPORDER = "groupOrder";
        public static final String GROUPCOLLAPSED = "groupCollapsed";
        public static final String TAB = "tab";
        public static final String TABORDER = "tabOrder";
        public static final String LARGEENTRY = "largeEntry";
        public static final String PROMINENT = "prominent";
        public static final String COLUMNWIDTH = "columnWidth";
        public static final String BROADLEAFENUMERATION = "broadleafEnumeration";
        public static final String REQUIREDOVERRIDE = "requiredOverride";
        public static final String EXCLUDED = "excluded";
        public static final String TOOLTIP = "tooltip";
        public static final String HELPTEXT = "helpText";
        public static final String HINT = "hint";
        public static final String SHOWIFPROPERTY = "showIfProperty";
        public static final String CURRENCYCODEFIELD = "currencyCodeField";
        public static final String RULEIDENTIFIER = "ruleIdentifier";
        public static final String READONLY = "readOnly";
        public static final String VALIDATIONCONFIGURATIONS = "validationConfigurations";
    }

    public static class AdminPresentationToOneLookup {
        public static final String LOOKUPDISPLAYPROPERTY = "lookupDisplayProperty";
        public static final String USESERVERSIDEINSPECTIONCACHE = "useServerSideInspectionCache";
        public static final String LOOKUPTYPE = "lookupType";
        public static final String CUSTOMCRITERIA = "customCriteria";
        public static final String FORCEPOPULATECHILDPROPERTIES = "forcePopulateChildProperties";
        public static final String ENABLETYPEAHEADLOOKUP = "enableTypeaheadLookup";
    }

    public static class AdminPresentationDataDrivenEnumeration {
        public static final String OPTIONLISTENTITY = "optionListEntity";
        public static final String OPTIONVALUEFIELDNAME = "optionValueFieldName";
        public static final String OPTIONDISPLAYFIELDNAME = "optionDisplayFieldName";
        public static final String OPTIONCANEDITVALUES = "optionCanEditValues";
        public static final String OPTIONFILTERPARAMS = "optionFilterParams";
    }

    public static class AdminPresentationAdornedTargetCollection {
        public static final String FRIENDLYNAME = "friendlyName";
        public static final String SECURITYLEVEL = "securityLevel";
        public static final String EXCLUDED = "excluded";
        public static final String SHOWIFPROPERTY = "showIfProperty";
        public static final String READONLY = "readOnly";
        public static final String USESERVERSIDEINSPECTIONCACHE = "useServerSideInspectionCache";
        public static final String PARENTOBJECTPROPERTY = "parentObjectProperty";
        public static final String PARENTOBJECTIDPROPERTY = "parentObjectIdProperty";
        public static final String TARGETOBJECTPROPERTY = "targetObjectProperty";
        public static final String MAINTAINEDADORNEDTARGETFIELDS = "maintainedAdornedTargetFields";
        public static final String GRIDVISIBLEFIELDS = "gridVisibleFields";
        public static final String TARGETOBJECTIDPROPERTY = "targetObjectIdProperty";
        public static final String JOINENTITYCLASS = "joinEntityClass";
        public static final String SORTPROPERTY = "sortProperty";
        public static final String SORTASCENDING = "sortAscending";
        public static final String IGNOREADORNEDPROPERTIES = "ignoreAdornedProperties";
        public static final String ORDER = "order";
        public static final String TAB = "tab";
        public static final String TABORDER = "tabOrder";
        public static final String CUSTOMCRITERIA = "customCriteria";
        public static final String CURRENCYCODEFIELD = "currencyCodeField";
        public static final String OPERATIONTYPES = "operationTypes";
    }

    public static class AdminPresentationCollection {
        public static final String FRIENDLYNAME = "friendlyName";
        public static final String SECURITYLEVEL = "securityLevel";
        public static final String EXCLUDED = "excluded";
        public static final String READONLY = "readOnly";
        public static final String USESERVERSIDEINSPECTIONCACHE = "useServerSideInspectionCache";
        public static final String ADDTYPE = "addType";
        public static final String MANYTOFIELD = "manyToField";
        public static final String ORDER = "order";
        public static final String SORTPROPERTY = "sortProperty";
        public static final String SORTASCENDING = "sortAscending";
        public static final String TAB = "tab";
        public static final String TABORDER = "tabOrder";
        public static final String CUSTOMCRITERIA = "customCriteria";
        public static final String OPERATIONTYPES = "operationTypes";
        public static final String SHOWIFPROPERTY = "showIfProperty";
        public static final String CURRENCYCODEFIELD = "currencyCodeField";
    }

    public static class AdminPresentationMap {
        public static final String FRIENDLYNAME = "friendlyName";
        public static final String SECURITYLEVEL = "securityLevel";
        public static final String EXCLUDED = "excluded";
        public static final String READONLY = "readOnly";
        public static final String USESERVERSIDEINSPECTIONCACHE = "useServerSideInspectionCache";
        public static final String ORDER = "order";
        public static final String TAB = "tab";
        public static final String TABORDER = "tabOrder";
        public static final String KEYCLASS = "keyClass";
        public static final String MAPKEYVALUEPROPERTY = "mapKeyValueProperty";
        public static final String KEYPROPERTYFRIENDLYNAME = "keyPropertyFriendlyName";
        public static final String VALUECLASS = "valueClass";
        public static final String DELETEENTITYUPONREMOVE = "deleteEntityUponRemove";
        public static final String VALUEPROPERTYFRIENDLYNAME = "valuePropertyFriendlyName";
        public static final String ISSIMPLEVALUE = "isSimpleValue";
        public static final String MEDIAFIELD = "mediaField";
        public static final String KEYS = "keys";
        public static final String FORCEFREEFORMKEYS = "forceFreeFormKeys";
        public static final String MANYTOFIELD = "manyToField";
        public static final String MAPKEYOPTIONENTITYCLASS = "mapKeyOptionEntityClass";
        public static final String MAPKEYOPTIONENTITYDISPLAYFIELD = "mapKeyOptionEntityDisplayField";
        public static final String MAPKEYOPTIONENTITYVALUEFIELD = "mapKeyOptionEntityValueField";
        public static final String CUSTOMCRITERIA = "customCriteria";
        public static final String OPERATIONTYPES = "operationTypes";
        public static final String SHOWIFPROPERTY = "showIfProperty";
        public static final String CURRENCYCODEFIELD = "currencyCodeField";
    }
}
