/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.util.sql;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.broadleafcommerce.common.extensibility.context.MergeClassPathXMLApplicationContext;
import org.broadleafcommerce.common.extensibility.context.StandardConfigLocations;
import org.broadleafcommerce.common.util.sql.ExporterTask;
import org.broadleafcommerce.common.util.sql.Hbm2DDLExporterTask;
import org.broadleafcommerce.common.util.sql.JPAConfigurationTask;
import org.hibernate.MappingNotFoundException;
import org.hibernate.tool.ant.ConfigurationTask;
import org.hibernate.util.StringHelper;

public class HibernateToolTask
extends Task {
    private List configurationTasks = new ArrayList();
    private File destDir;
    private List generators = new ArrayList();
    private Path classPath;
    private boolean combinePersistenceUnits = true;
    private boolean refineFileNames = true;

    public ExporterTask createHbm2DDL() {
        Hbm2DDLExporterTask generator = new Hbm2DDLExporterTask(this);
        this.addGenerator(generator);
        return generator;
    }

    public JPAConfigurationTask createJPAConfiguration() {
        JPAConfigurationTask task = new JPAConfigurationTask();
        this.addConfiguration(task);
        return task;
    }

    protected boolean addConfiguration(ConfigurationTask config) {
        return this.configurationTasks.add(config);
    }

    protected boolean addGenerator(ExporterTask generator) {
        return this.generators.add(generator);
    }

    public void setClasspath(Path s) {
        this.classPath = s;
    }

    public Path createClasspath() {
        this.classPath = new Path(this.getProject());
        return this.classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        MergeClassPathXMLApplicationContext mergeContext;
        AntClassLoader loader;
        try {
            loader = this.getProject().createClassLoader(this.classPath);
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            loader.setParent(classLoader);
            loader.setThreadContextLoader();
            String[] contexts = StandardConfigLocations.retrieveAll(3);
            mergeContext = new MergeClassPathXMLApplicationContext(contexts, new String[0]);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        int count = 1;
        ExporterTask generatorTask2 = null;
        try {
            for (Object configuration : this.configurationTasks) {
                JPAConfigurationTask configurationTask = (JPAConfigurationTask)((Object)configuration);
                this.log("Executing Hibernate Tool with a " + configurationTask.getDescription());
                for (ExporterTask generatorTask2 : this.generators) {
                    this.log(count++ + ". task: " + generatorTask2.getName());
                    generatorTask2.setOutputFileName(configurationTask.getDialect() + "_" + configurationTask.getPersistenceUnit() + ".sql");
                    generatorTask2.setDestdir(this.destDir);
                    generatorTask2.setConfiguration(configurationTask.createConfiguration(mergeContext));
                    generatorTask2.execute();
                }
            }
        }
        catch (RuntimeException re) {
            this.reportException(re, count, generatorTask2);
        }
        finally {
            if (loader != null) {
                loader.resetThreadContextLoader();
                loader.cleanup();
            }
        }
        try {
            if (this.combinePersistenceUnits) {
                ArrayList<File> combine = new ArrayList<File>();
                for (Object configuration : this.configurationTasks) {
                    File[] sqlFiles;
                    JPAConfigurationTask configurationTask = (JPAConfigurationTask)((Object)configuration);
                    for (File file : sqlFiles = this.destDir.listFiles(new SqlFileFilter())) {
                        if (!file.getName().startsWith(configurationTask.getDialect())) continue;
                        combine.add(file);
                    }
                    this.combineFiles(combine);
                    combine.clear();
                }
            }
            if (this.refineFileNames) {
                File[] sqlFiles;
                for (File file : sqlFiles = this.destDir.listFiles(new SqlFileFilter())) {
                    String[] starters;
                    String filename = file.getName();
                    for (String starter : starters = new String[]{"org.hibernate.dialect.", "org.broadleafcommerce.profile.util.sql."}) {
                        if (!filename.startsWith(starter)) continue;
                        String newFileName = filename.substring(starter.length(), filename.length());
                        file.renameTo(new File(this.destDir, newFileName));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void combineFiles(ArrayList<File> combine) throws Exception {
        Iterator<File> itr = combine.iterator();
        File startFile = itr.next();
        while (itr.hasNext()) {
            File nextFile = itr.next();
            BufferedWriter writer = null;
            BufferedReader reader = null;
            try {
                writer = new BufferedWriter(new FileWriter(startFile, true));
                reader = new BufferedReader(new FileReader(nextFile));
                boolean eof = false;
                String temp = null;
                while (!eof) {
                    temp = reader.readLine();
                    if (temp == null) {
                        eof = true;
                        continue;
                    }
                    writer.write(temp);
                    writer.write("\n");
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable e) {}
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable e) {}
                }
            }
            try {
                nextFile.delete();
            }
            catch (Throwable e) {}
        }
    }

    private void reportException(Throwable re, int count, ExporterTask generatorTask) {
        String newbieMessage;
        this.log("An exception occurred while running exporter #" + count + ":" + generatorTask.getName(), 0);
        this.log("To get the full stack trace run ant with -verbose", 0);
        this.log(re.toString(), 0);
        String ex = new String();
        for (Throwable cause = re.getCause(); cause != null; cause = cause.getCause()) {
            ex = ex + cause.toString() + "\n";
            if (cause == cause.getCause()) break;
        }
        if (StringHelper.isNotEmpty((String)ex)) {
            this.log(ex, 0);
        }
        if ((newbieMessage = this.getProbableSolutionOrCause(re)) != null) {
            this.log(newbieMessage);
        }
        if (re instanceof BuildException) {
            throw (BuildException)re;
        }
        throw new BuildException(re, this.getLocation());
    }

    private String getProbableSolutionOrCause(Throwable re) {
        if (re == null) {
            return null;
        }
        if (re instanceof MappingNotFoundException) {
            MappingNotFoundException mnf = (MappingNotFoundException)re;
            if ("resource".equals(mnf.getType())) {
                return "A " + mnf.getType() + " located at " + mnf.getPath() + " was not found.\n" + "Check the following:\n" + "\n" + "1) Is the spelling/casing correct ?\n" + "2)\tIs " + mnf.getPath() + " available via the classpath ?\n" + "3) Does it actually exist ?\n";
            }
            return "A " + mnf.getType() + " located at " + mnf.getPath() + " was not found.\n" + "Check the following:\n" + "\n" + "1) Is the spelling/casing correct ?\n" + "2)\tDo you permission to access " + mnf.getPath() + " ?\n" + "3) Does it actually exist ?\n";
        }
        if (re instanceof ClassNotFoundException || re instanceof NoClassDefFoundError) {
            return "A class were not found in the classpath of the Ant task.\nEnsure that the classpath contains the classes needed for Hibernate and your code are in the classpath.\n";
        }
        if (re instanceof UnsupportedClassVersionError) {
            return "You are most likely running the ant task with a JRE that is older than the JRE required to use the classes.\ne.g. running with JRE 1.3 or 1.4 when using JDK 1.5 annotations is not possible.\nEnsure that you are using a correct JRE.";
        }
        if (re.getCause() != re) {
            return this.getProbableSolutionOrCause(re.getCause());
        }
        return null;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public boolean isCombinePersistenceUnits() {
        return this.combinePersistenceUnits;
    }

    public void setCombinePersistenceUnits(boolean combinePersistenceUnits) {
        this.combinePersistenceUnits = combinePersistenceUnits;
    }

    public boolean isRefineFileNames() {
        return this.refineFileNames;
    }

    public void setRefineFileNames(boolean refineFileNames) {
        this.refineFileNames = refineFileNames;
    }

    private class SqlFileFilter
    implements FilenameFilter {
        private SqlFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".sql");
        }
    }
}

