/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.extensibility.context;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ResourceInputStream
extends InputStream {
    private final InputStream is;
    private List<String> names = new ArrayList<String>(20);

    public ResourceInputStream(InputStream is, String name) {
        this.is = is;
        this.names.add(name);
    }

    public ResourceInputStream(InputStream is, String name, List<String> previousNames) {
        this.is = is;
        this.names.addAll(previousNames);
        if (!StringUtils.isEmpty((String)name)) {
            this.names.add(name);
        }
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getName() {
        assert (this.names.size() == 1);
        return this.names.get(0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        int size = this.names.size();
        for (int j = 0; j < size; ++j) {
            sb.append(this.names.get(j));
            if (j >= size - 1) continue;
            sb.append(" : ");
        }
        return sb.toString();
    }

    @Override
    public int available() throws IOException {
        return this.is == null ? -1 : this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void mark(int i) {
        this.is.mark(i);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.is.read(bytes);
    }

    @Override
    public int read(byte[] bytes, int i, int i1) throws IOException {
        return this.is.read(bytes, i, i1);
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.is.skip(l);
    }
}

