/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.email.service.jms;

import java.io.Serializable;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.broadleafcommerce.common.email.service.info.EmailInfo;
import org.broadleafcommerce.common.email.service.jms.JMSEmailServiceProducer;
import org.broadleafcommerce.common.email.service.message.EmailPropertyType;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class JMSEmailServiceProducerImpl
implements JMSEmailServiceProducer {
    private JmsTemplate emailServiceTemplate;
    private Destination emailServiceDestination;

    @Override
    public void send(final HashMap props) {
        this.emailServiceTemplate.send(this.emailServiceDestination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                ObjectMessage message = session.createObjectMessage((Serializable)props);
                EmailInfo info = (EmailInfo)props.get(EmailPropertyType.INFO.getType());
                message.setJMSPriority(Integer.parseInt(info.getSendAsyncPriority()));
                return message;
            }
        });
    }

    @Override
    public JmsTemplate getEmailServiceTemplate() {
        return this.emailServiceTemplate;
    }

    @Override
    public void setEmailServiceTemplate(JmsTemplate emailServiceTemplate) {
        this.emailServiceTemplate = emailServiceTemplate;
    }

    @Override
    public Destination getEmailServiceDestination() {
        return this.emailServiceDestination;
    }

    @Override
    public void setEmailServiceDestination(Destination emailServiceDestination) {
        this.emailServiceDestination = emailServiceDestination;
    }
}

