/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.cache.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.cache.engine.AbstractHydratedCacheManager;
import org.hibernate.cache.CacheKey;

public class BigMemoryHydratedCacheManagerImpl
extends AbstractHydratedCacheManager {
    private static final Log LOG = LogFactory.getLog(BigMemoryHydratedCacheManagerImpl.class);
    private static final BigMemoryHydratedCacheManagerImpl MANAGER = new BigMemoryHydratedCacheManagerImpl();
    private Map<String, List<String>> cacheMemberNamesByEntity = Collections.synchronizedMap(new HashMap(100));
    private List<String> removeKeys = Collections.synchronizedList(new ArrayList(100));
    private Cache offHeap;

    public static BigMemoryHydratedCacheManagerImpl getInstance() {
        return MANAGER;
    }

    private BigMemoryHydratedCacheManagerImpl() {
        if (CacheManager.getInstance().cacheExists("hydrated-offheap-cache")) {
            this.offHeap = CacheManager.getInstance().getCache("hydrated-offheap-cache");
        } else {
            CacheConfiguration config = new CacheConfiguration("hydrated-offheap-cache", 500).eternal(true).overflowToOffHeap(true).maxMemoryOffHeap("1400M");
            Cache cache = new Cache(config);
            CacheManager.create().addCache(cache);
            this.offHeap = cache;
        }
    }

    @Override
    public Object getHydratedCacheElementItem(String cacheRegion, String cacheName, Serializable elementKey, String elementItemName) {
        String myKey = cacheRegion + '_' + cacheName + '_' + elementItemName + '_' + elementKey;
        if (this.removeKeys.contains(myKey)) {
            return null;
        }
        Object response = null;
        Element element = this.offHeap.get((Serializable)((Object)myKey));
        if (element != null) {
            response = element.getObjectValue();
        }
        return response;
    }

    @Override
    public void addHydratedCacheElementItem(String cacheRegion, String cacheName, Serializable elementKey, String elementItemName, Object elementValue) {
        String heapKey = cacheRegion + '_' + cacheName + '_' + elementItemName + '_' + elementKey;
        String nameKey = cacheRegion + '_' + cacheName + '_' + elementKey;
        this.removeKeys.remove(nameKey);
        Element element = new Element((Object)heapKey, elementValue);
        if (!this.cacheMemberNamesByEntity.containsKey(nameKey)) {
            ArrayList<String> myMembers = new ArrayList<String>(50);
            myMembers.add(elementItemName);
            this.cacheMemberNamesByEntity.put(nameKey, myMembers);
        } else {
            List<String> myMembers = this.cacheMemberNamesByEntity.get(nameKey);
            myMembers.add(elementItemName);
        }
        this.offHeap.put(element);
    }

    protected void removeCache(String cacheRegion, Serializable key) {
        String nameKey;
        String cacheName = cacheRegion;
        if (key instanceof CacheKey) {
            cacheName = ((CacheKey)key).getEntityOrRoleName();
            key = ((CacheKey)key).getKey();
        }
        if (this.cacheMemberNamesByEntity.containsKey(nameKey = cacheRegion + '_' + cacheName + '_' + key)) {
            String[] members = new String[this.cacheMemberNamesByEntity.get(nameKey).size()];
            for (String myMember : members = this.cacheMemberNamesByEntity.get(nameKey).toArray(members)) {
                String itemKey = cacheRegion + '_' + myMember + '_' + key;
                this.removeKeys.add(itemKey);
            }
            this.cacheMemberNamesByEntity.remove(nameKey);
        }
    }

    protected void removeAll(String cacheName) {
    }

    public void notifyElementEvicted(Ehcache arg0, Element arg1) {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyElementExpired(Ehcache arg0, Element arg1) {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyElementPut(Ehcache arg0, Element arg1) throws CacheException {
    }

    public void notifyElementRemoved(Ehcache arg0, Element arg1) throws CacheException {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyElementUpdated(Ehcache arg0, Element arg1) throws CacheException {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyRemoveAll(Ehcache arg0) {
        this.removeAll(arg0.getName());
    }
}

