/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor.amazon.s3;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.config.service.SystemPropertiesService;
import org.broadleafcommerce.vendor.amazon.s3.S3Configuration;
import org.broadleafcommerce.vendor.amazon.s3.S3ConfigurationService;
import org.springframework.stereotype.Service;

@Service(value="blS3ConfigurationService")
public class S3ConfigurationServiceImpl
implements S3ConfigurationService {
    @Resource(name="blSystemPropertiesService")
    protected SystemPropertiesService systemPropertiesService;

    @Override
    public S3Configuration lookupS3Configuration() {
        S3Configuration s3config = new S3Configuration();
        s3config.setAwsSecretKey(this.lookupProperty("aws.s3.secretKey"));
        s3config.setDefaultBucketName(this.lookupProperty("aws.s3.defaultBucketName"));
        s3config.setDefaultBucketRegion(this.lookupProperty("aws.s3.defaultBucketRegion"));
        s3config.setGetAWSAccessKeyId(this.lookupProperty("aws.s3.accessKeyId"));
        boolean accessSecretKeyBlank = StringUtils.isEmpty((CharSequence)s3config.getAwsSecretKey());
        boolean accessKeyIdBlank = StringUtils.isEmpty((CharSequence)s3config.getGetAWSAccessKeyId());
        boolean bucketNameBlank = StringUtils.isEmpty((CharSequence)s3config.getDefaultBucketName());
        Region region = RegionUtils.getRegion((String)s3config.getDefaultBucketRegion());
        if (region == null || accessSecretKeyBlank || accessKeyIdBlank || bucketNameBlank) {
            StringBuilder errorMessage = new StringBuilder("Amazon S3 Configuration Error : ");
            if (accessSecretKeyBlank) {
                errorMessage.append("aws.s3.secretKey was blank,");
            }
            if (accessKeyIdBlank) {
                errorMessage.append("aws.s3.accessKeyId was blank,");
            }
            if (bucketNameBlank) {
                errorMessage.append("aws.s3.defaultBucketName was blank,");
            }
            if (region == null) {
                errorMessage.append("aws.s3.defaultBucketRegion was set to an invalid value of " + s3config.getDefaultBucketRegion());
            }
            throw new IllegalArgumentException(errorMessage.toString());
        }
        return s3config;
    }

    protected String lookupProperty(String propertyName) {
        return this.systemPropertiesService.resolveSystemProperty(propertyName);
    }

    protected void setSystemPropertiesService(SystemPropertiesService systemPropertiesService) {
        this.systemPropertiesService = systemPropertiesService;
    }
}

