/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.server.service.handler;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.FieldMetadata;
import org.broadleafcommerce.openadmin.client.dto.ForeignKey;
import org.broadleafcommerce.openadmin.client.dto.MergedPropertyType;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.service.handler.CustomPersistenceHandlerAdapter;
import org.broadleafcommerce.openadmin.server.service.persistence.module.RecordHelper;

public class CategoryCustomPersistenceHandler
extends CustomPersistenceHandlerAdapter {
    private static final Log LOG = LogFactory.getLog(CategoryCustomPersistenceHandler.class);

    public Boolean canHandleRemove(PersistencePackage persistencePackage) {
        Object[] customCriteria = persistencePackage.getCustomCriteria();
        return !ArrayUtils.isEmpty((Object[])customCriteria) && "OrphanedCategoryListDataSource".equals(customCriteria[0]);
    }

    public Boolean canHandleAdd(PersistencePackage persistencePackage) {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        Object[] customCriteria = persistencePackage.getCustomCriteria();
        return !ArrayUtils.isEmpty((Object[])customCriteria) && "addNewCategory".equals(customCriteria[0]) && Category.class.getName().equals(ceilingEntityFullyQualifiedClassname);
    }

    public Entity add(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Category adminInstance = (Category)Class.forName(entity.getType()[0]).newInstance();
            Map adminProperties = helper.getSimpleMergedProperties(Category.class.getName(), persistencePerspective);
            adminInstance = (Category)helper.createPopulatedInstance((Serializable)adminInstance, entity, adminProperties, Boolean.valueOf(false));
            if (adminInstance.getDefaultParentCategory() != null && !adminInstance.getAllParentCategories().contains(adminInstance.getDefaultParentCategory())) {
                adminInstance.getAllParentCategories().add(adminInstance.getDefaultParentCategory());
            }
            adminInstance = (Category)dynamicEntityDao.merge((Serializable)adminInstance);
            return helper.getRecord(adminProperties, (Serializable)adminInstance, null, null);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to add entity for " + entity.getType()[0]), (Throwable)e);
            throw new ServiceException("Unable to add entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    public void remove(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map<String, FieldMetadata> categoryProperties = this.getMergedProperties(Category.class, dynamicEntityDao, persistencePerspective.getPopulateToOneFields(), persistencePerspective.getIncludeFields(), persistencePerspective.getExcludeFields(), persistencePerspective.getConfigurationKey());
            Object primaryKey = helper.getPrimaryKey(entity, categoryProperties);
            Category category = (Category)dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            CriteriaBuilder criteriaBuilder = dynamicEntityDao.getStandardEntityManager().getCriteriaBuilder();
            CriteriaQuery query = criteriaBuilder.createQuery(Category.class);
            Root root = query.from(CategoryImpl.class);
            query.where((Expression)criteriaBuilder.equal((Expression)root.get("defaultParentCategory"), (Object)category));
            query.select((Selection)root);
            TypedQuery categoryQuery = dynamicEntityDao.getStandardEntityManager().createQuery(query);
            List categories = categoryQuery.getResultList();
            if (!categories.isEmpty()) {
                StringBuilder sb = new StringBuilder(500);
                sb.append("Cannot delete category (");
                sb.append(category.getId());
                sb.append(',');
                sb.append(category.getName());
                sb.append("). There are Categories that reference it as the default parent category. These categories must first be updated to a different default parent category before this category can be deleted. ");
                sb.append("\nThe categories in question are: ");
                for (Category myCategory : categories) {
                    sb.append('\n');
                    sb.append('(');
                    sb.append(myCategory.getId());
                    sb.append(',');
                    sb.append(myCategory.getName());
                    sb.append(')');
                }
                throw new ServiceException(sb.toString());
            }
            criteriaBuilder = dynamicEntityDao.getStandardEntityManager().getCriteriaBuilder();
            query = criteriaBuilder.createQuery(Product.class);
            root = query.from(ProductImpl.class);
            query.where((Expression)criteriaBuilder.equal((Expression)root.get("defaultCategory"), (Object)category));
            query.select((Selection)root);
            TypedQuery productQuery = dynamicEntityDao.getStandardEntityManager().createQuery(query);
            List products = productQuery.getResultList();
            if (!products.isEmpty()) {
                StringBuilder sb = new StringBuilder(500);
                sb.append("Cannot delete category (");
                sb.append(category.getId());
                sb.append(',');
                sb.append(category.getName());
                sb.append("). There are Products that reference it as the default category. These products must first be updated to a different default category before this category can be deleted. ");
                sb.append("\nThe products in question are: ");
                for (Product product : products) {
                    sb.append('\n');
                    sb.append('(');
                    sb.append(product.getId());
                    sb.append(',');
                    sb.append(product.getName());
                    sb.append(')');
                }
                throw new ServiceException(sb.toString());
            }
            dynamicEntityDao.remove((Serializable)category);
        }
        catch (ServiceException e) {
            LOG.error((Object)"Unable to remove entity", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException("Unable to remove entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    protected Map<String, FieldMetadata> getMergedProperties(Class<?> ceilingEntityFullyQualifiedClass, DynamicEntityDao dynamicEntityDao, Boolean populateManyToOneFields, String[] includeManyToOneFields, String[] excludeManyToOneFields, String configurationKey) throws ClassNotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] entities = dynamicEntityDao.getAllPolymorphicEntitiesFromCeiling(ceilingEntityFullyQualifiedClass);
        return dynamicEntityDao.getMergedProperties(ceilingEntityFullyQualifiedClass.getName(), entities, null, new String[0], new ForeignKey[0], MergedPropertyType.PRIMARY, populateManyToOneFields, includeManyToOneFields, excludeManyToOneFields, configurationKey, "");
    }
}

