/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.client.presenter.customer;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import java.util.HashMap;
import org.broadleafcommerce.admin.client.datasource.customer.ChallengeQuestionListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.customer.CustomerAddressDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.customer.CustomerListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.customer.LocaleListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.CountryListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.order.StateListDataSourceFactory;
import org.broadleafcommerce.admin.client.view.customer.CustomerDisplay;
import org.broadleafcommerce.openadmin.client.BLCMain;
import org.broadleafcommerce.openadmin.client.datasource.DataSourceFactory;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.AbstractDynamicDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.DynamicEntityDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.ListGridDataSource;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.OperationTypes;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.dto.Property;
import org.broadleafcommerce.openadmin.client.presenter.entity.DynamicEntityPresenter;
import org.broadleafcommerce.openadmin.client.presenter.entity.SubPresentable;
import org.broadleafcommerce.openadmin.client.presenter.structure.CreateBasedListStructurePresenter;
import org.broadleafcommerce.openadmin.client.reflection.Instantiable;
import org.broadleafcommerce.openadmin.client.service.AbstractCallback;
import org.broadleafcommerce.openadmin.client.service.AppServices;
import org.broadleafcommerce.openadmin.client.setup.AsyncCallbackAdapter;
import org.broadleafcommerce.openadmin.client.setup.PresenterSetupItem;
import org.broadleafcommerce.openadmin.client.view.dynamic.dialog.EntitySearchDialog;
import org.broadleafcommerce.openadmin.client.view.dynamic.grid.GridStructureDisplay;

public class CustomerPresenter
extends DynamicEntityPresenter
implements Instantiable {
    protected SubPresentable customerAddressPresenter;
    protected HashMap<String, Object> library = new HashMap(10);

    protected void changeSelection(Record selectedRecord) {
        this.getDisplay().getUpdateLoginButton().enable();
        this.customerAddressPresenter.load(selectedRecord, (AbstractDynamicDataSource)this.getPresenterSequenceSetupManager().getDataSource("customerDS"));
    }

    protected void addClicked() {
        this.initialValues.put("username", BLCMain.getMessageManager().getString("usernameDefault"));
        super.addClicked(BLCMain.getMessageManager().getString("newCustomerTitle"));
    }

    public void bind() {
        super.bind();
        this.customerAddressPresenter.bind();
        this.getDisplay().getUpdateLoginButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    SC.confirm((String)BLCMain.getMessageManager().getString("confirmResetPassword"), (BooleanCallback)new BooleanCallback(){

                        public void execute(Boolean value) {
                            if (value.booleanValue()) {
                                BLCMain.NON_MODAL_PROGRESS.startProgress();
                                PersistencePerspective tempPerspective = new PersistencePerspective();
                                OperationTypes opTypes = new OperationTypes();
                                tempPerspective.setOperationTypes(opTypes);
                                Entity entity = new Entity();
                                Property prop = new Property();
                                prop.setName("username");
                                prop.setValue(CustomerPresenter.this.display.getListDisplay().getGrid().getSelectedRecord().getAttribute("username"));
                                entity.setProperties(new Property[]{prop});
                                entity.setType(new String[]{"org.broadleafcommerce.profile.core.domain.Customer"});
                                AppServices.DYNAMIC_ENTITY.update(new PersistencePackage("org.broadleafcommerce.profile.core.domain.Customer", entity, tempPerspective, new String[]{"passwordUpdate"}, BLCMain.csrfToken), (AsyncCallback)new AbstractCallback<Entity>(){

                                    public void onSuccess(Entity arg0) {
                                        BLCMain.NON_MODAL_PROGRESS.stopProgress();
                                        SC.say((String)BLCMain.getMessageManager().getString("resetPasswordSuccessful"));
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }

    public void setup() {
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("customerDS", (DataSourceFactory)new CustomerListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource top) {
                CustomerPresenter.this.setupDisplayItems(top, new DataSource[0]);
                ((ListGridDataSource)top).setupGridFields(new String[]{"username", "firstName", "lastName", "emailAddress"}, new Boolean[]{true, true, true, true});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("challengeQuestionDS", (DataSourceFactory)new ChallengeQuestionListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                ((ListGridDataSource)result).resetPermanentFieldVisibility(new String[]{"question"});
                EntitySearchDialog challengeQuestionSearchView = new EntitySearchDialog((ListGridDataSource)result, true);
                CustomerPresenter.this.getPresenterSequenceSetupManager().getDataSource("customerDS").getFormItemCallbackHandlerManager().addSearchFormItemCallback("challengeQuestion", challengeQuestionSearchView, BLCMain.getMessageManager().getString("challengeQuestionSearchPrompt"), CustomerPresenter.this.display.getDynamicFormDisplay());
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("localeDS", (DataSourceFactory)new LocaleListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                ((ListGridDataSource)result).resetPermanentFieldVisibility(new String[]{"friendlyName"});
                EntitySearchDialog localeSearchView = new EntitySearchDialog((ListGridDataSource)result, true);
                CustomerPresenter.this.getPresenterSequenceSetupManager().getDataSource("customerDS").getFormItemCallbackHandlerManager().addSearchFormItemCallback("customerLocale", localeSearchView, BLCMain.getMessageManager().getString("localeSearchPrompt"), CustomerPresenter.this.display.getDynamicFormDisplay());
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("countryDS", (DataSourceFactory)new CountryListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                ((ListGridDataSource)result).resetPermanentFieldVisibility(new String[]{"abbreviation", "name"});
                EntitySearchDialog countrySearchView = new EntitySearchDialog((ListGridDataSource)result, true);
                CustomerPresenter.this.library.put("countrySearchView", countrySearchView);
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("stateDS", (DataSourceFactory)new StateListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                ((ListGridDataSource)result).resetPermanentFieldVisibility(new String[]{"abbreviation", "name"});
                EntitySearchDialog stateSearchView = new EntitySearchDialog((ListGridDataSource)result, true);
                CustomerPresenter.this.library.put("stateSearchView", stateSearchView);
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("customerAddressDS", (DataSourceFactory)new CustomerAddressDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                CustomerPresenter.this.customerAddressPresenter = new CreateBasedListStructurePresenter((GridStructureDisplay)CustomerPresenter.this.getDisplay().getCustomerAddressDisplay(), new String[]{"org.broadleafcommerce.profile.core.domain.CustomerImpl"}, BLCMain.getMessageManager().getString("newCustomerAddressTitle"));
                CustomerPresenter.this.customerAddressPresenter.setDataSource((ListGridDataSource)result, new String[]{"addressName", "address.addressLine1", "address.city", "address.state.name", "address.postalCode"}, new Boolean[]{true, true, true, true, true});
                ((DynamicEntityDataSource)result).getFormItemCallbackHandlerManager().addSearchFormItemCallback("address.country", (EntitySearchDialog)CustomerPresenter.this.library.get("countrySearchView"), BLCMain.getMessageManager().getString("countrySearchPrompt"), CustomerPresenter.this.display.getDynamicFormDisplay());
                ((DynamicEntityDataSource)result).getFormItemCallbackHandlerManager().addSearchFormItemCallback("address.state", (EntitySearchDialog)CustomerPresenter.this.library.get("stateSearchView"), BLCMain.getMessageManager().getString("stateSearchPrompt"), CustomerPresenter.this.display.getDynamicFormDisplay());
            }
        }));
    }

    public CustomerDisplay getDisplay() {
        return (CustomerDisplay)this.display;
    }
}

