/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.server.service.handler;

import com.anasoft.os.daofusion.criteria.PersistentEntityCriteria;
import com.anasoft.os.daofusion.cto.client.CriteriaTransferObject;
import com.anasoft.os.daofusion.cto.client.FilterAndSortCriteria;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.domain.OfferCodeImpl;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.broadleafcommerce.openadmin.client.dto.ClassMetadata;
import org.broadleafcommerce.openadmin.client.dto.DynamicResultSet;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.FieldMetadata;
import org.broadleafcommerce.openadmin.client.dto.ForeignKey;
import org.broadleafcommerce.openadmin.client.dto.MergedPropertyType;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.dto.Property;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.server.cto.BaseCtoConverter;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.service.handler.CustomPersistenceHandlerAdapter;
import org.broadleafcommerce.openadmin.server.service.persistence.module.InspectHelper;
import org.broadleafcommerce.openadmin.server.service.persistence.module.RecordHelper;
import org.hibernate.tool.hbm2x.StringUtils;

public class OfferCustomPersistenceHandler
extends CustomPersistenceHandlerAdapter {
    public static final String IDENTITYCRITERIA = "Offer";
    private static final Log LOG = LogFactory.getLog(OfferCustomPersistenceHandler.class);
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    public Boolean canHandleInspect(PersistencePackage persistencePackage) {
        String[] customCriteria = persistencePackage.getCustomCriteria();
        boolean canHandle = false;
        if (customCriteria != null) {
            for (String criteria : customCriteria) {
                if (criteria == null || !criteria.equals(IDENTITYCRITERIA)) continue;
                canHandle = true;
                break;
            }
        }
        return canHandle;
    }

    public Boolean canHandleFetch(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleAdd(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleRemove(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleUpdate(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public DynamicResultSet inspect(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, InspectHelper helper) throws ServiceException {
        try {
            HashMap<MergedPropertyType, Map> allMergedProperties = new HashMap<MergedPropertyType, Map>();
            Map mergedProperties = helper.getSimpleMergedProperties(Offer.class.getName(), persistencePackage.getPersistencePerspective());
            allMergedProperties.put(MergedPropertyType.PRIMARY, mergedProperties);
            mergedProperties.put("appliesToFulfillmentGroupRules", mergedProperties.get("appliesToOrderRules"));
            PersistencePerspective offerCodePersistencePerspective = new PersistencePerspective(null, new String[0], new ForeignKey[]{new ForeignKey("offer", "org.broadleafcommerce.core.offer.domain.OfferImpl", null)});
            Map offerCodeMergedProperties = helper.getSimpleMergedProperties(OfferCode.class.getName(), offerCodePersistencePerspective);
            FieldMetadata metadata = (FieldMetadata)offerCodeMergedProperties.get("offerCode");
            metadata.getPresentationAttributes().setVisibility(VisibilityEnum.HIDDEN_ALL);
            mergedProperties.put("offerCode.offerCode", metadata);
            FieldMetadata metadata2 = (FieldMetadata)offerCodeMergedProperties.get("id");
            metadata2.getPresentationAttributes().setVisibility(VisibilityEnum.HIDDEN_ALL);
            mergedProperties.put("offerCode.id", metadata2);
            Class[] entityClasses = dynamicEntityDao.getAllPolymorphicEntitiesFromCeiling(Offer.class);
            ClassMetadata mergedMetadata = helper.getMergedClassMetadata(entityClasses, allMergedProperties);
            DynamicResultSet results = new DynamicResultSet(mergedMetadata, null, null);
            return results;
        }
        catch (Exception e) {
            ServiceException ex = new ServiceException("Unable to retrieve inspection results for " + persistencePackage.getCeilingEntityFullyQualifiedClassname(), (Throwable)e);
            LOG.error((Object)("Unable to retrieve inspection results for " + persistencePackage.getCeilingEntityFullyQualifiedClassname()), (Throwable)ex);
            throw ex;
        }
    }

    public DynamicResultSet fetch(PersistencePackage persistencePackage, CriteriaTransferObject cto, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        try {
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map offerProperties = helper.getSimpleMergedProperties(Offer.class.getName(), persistencePerspective);
            BaseCtoConverter ctoConverter = helper.getCtoConverter(persistencePerspective, cto, Offer.class.getName(), offerProperties);
            PersistentEntityCriteria queryCriteria = ctoConverter.convert(cto, Offer.class.getName());
            List records = dynamicEntityDao.query(queryCriteria, Offer.class);
            Entity[] entities = helper.getRecords(offerProperties, records, null, null);
            for (int j = 0; j < entities.length; ++j) {
                OfferRule fgRule;
                OfferRule customerRule;
                Offer offer = (Offer)records.get(j);
                OfferRule orderRule = (OfferRule)offer.getOfferMatchRules().get(OfferRuleType.ORDER.getType());
                if (orderRule != null) {
                    entities[j].findProperty("appliesToOrderRules").setValue(orderRule.getMatchRule());
                }
                if ((customerRule = (OfferRule)offer.getOfferMatchRules().get(OfferRuleType.CUSTOMER.getType())) != null) {
                    entities[j].findProperty("appliesToCustomerRules").setValue(customerRule.getMatchRule());
                }
                if ((fgRule = (OfferRule)offer.getOfferMatchRules().get(OfferRuleType.FULFILLMENT_GROUP.getType())) == null) continue;
                Property prop = new Property();
                prop.setName("appliesToFulfillmentGroupRules");
                prop.setValue(fgRule.getMatchRule());
                entities[j].addProperty(prop);
            }
            PersistencePerspective offerCodePersistencePerspective = new PersistencePerspective(null, new String[0], new ForeignKey[]{new ForeignKey("offer", "org.broadleafcommerce.core.offer.domain.OfferImpl", null)});
            Map offerCodeMergedProperties = helper.getSimpleMergedProperties(OfferCode.class.getName(), offerCodePersistencePerspective);
            for (Entity record : entities) {
                CriteriaTransferObject offerCodeCto = new CriteriaTransferObject();
                FilterAndSortCriteria filterCriteria = offerCodeCto.get("offer");
                filterCriteria.setFilterValue(record.findProperty("id").getValue());
                BaseCtoConverter offerCodeCtoConverter = helper.getCtoConverter(offerCodePersistencePerspective, offerCodeCto, OfferCode.class.getName(), offerCodeMergedProperties);
                PersistentEntityCriteria offerCodeQueryCriteria = offerCodeCtoConverter.convert(offerCodeCto, OfferCode.class.getName());
                List offerCodes = dynamicEntityDao.query(offerCodeQueryCriteria, OfferCode.class);
                Entity[] offerCodeEntities = helper.getRecords(offerCodeMergedProperties, offerCodes, null, null);
                if (offerCodeEntities.length <= 0) continue;
                Entity temp = new Entity();
                temp.setType(offerCodeEntities[0].getType());
                temp.setProperties(new Property[]{offerCodeEntities[0].findProperty("offerCode"), offerCodeEntities[0].findProperty("id")});
                record.mergeProperties("offerCode", temp);
            }
            int totalRecords = helper.getTotalRecords(ceilingEntityFullyQualifiedClassname, cto, ctoConverter);
            DynamicResultSet response = new DynamicResultSet(null, entities, Integer.valueOf(totalRecords));
            return response;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to perform fetch for entity" + persistencePackage.getCeilingEntityFullyQualifiedClassname()), (Throwable)e);
            throw new ServiceException("Unable to perform fetch for entity: " + ceilingEntityFullyQualifiedClassname, (Throwable)e);
        }
    }

    protected void removeHTMLEncoding(Entity entity) {
        Property prop = entity.findProperty("targetItemCriteria.orderItemMatchRule");
        if (prop != null && prop.getValue() != null) {
            prop.setValue(prop.getUnHtmlEncodedValue());
        }
        if ((prop = entity.findProperty("appliesToCustomerRules")) != null && prop.getValue() != null) {
            prop.setValue(prop.getUnHtmlEncodedValue());
        }
        if ((prop = entity.findProperty("appliesToOrderRules")) != null && prop.getValue() != null) {
            prop.setValue(prop.getUnHtmlEncodedValue());
        }
        if ((prop = entity.findProperty("appliesToFulfillmentGroupRules")) != null && prop.getValue() != null) {
            prop.setValue(prop.getUnHtmlEncodedValue());
        }
    }

    public Entity add(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        this.removeHTMLEncoding(entity);
        try {
            Property fgProperty;
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Offer offerInstance = (Offer)Class.forName(entity.getType()[0]).newInstance();
            Map offerProperties = helper.getSimpleMergedProperties(Offer.class.getName(), persistencePerspective);
            offerInstance = (Offer)helper.createPopulatedInstance((Serializable)offerInstance, entity, offerProperties, Boolean.valueOf(false));
            this.addRule(entity, offerInstance, "appliesToOrderRules", OfferRuleType.ORDER);
            this.addRule(entity, offerInstance, "appliesToCustomerRules", OfferRuleType.CUSTOMER);
            this.addRule(entity, offerInstance, "appliesToFulfillmentGroupRules", OfferRuleType.FULFILLMENT_GROUP);
            dynamicEntityDao.persist((Serializable)offerInstance);
            OfferCode offerCode = null;
            if (entity.findProperty("deliveryType").getValue().equals("CODE")) {
                offerCode = (OfferCode)this.entityConfiguration.createEntityInstance(OfferCode.class.getName());
                offerCode.setOfferCode(entity.findProperty("offerCode.offerCode").getValue());
                offerCode.setEndDate(offerInstance.getEndDate());
                offerCode.setMaxUses(offerInstance.getMaxUses());
                offerCode.setOffer(offerInstance);
                offerCode.setStartDate(offerInstance.getStartDate());
                dynamicEntityDao.merge((Serializable)offerCode);
            }
            Entity offerEntity = helper.getRecord(offerProperties, (Serializable)offerInstance, null, null);
            if (offerCode != null) {
                PersistencePerspective offerCodePersistencePerspective = new PersistencePerspective(null, new String[0], new ForeignKey[]{new ForeignKey("offer", "org.broadleafcommerce.core.offer.domain.OfferImpl", null)});
                Map offerCodeMergedProperties = helper.getSimpleMergedProperties(OfferCode.class.getName(), offerCodePersistencePerspective);
                Entity offerCodeEntity = helper.getRecord(offerCodeMergedProperties, (Serializable)offerCode, null, null);
                Entity temp = new Entity();
                temp.setType(offerCodeEntity.getType());
                temp.setProperties(new Property[]{offerCodeEntity.findProperty("offerCode"), offerCodeEntity.findProperty("id")});
                offerEntity.mergeProperties("offerCode", temp);
            }
            if ((fgProperty = entity.findProperty("appliesToFulfillmentGroupRules")) != null) {
                offerEntity.addProperty(fgProperty);
            }
            return offerEntity;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to add entity for " + entity.getType()[0]), (Throwable)e);
            throw new ServiceException("Unable to add entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    public void remove(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            OfferCode offerCode;
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Property offerCodeId = entity.findProperty("offerCode.id");
            if (offerCodeId != null && (offerCode = (OfferCode)dynamicEntityDao.retrieve(OfferCodeImpl.class, (Object)Long.valueOf(entity.findProperty("offerCode.id").getValue()))) != null) {
                offerCode.setOffer(null);
                dynamicEntityDao.remove((Serializable)offerCode);
            }
            Map offerProperties = helper.getSimpleMergedProperties(Offer.class.getName(), persistencePerspective);
            Object primaryKey = helper.getPrimaryKey(entity, offerProperties);
            Offer offerInstance = (Offer)dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            dynamicEntityDao.remove((Serializable)offerInstance);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to remove entity for " + entity.getType()[0] + ". It is likely this offer is currently associated with one or more orders. Only unused offers may be deleted."), (Throwable)e);
            throw new ServiceException("Unable to remove entity for " + entity.getType()[0] + ". It is likely this offer is currently associated with one or more orders. Only unused offers may be deleted.", (Throwable)e);
        }
    }

    public Entity update(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        this.removeHTMLEncoding(entity);
        try {
            Property fgProperty;
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            Map offerProperties = helper.getSimpleMergedProperties(Offer.class.getName(), persistencePerspective);
            Object primaryKey = helper.getPrimaryKey(entity, offerProperties);
            Offer offerInstance = (Offer)dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            offerInstance = (Offer)helper.createPopulatedInstance((Serializable)offerInstance, entity, offerProperties, Boolean.valueOf(false));
            this.updateRule(entity, offerInstance, "appliesToOrderRules", OfferRuleType.ORDER);
            this.updateRule(entity, offerInstance, "appliesToCustomerRules", OfferRuleType.CUSTOMER);
            this.updateRule(entity, offerInstance, "appliesToFulfillmentGroupRules", OfferRuleType.FULFILLMENT_GROUP);
            if (entity.findProperty("type") != null && !entity.findProperty("type").getValue().equals("ORDER_ITEM") && offerInstance.getTargetItemCriteria() != null) {
                offerInstance.getTargetItemCriteria().setOffer(null);
                offerInstance.setTargetItemCriteria(null);
            }
            dynamicEntityDao.merge((Serializable)offerInstance);
            Property offerCodeId = entity.findProperty("offerCode.id");
            OfferCode offerCode = null;
            if (entity.findProperty("deliveryType") != null && entity.findProperty("deliveryType").getValue().equals("CODE")) {
                offerCode = offerCodeId == null ? (OfferCode)this.entityConfiguration.createEntityInstance(OfferCode.class.getName()) : (OfferCode)dynamicEntityDao.retrieve(OfferCodeImpl.class, (Object)Long.valueOf(entity.findProperty("offerCode.id").getValue()));
                offerCode.setOfferCode(entity.findProperty("offerCode.offerCode").getValue());
                offerCode.setEndDate(offerInstance.getEndDate());
                offerCode.setMaxUses(offerInstance.getMaxUses());
                offerCode.setOffer(offerInstance);
                offerCode.setStartDate(offerInstance.getStartDate());
                dynamicEntityDao.merge((Serializable)offerCode);
            } else if (offerCodeId != null) {
                offerCode = (OfferCode)dynamicEntityDao.retrieve(OfferCodeImpl.class, (Object)Long.valueOf(entity.findProperty("offerCode.id").getValue()));
                offerCode.setOffer(null);
                dynamicEntityDao.remove((Serializable)offerCode);
                offerCode = null;
            }
            Entity offerEntity = helper.getRecord(offerProperties, (Serializable)offerInstance, null, null);
            if (offerCode != null) {
                PersistencePerspective offerCodePersistencePerspective = new PersistencePerspective(null, new String[0], new ForeignKey[]{new ForeignKey("offer", "org.broadleafcommerce.core.offer.domain.OfferImpl", null)});
                Map offerCodeMergedProperties = helper.getSimpleMergedProperties(OfferCode.class.getName(), offerCodePersistencePerspective);
                Entity offerCodeEntity = helper.getRecord(offerCodeMergedProperties, (Serializable)offerCode, null, null);
                Entity temp = new Entity();
                temp.setType(offerCodeEntity.getType());
                temp.setProperties(new Property[]{offerCodeEntity.findProperty("offerCode"), offerCodeEntity.findProperty("id")});
                offerEntity.mergeProperties("offerCode", temp);
            }
            if ((fgProperty = entity.findProperty("appliesToFulfillmentGroupRules")) != null) {
                offerEntity.addProperty(fgProperty);
            }
            return offerEntity;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to update entity for " + entity.getType()[0]), (Throwable)e);
            throw new ServiceException("Unable to update entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    protected void addRule(Entity entity, Offer offerInstance, String propertyName, OfferRuleType type) {
        Property ruleProperty = entity.findProperty(propertyName);
        if (ruleProperty != null && !StringUtils.isEmpty((String)ruleProperty.getValue())) {
            OfferRule rule = (OfferRule)this.entityConfiguration.createEntityInstance(OfferRule.class.getName());
            rule.setMatchRule(ruleProperty.getValue());
            offerInstance.getOfferMatchRules().put(type.getType(), rule);
        }
    }

    protected void updateRule(Entity entity, Offer offerInstance, String propertyName, OfferRuleType type) {
        Property ruleProperty = entity.findProperty(propertyName);
        if (ruleProperty != null && !StringUtils.isEmpty((String)ruleProperty.getValue())) {
            OfferRule rule = (OfferRule)offerInstance.getOfferMatchRules().get(type.getType());
            if (rule == null) {
                rule = (OfferRule)this.entityConfiguration.createEntityInstance(OfferRule.class.getName());
            }
            rule.setMatchRule(ruleProperty.getValue());
            offerInstance.getOfferMatchRules().put(type.getType(), rule);
        } else {
            offerInstance.getOfferMatchRules().remove(type.getType());
        }
    }
}

