/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.client.presenter.order;

import com.smartgwt.client.data.DSCallback;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.widgets.DataBoundComponent;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.grid.events.SelectionChangedHandler;
import com.smartgwt.client.widgets.grid.events.SelectionEvent;
import java.util.Arrays;
import org.broadleafcommerce.admin.client.view.order.OrderItemDisplay;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.AbstractDynamicDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.DynamicEntityDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.ListGridDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.PresentationLayerAssociatedDataSource;
import org.broadleafcommerce.openadmin.client.dto.ClassTree;
import org.broadleafcommerce.openadmin.client.presenter.entity.DynamicFormPresenter;
import org.broadleafcommerce.openadmin.client.presenter.entity.SubPresentable;
import org.broadleafcommerce.openadmin.client.view.dynamic.form.DynamicFormDisplay;

public class OrderItemPresenter
extends DynamicFormPresenter
implements SubPresentable {
    protected OrderItemDisplay display;
    protected Record associatedRecord;
    protected AbstractDynamicDataSource abstractDynamicDataSource;
    protected Boolean disabled = false;
    protected String[] availableToTypes;

    public OrderItemPresenter(OrderItemDisplay display, String[] availableToTypes) {
        super((DynamicFormDisplay)display);
        this.display = display;
        this.availableToTypes = availableToTypes;
    }

    public void setDataSource(ListGridDataSource dataSource, String[] gridFields, Boolean[] editable) {
        this.display.getGrid().setDataSource((DataSource)dataSource);
        dataSource.setAssociatedGrid((DataBoundComponent)this.display.getGrid());
        dataSource.setupGridFields(gridFields, editable);
        this.display.getFormOnlyDisplay().buildFields((DataSource)dataSource, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null);
    }

    public void setExpansionDataSource(ListGridDataSource dataSource, String[] gridFields, Boolean[] editable) {
        this.display.getExpansionGrid().setDataSource((DataSource)dataSource);
        dataSource.setAssociatedGrid((DataBoundComponent)this.display.getExpansionGrid());
        dataSource.setupGridFields(gridFields, editable);
    }

    public void setStartState() {
        if (!this.disabled.booleanValue()) {
            super.setStartState();
            this.display.getAddButton().enable();
            this.display.getGrid().enable();
            this.display.getRemoveButton().disable();
        }
    }

    public void enable() {
        this.disabled = false;
        super.enable();
        this.display.getAddButton().enable();
        this.display.getGrid().enable();
        this.display.getRemoveButton().enable();
        this.display.getToolbar().enable();
    }

    public void disable() {
        this.disabled = true;
        super.disable();
        this.display.getAddButton().disable();
        this.display.getGrid().disable();
        this.display.getRemoveButton().disable();
        this.display.getToolbar().disable();
    }

    public void setReadOnly(Boolean readOnly) {
        if (readOnly.booleanValue()) {
            this.disable();
            this.display.getGrid().enable();
        } else {
            this.enable();
        }
    }

    public boolean load(Record associatedRecord, AbstractDynamicDataSource associatedDataSource) {
        return this.load(associatedRecord, associatedDataSource, null);
    }

    public boolean load(Record associatedRecord, AbstractDynamicDataSource abstractDynamicDataSource, final DSCallback cb) {
        boolean shouldLoad;
        this.associatedRecord = associatedRecord;
        this.abstractDynamicDataSource = abstractDynamicDataSource;
        ClassTree classTree = abstractDynamicDataSource.getPolymorphicEntityTree();
        String[] types = associatedRecord.getAttributeAsStringArray("_type");
        boolean bl = shouldLoad = this.availableToTypes == null;
        if (types != null && types.length > 0 && this.availableToTypes != null) {
            if (Arrays.binarySearch(this.availableToTypes, types[0]) >= 0) {
                shouldLoad = true;
            } else {
                ClassTree myTypeResult = classTree.find(types[0]);
                if (myTypeResult != null) {
                    for (String availableType : this.availableToTypes) {
                        ClassTree availableTypeResult = classTree.find(availableType);
                        if (availableTypeResult.getLeft() >= myTypeResult.getLeft() || availableTypeResult.getRight() <= myTypeResult.getRight()) continue;
                        shouldLoad = true;
                        break;
                    }
                }
            }
        }
        if (shouldLoad) {
            String id = abstractDynamicDataSource.getPrimaryKeyValue(associatedRecord);
            ((PresentationLayerAssociatedDataSource)this.display.getGrid().getDataSource()).loadAssociatedGridBasedOnRelationship(id, new DSCallback(){

                public void execute(DSResponse response, Object rawData, DSRequest request) {
                    OrderItemPresenter.this.setStartState();
                    if (cb != null) {
                        cb.execute(response, rawData, request);
                    }
                }
            });
        }
        return shouldLoad;
    }

    public void bind() {
        super.bind();
        this.display.getGrid().addSelectionChangedHandler(new SelectionChangedHandler(){

            public void onSelectionChanged(SelectionEvent event) {
                if (event.getState()) {
                    OrderItemPresenter.this.display.getRemoveButton().enable();
                    ((DynamicEntityDataSource)OrderItemPresenter.this.display.getGrid().getDataSource()).resetPermanentFieldVisibilityBasedOnType(event.getSelectedRecord().getAttributeAsStringArray("_type"));
                    OrderItemPresenter.this.display.getFormOnlyDisplay().buildFields(OrderItemPresenter.this.display.getGrid().getDataSource(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), event.getRecord());
                    OrderItemPresenter.this.display.getFormOnlyDisplay().getForm().editRecord(event.getRecord());
                    OrderItemPresenter.this.display.getFormOnlyDisplay().getForm().enable();
                } else {
                    OrderItemPresenter.this.display.getRemoveButton().disable();
                }
            }
        });
        this.display.getExpansionGrid().addSelectionChangedHandler(new SelectionChangedHandler(){

            public void onSelectionChanged(SelectionEvent event) {
                if (event.getState()) {
                    ((DynamicEntityDataSource)OrderItemPresenter.this.display.getExpansionGrid().getDataSource()).resetPermanentFieldVisibilityBasedOnType(event.getSelectedRecord().getAttributeAsStringArray("_type"));
                    OrderItemPresenter.this.display.getFormOnlyDisplay().buildFields(OrderItemPresenter.this.display.getExpansionGrid().getDataSource(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), event.getRecord());
                    OrderItemPresenter.this.display.getFormOnlyDisplay().getForm().editRecord(event.getRecord());
                    OrderItemPresenter.this.display.getFormOnlyDisplay().getForm().enable();
                }
            }
        });
        this.display.getRemoveButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    OrderItemPresenter.this.display.getGrid().removeData((Record)OrderItemPresenter.this.display.getGrid().getSelectedRecord(), new DSCallback(){

                        public void execute(DSResponse response, Object rawData, DSRequest request) {
                            OrderItemPresenter.this.display.getRemoveButton().disable();
                        }
                    });
                }
            }
        });
    }
}

