/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.client.presenter.catalog.product;

import com.smartgwt.client.data.DSCallback;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.widgets.form.fields.FormItem;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.broadleafcommerce.admin.client.datasource.catalog.StaticAssetsTileGridDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.category.CategoryListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.category.MediaMapDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.product.CrossSaleProductListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.product.OneToOneProductSkuDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.product.ParentCategoryListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.product.ProductAttributeDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.product.ProductListDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.product.ProductMediaMapDataSourceFactory;
import org.broadleafcommerce.admin.client.datasource.catalog.product.UpSaleProductListDataSourceFactory;
import org.broadleafcommerce.admin.client.view.catalog.product.OneToOneProductSkuDisplay;
import org.broadleafcommerce.openadmin.client.BLCMain;
import org.broadleafcommerce.openadmin.client.callback.TileGridItemSelected;
import org.broadleafcommerce.openadmin.client.callback.TileGridItemSelectedHandler;
import org.broadleafcommerce.openadmin.client.datasource.DataSourceFactory;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.AbstractDynamicDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.ListGridDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.TileGridDataSource;
import org.broadleafcommerce.openadmin.client.dto.OperationType;
import org.broadleafcommerce.openadmin.client.dto.OperationTypes;
import org.broadleafcommerce.openadmin.client.presenter.entity.DynamicEntityPresenter;
import org.broadleafcommerce.openadmin.client.presenter.entity.FormItemCallback;
import org.broadleafcommerce.openadmin.client.presenter.entity.SubPresentable;
import org.broadleafcommerce.openadmin.client.presenter.structure.CreateBasedListStructurePresenter;
import org.broadleafcommerce.openadmin.client.presenter.structure.EditableJoinStructurePresenter;
import org.broadleafcommerce.openadmin.client.presenter.structure.MapStructurePresenter;
import org.broadleafcommerce.openadmin.client.presenter.structure.SimpleSearchJoinStructurePresenter;
import org.broadleafcommerce.openadmin.client.reflection.Instantiable;
import org.broadleafcommerce.openadmin.client.setup.AsyncCallbackAdapter;
import org.broadleafcommerce.openadmin.client.setup.PresenterSetupItem;
import org.broadleafcommerce.openadmin.client.view.dynamic.dialog.AssetSearchDialog;
import org.broadleafcommerce.openadmin.client.view.dynamic.dialog.EntitySearchDialog;
import org.broadleafcommerce.openadmin.client.view.dynamic.dialog.MapStructureEntityEditDialog;

public class OneToOneProductSkuPresenter
extends DynamicEntityPresenter
implements Instantiable {
    protected MapStructureEntityEditDialog mapEntityAdd;
    protected EntitySearchDialog productSearchView;
    protected SubPresentable crossSalePresenter;
    protected SubPresentable upSalePresenter;
    protected SubPresentable mediaPresenter;
    protected SubPresentable productAttributePresenter;
    protected SubPresentable parentCategoriesPresenter;
    protected HashMap<String, Object> library = new HashMap(10);

    protected void changeSelection(Record selectedRecord) {
        AbstractDynamicDataSource dataSource = (AbstractDynamicDataSource)this.display.getListDisplay().getGrid().getDataSource();
        this.crossSalePresenter.load(selectedRecord, dataSource, new DSCallback(){

            public void execute(DSResponse response, Object rawData, DSRequest request) {
            }
        });
        this.upSalePresenter.load(selectedRecord, dataSource, null);
        this.mediaPresenter.load(selectedRecord, dataSource, null);
        this.productAttributePresenter.load(selectedRecord, dataSource, null);
        this.parentCategoriesPresenter.load(selectedRecord, dataSource, null);
    }

    protected void itemSaved(DSResponse response, Object rawData, DSRequest request) {
        super.itemSaved(response, rawData, request);
        this.getDisplay().getAllCategoriesDisplay().getGrid().invalidateCache();
    }

    public void bind() {
        super.bind();
        this.crossSalePresenter.bind();
        this.upSalePresenter.bind();
        this.mediaPresenter.bind();
        this.productAttributePresenter.bind();
        this.parentCategoriesPresenter.bind();
    }

    protected void addClicked() {
        this.initialValues.put("name", BLCMain.getMessageManager().getString("defaultProductName"));
        this.addClicked(BLCMain.getMessageManager().getString("newProductTitle"));
    }

    public void setup() {
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("productDS", (DataSourceFactory)new OneToOneProductSkuDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource top) {
                OneToOneProductSkuPresenter.this.setupDisplayItems(top, new DataSource[0]);
                ((ListGridDataSource)top).setupGridFields(new String[0], new Boolean[0]);
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("categorySearch", (DataSourceFactory)new CategoryListDataSourceFactory(), new OperationTypes(OperationType.ENTITY, OperationType.ENTITY, OperationType.JOINSTRUCTURE, OperationType.ENTITY, OperationType.ENTITY), new Object[0], new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                ListGridDataSource categorySearchDataSource = (ListGridDataSource)result;
                categorySearchDataSource.resetPermanentFieldVisibility(new String[]{"name", "urlKey", "activeStartDate", "activeEndDate"});
                EntitySearchDialog categorySearchView = new EntitySearchDialog(categorySearchDataSource);
                OneToOneProductSkuPresenter.this.library.put("categorySearchView", categorySearchView);
                OneToOneProductSkuPresenter.this.getPresenterSequenceSetupManager().getDataSource("productDS").getFormItemCallbackHandlerManager().addSearchFormItemCallback("defaultCategory", categorySearchView, BLCMain.getMessageManager().getString("categorySearchTitle"), OneToOneProductSkuPresenter.this.getDisplay().getDynamicFormDisplay());
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("oneToOneProductSearchDS", (DataSourceFactory)new ProductListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                ListGridDataSource productSearchDataSource = (ListGridDataSource)result;
                productSearchDataSource.resetPermanentFieldVisibility(new String[]{"name", "description", "model", "manufacturer", "activeStartDate", "activeEndDate"});
                OneToOneProductSkuPresenter.this.productSearchView = new EntitySearchDialog(productSearchDataSource);
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("crossSaleProductsDS", (DataSourceFactory)new CrossSaleProductListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                OneToOneProductSkuPresenter.this.crossSalePresenter = new EditableJoinStructurePresenter(OneToOneProductSkuPresenter.this.getDisplay().getCrossSaleDisplay(), OneToOneProductSkuPresenter.this.productSearchView, new String[]{"org.broadleafcommerce.core.catalog.domain.ProductImpl"}, BLCMain.getMessageManager().getString("productSearchTitle"), BLCMain.getMessageManager().getString("setPromotionMessageTitle"), new String[]{"promotionMessage"});
                OneToOneProductSkuPresenter.this.crossSalePresenter.setDataSource((ListGridDataSource)result, new String[]{"name", "promotionMessage"}, new Boolean[]{false, true});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("upSaleProductsDS", (DataSourceFactory)new UpSaleProductListDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                OneToOneProductSkuPresenter.this.upSalePresenter = new EditableJoinStructurePresenter(OneToOneProductSkuPresenter.this.getDisplay().getUpSaleDisplay(), OneToOneProductSkuPresenter.this.productSearchView, new String[]{"org.broadleafcommerce.core.catalog.domain.ProductImpl"}, BLCMain.getMessageManager().getString("productSearchTitle"), BLCMain.getMessageManager().getString("setPromotionMessageTitle"), new String[]{"promotionMessage"});
                OneToOneProductSkuPresenter.this.upSalePresenter.setDataSource((ListGridDataSource)result, new String[]{"name", "promotionMessage"}, new Boolean[]{false, true});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("productMediaMapDS", (DataSourceFactory)new ProductMediaMapDataSourceFactory(this), null, new Object[]{this.getMediaMapKeys()}, new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                HashMap<String, String> initialValues = new HashMap<String, String>(2);
                initialValues.put("name", BLCMain.getMessageManager().getString("mediaNameDefault"));
                initialValues.put("label", BLCMain.getMessageManager().getString("mediaLabelDefault"));
                OneToOneProductSkuPresenter.this.mediaPresenter = new MapStructurePresenter(OneToOneProductSkuPresenter.this.getDisplay().getMediaDisplay(), OneToOneProductSkuPresenter.this.getMediaEntityView(), new String[]{"org.broadleafcommerce.core.catalog.domain.ProductImpl"}, BLCMain.getMessageManager().getString("newMediaTitle"), initialValues);
                OneToOneProductSkuPresenter.this.mediaPresenter.setDataSource((ListGridDataSource)result, new String[]{"key", "name", "url", "label"}, new Boolean[]{true, true, true, true});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("productAttributeDS", (DataSourceFactory)new ProductAttributeDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                HashMap<String, String> initialValues = new HashMap<String, String>(1);
                initialValues.put("name", "Untitled");
                OneToOneProductSkuPresenter.this.productAttributePresenter = new CreateBasedListStructurePresenter(OneToOneProductSkuPresenter.this.getDisplay().getAttributesDisplay(), new String[]{"org.broadleafcommerce.core.catalog.domain.ProductImpl"}, BLCMain.getMessageManager().getString("newAttributeTitle"), initialValues);
                OneToOneProductSkuPresenter.this.productAttributePresenter.setDataSource((ListGridDataSource)result, new String[]{"name", "value", "searchable"}, new Boolean[]{true, true, true});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("parentCategoriesDS", (DataSourceFactory)new ParentCategoryListDataSourceFactory(), new OperationTypes(OperationType.JOINSTRUCTURE, OperationType.JOINSTRUCTURE, OperationType.JOINSTRUCTURE, OperationType.JOINSTRUCTURE, OperationType.ENTITY), new Object[0], new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource result) {
                OneToOneProductSkuPresenter.this.parentCategoriesPresenter = new SimpleSearchJoinStructurePresenter(OneToOneProductSkuPresenter.this.getDisplay().getAllCategoriesDisplay(), (EntitySearchDialog)OneToOneProductSkuPresenter.this.library.get("categorySearchView"), new String[]{"org.broadleafcommerce.core.catalog.domain.ProductImpl"}, BLCMain.getMessageManager().getString("categorySearchPrompt"));
                OneToOneProductSkuPresenter.this.parentCategoriesPresenter.setDataSource((ListGridDataSource)result, new String[]{"name", "urlKey"}, new Boolean[]{false, false});
            }
        }));
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("staticAssetTreeDS", (DataSourceFactory)new StaticAssetsTileGridDataSourceFactory(), new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource dataSource) {
                TileGridDataSource staticAssetTreeDS = (TileGridDataSource)dataSource;
                final AssetSearchDialog assetSearchDialogView = new AssetSearchDialog(staticAssetTreeDS);
                OneToOneProductSkuPresenter.this.getPresenterSequenceSetupManager().getDataSource("productMediaMapDS").getFormItemCallbackHandlerManager().addFormItemCallback("url", new FormItemCallback(){

                    public void execute(final FormItem formItem) {
                        assetSearchDialogView.search("Asset Search", new TileGridItemSelectedHandler(){

                            public void onSearchItemSelected(TileGridItemSelected event) {
                                String staticAssetFullUrl = BLCMain.assetServerUrlPrefix + event.getRecord().getAttribute("fullUrl");
                                formItem.setValue(staticAssetFullUrl);
                                OneToOneProductSkuPresenter.this.getMediaEntityView().updateMedia(staticAssetFullUrl);
                            }
                        });
                    }
                });
            }
        }));
    }

    protected LinkedHashMap<String, String> getMediaMapKeys() {
        LinkedHashMap<String, String> keys = new LinkedHashMap<String, String>(3);
        keys.put("small", BLCMain.getMessageManager().getString("mediaSizeSmall"));
        keys.put("medium", BLCMain.getMessageManager().getString("mediaSizeMedium"));
        keys.put("large", BLCMain.getMessageManager().getString("mediaSizeLarge"));
        return keys;
    }

    protected MapStructureEntityEditDialog getMediaEntityView() {
        if (this.mapEntityAdd == null) {
            this.mapEntityAdd = new MapStructureEntityEditDialog(MediaMapDataSourceFactory.MAPSTRUCTURE, this.getMediaMapKeys());
            this.mapEntityAdd.setShowMedia(true);
            this.mapEntityAdd.setMediaField("url");
        }
        return this.mapEntityAdd;
    }

    public OneToOneProductSkuDisplay getDisplay() {
        return (OneToOneProductSkuDisplay)this.display;
    }
}

