/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.admin.client.presenter.promotion;

import com.google.gwt.core.client.GWT;
import com.smartgwt.client.data.AdvancedCriteria;
import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.DSCallback;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import java.util.LinkedHashMap;
import org.broadleafcommerce.admin.client.presenter.promotion.OfferPresenter;
import org.broadleafcommerce.admin.client.view.promotion.OfferDisplay;
import org.broadleafcommerce.openadmin.client.BLCMain;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.DynamicEntityDataSource;
import org.broadleafcommerce.openadmin.client.translation.IncompatibleMVELTranslationException;
import org.broadleafcommerce.openadmin.client.translation.MVELToAdvancedCriteriaTranslator;
import org.broadleafcommerce.openadmin.client.view.dynamic.ItemBuilderDisplay;

public class OfferPresenterInitializer {
    private static final MVELToAdvancedCriteriaTranslator TRANSLATOR = new MVELToAdvancedCriteriaTranslator();
    protected OfferPresenter presenter;
    protected boolean customerRuleIncompatible = false;
    protected boolean orderRuleIncompatible = false;
    protected boolean fgRuleIncompatible = false;
    protected DynamicEntityDataSource offerItemCriteriaDataSource;
    protected DynamicEntityDataSource orderItemDataSource;

    public OfferPresenterInitializer(OfferPresenter presenter, DynamicEntityDataSource offerItemCriteriaDataSource, DynamicEntityDataSource orderItemDataSource) {
        this.presenter = presenter;
        this.offerItemCriteriaDataSource = offerItemCriteriaDataSource;
        this.orderItemDataSource = orderItemDataSource;
    }

    protected OfferDisplay getDisplay() {
        return this.presenter.getDisplay();
    }

    public void initSectionBasedOnType(String sectionType, Record selectedRecord) {
        this.getDisplay().getCustomerLayout().setVisible(true);
        this.getDisplay().getOrderSectionLayout().setVisible(true);
        this.getDisplay().getCustomerSection().setVisible(true);
        this.getDisplay().getOrderSection().setVisible(true);
        this.getDisplay().getItemQualificationSectionView().setVisible(true);
        if (sectionType.equals("FULFILLMENT_GROUP")) {
            this.getDisplay().getFgSectionView().setVisible(true);
        } else {
            this.getDisplay().getFgSectionView().setVisible(false);
        }
        if (sectionType.equals("ORDER_ITEM")) {
            this.getDisplay().getBogoQuestionLayout().setVisible(true);
            this.getDisplay().getItemTargetSectionView().setVisible(true);
            this.getDisplay().getOrderItemLayout().setVisible(false);
            this.getDisplay().getRequiredItemsLayout().setVisible(false);
            this.getDisplay().getOrderItemCombineForm().setVisible(true);
            this.getDisplay().getOrderItemCombineLabel().setVisible(true);
        } else {
            this.getDisplay().getBogoQuestionLayout().setVisible(false);
            this.getDisplay().getItemTargetSectionView().setVisible(false);
            this.getDisplay().getRequiredItemsLayout().setVisible(true);
            this.getDisplay().getOrderItemLayout().setVisible(true);
            this.getDisplay().getOrderItemCombineForm().setVisible(false);
            this.getDisplay().getOrderItemCombineLabel().setVisible(false);
        }
        if (sectionType.equals("ORDER")) {
            this.getDisplay().getOrderCombineForm().setVisible(true);
            this.getDisplay().getOrderCombineLabel().setVisible(true);
            LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
            String[][] enumerationValues = (String[][])this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getDataSource().getField("discountType").getAttributeAsObject("enumerationValues");
            for (int j = 0; j < enumerationValues.length; ++j) {
                if (enumerationValues[j][0].equals("FIX_PRICE")) continue;
                valueMap.put(enumerationValues[j][0], enumerationValues[j][1]);
            }
            this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getField("discountType").setValueMap(valueMap);
            if (this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getField("discountType").getValue().equals("FIX_PRICE")) {
                this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getField("discountType").setValue("PERCENT_OFF");
                this.getDisplay().getOrderCombineForm().enable();
                this.getDisplay().getFGCombineForm().enable();
                this.getDisplay().getOrderItemCombineForm().enable();
                this.getDisplay().getOrderCombineRuleRadio().setValue("YES");
                this.getDisplay().getFgCombineRuleRadio().setValue("YES");
                this.getDisplay().getOrderItemCombineRuleRadio().setValue("YES");
            }
        } else {
            this.getDisplay().getOrderCombineForm().setVisible(false);
            this.getDisplay().getOrderCombineLabel().setVisible(false);
            LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
            String[][] enumerationValues = (String[][])this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getDataSource().getField("discountType").getAttributeAsObject("enumerationValues");
            for (int j = 0; j < enumerationValues.length; ++j) {
                valueMap.put(enumerationValues[j][0], enumerationValues[j][1]);
            }
            this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getField("discountType").setValueMap(valueMap);
        }
        this.initBasicItems(selectedRecord);
        this.initCustomerCriteria(selectedRecord);
        this.initOrderCriteria(selectedRecord);
        this.initItemQualifiers(selectedRecord, sectionType);
        if (sectionType.equals("ORDER_ITEM")) {
            this.initItemTargets(selectedRecord);
        } else if (sectionType.equals("FULFILLMENT_GROUP")) {
            this.initFGCriteria(selectedRecord);
        }
    }

    public void initItemTargets(Record selectedRecord) {
        String offerItemTargetRuleType;
        this.getDisplay().getTargetItemBuilder().setIncompatibleMVEL(Boolean.valueOf(false));
        this.getDisplay().getTargetItemBuilder().getItemFilterBuilder().setVisible(true);
        this.getDisplay().getTargetItemBuilder().getRawItemForm().setVisible(false);
        this.getDisplay().getTargetItemBuilder().getRawItemTextArea().setValue("");
        this.getDisplay().getTargetItemBuilder().getItemFilterBuilder().clearCriteria();
        String targetQuantity = selectedRecord.getAttribute("targetItemCriteria.quantity");
        if (targetQuantity != null) {
            this.getDisplay().getTargetItemBuilder().getItemQuantity().setValue(Integer.parseInt(targetQuantity));
            String itemTargetRules = selectedRecord.getAttribute("targetItemCriteria.orderItemMatchRule");
            try {
                AdvancedCriteria myCriteria = TRANSLATOR.createAdvancedCriteria(itemTargetRules, this.getDisplay().getTargetItemBuilder().getItemFilterBuilder().getDataSource());
                if (myCriteria != null) {
                    this.getDisplay().getTargetItemBuilder().getItemFilterBuilder().setCriteria(myCriteria);
                }
            }
            catch (IncompatibleMVELTranslationException e) {
                GWT.log((String)"Could not translate MVEL", (Throwable)e);
                BLCMain.MASTERVIEW.getStatus().setContents(BLCMain.getMessageManager().getString("mvelTranslationProblem"));
                this.getDisplay().getTargetItemBuilder().setIncompatibleMVEL(Boolean.valueOf(true));
                this.getDisplay().getTargetItemBuilder().getItemFilterBuilder().setVisible(false);
                this.getDisplay().getTargetItemBuilder().getRawItemForm().setVisible(true);
                this.getDisplay().getTargetItemBuilder().getRawItemTextArea().setValue(itemTargetRules);
            }
        }
        if ((offerItemTargetRuleType = selectedRecord.getAttribute("offerItemTargetRuleType")) == null) {
            offerItemTargetRuleType = "NONE";
        }
        if (offerItemTargetRuleType.equals("NONE")) {
            this.getDisplay().getQualifyForAnotherPromoTargetRadio().setValue("NO");
            this.getDisplay().getReceiveFromAnotherPromoTargetRadio().setValue("NO");
        } else if (offerItemTargetRuleType.equals("QUALIFIER")) {
            this.getDisplay().getQualifyForAnotherPromoTargetRadio().setValue("YES");
            this.getDisplay().getReceiveFromAnotherPromoTargetRadio().setValue("NO");
        } else if (offerItemTargetRuleType.equals("TARGET")) {
            this.getDisplay().getQualifyForAnotherPromoTargetRadio().setValue("NO");
            this.getDisplay().getReceiveFromAnotherPromoTargetRadio().setValue("YES");
        } else if (offerItemTargetRuleType.equals("QUALIFIER_TARGET")) {
            this.getDisplay().getQualifyForAnotherPromoTargetRadio().setValue("YES");
            this.getDisplay().getReceiveFromAnotherPromoTargetRadio().setValue("YES");
        }
    }

    public void initBasicItems(Record selectedRecord) {
        Boolean isTotalitarianOffer = selectedRecord.getAttributeAsBoolean("totalitarianOffer");
        this.getDisplay().getRestrictRuleRadio().setValue(isTotalitarianOffer != false ? "YES" : "NO");
        String deliveryType = selectedRecord.getAttribute("deliveryType");
        this.getDisplay().getDeliveryTypeRadio().setValue(deliveryType);
        this.initDeliveryType(deliveryType, selectedRecord);
    }

    public void initCustomerCriteria(Record selectedRecord) {
        this.customerRuleIncompatible = false;
        this.getDisplay().getCustomerFilterBuilder().clearCriteria();
        String customerRules = selectedRecord.getAttribute("appliesToCustomerRules");
        String customerRule = customerRules == null ? "ALL" : "CUSTOMER_RULE";
        this.getDisplay().getCustomerRuleRadio().setValue(customerRule);
        if (customerRules != null) {
            this.getDisplay().getCustomerRuleRadio().setValue(customerRule);
            try {
                AdvancedCriteria myCriteria = TRANSLATOR.createAdvancedCriteria(customerRules, this.getDisplay().getCustomerFilterBuilder().getDataSource());
                if (myCriteria != null) {
                    this.getDisplay().getCustomerFilterBuilder().setCriteria(myCriteria);
                }
            }
            catch (IncompatibleMVELTranslationException e) {
                this.customerRuleIncompatible = true;
                GWT.log((String)"Could not translate MVEL", (Throwable)e);
                BLCMain.MASTERVIEW.getStatus().setContents(BLCMain.getMessageManager().getString("mvelTranslationProblem"));
                this.getDisplay().getRawCustomerTextArea().setValue(customerRules);
            }
        }
        this.initCustomerRule(customerRule, selectedRecord);
    }

    public void initFGCriteria(Record selectedRecord) {
        Boolean combinable;
        this.fgRuleIncompatible = false;
        this.getDisplay().getFulfillmentGroupFilterBuilder().clearCriteria();
        String fgRules = selectedRecord.getAttribute("appliesToFulfillmentGroupRules");
        String fgRule = fgRules == null ? "ALL" : "FG_RULE";
        this.getDisplay().getFgRuleRadio().setValue(fgRule);
        if (fgRules != null) {
            this.getDisplay().getFgRuleRadio().setValue(fgRule);
            try {
                AdvancedCriteria myCriteria = TRANSLATOR.createAdvancedCriteria(fgRules, this.getDisplay().getFulfillmentGroupFilterBuilder().getDataSource());
                if (myCriteria != null) {
                    this.getDisplay().getFulfillmentGroupFilterBuilder().setCriteria(myCriteria);
                }
            }
            catch (IncompatibleMVELTranslationException e) {
                this.fgRuleIncompatible = true;
                GWT.log((String)"Could not translate MVEL", (Throwable)e);
                BLCMain.MASTERVIEW.getStatus().setContents(BLCMain.getMessageManager().getString("mvelTranslationProblem"));
                this.getDisplay().getRawFGTextArea().setValue(fgRules);
            }
        }
        if ((combinable = selectedRecord.getAttributeAsBoolean("combinableWithOtherOffers")) == null) {
            combinable = true;
        }
        this.getDisplay().getFgCombineRuleRadio().setValue(combinable != false ? "YES" : "NO");
        if (this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getField("discountType").getValue().equals("FIX_PRICE")) {
            this.getDisplay().getOrderCombineForm().disable();
            this.getDisplay().getFGCombineForm().disable();
            this.getDisplay().getOrderItemCombineForm().disable();
            this.getDisplay().getOrderCombineRuleRadio().setValue("NO");
            this.getDisplay().getFgCombineRuleRadio().setValue("NO");
            this.getDisplay().getOrderItemCombineRuleRadio().setValue("NO");
        }
        this.initFGRule(fgRule, selectedRecord);
    }

    public void initOrderCriteria(Record selectedRecord) {
        Boolean combinable;
        this.orderRuleIncompatible = false;
        this.getDisplay().getOrderFilterBuilder().clearCriteria();
        String orderRules = selectedRecord.getAttribute("appliesToOrderRules");
        String orderRule = orderRules == null ? "NONE" : "ORDER_RULE";
        this.getDisplay().getOrderRuleRadio().setValue(orderRule);
        if (orderRules != null) {
            try {
                AdvancedCriteria myCriteria = TRANSLATOR.createAdvancedCriteria(orderRules, this.getDisplay().getOrderFilterBuilder().getDataSource());
                if (myCriteria != null) {
                    this.getDisplay().getOrderFilterBuilder().setCriteria(myCriteria);
                }
            }
            catch (IncompatibleMVELTranslationException e) {
                this.orderRuleIncompatible = true;
                GWT.log((String)"Could not translate MVEL", (Throwable)e);
                BLCMain.MASTERVIEW.getStatus().setContents(BLCMain.getMessageManager().getString("mvelTranslationProblem"));
                this.getDisplay().getRawOrderTextArea().setValue(orderRules);
            }
        }
        if ((combinable = selectedRecord.getAttributeAsBoolean("combinableWithOtherOffers")) == null) {
            combinable = true;
        }
        this.getDisplay().getOrderCombineRuleRadio().setValue(combinable != false ? "YES" : "NO");
        this.initOrderRule(orderRule, selectedRecord);
    }

    public void initItemQualifiers(Record selectedRecord, final String type) {
        Criteria relationshipCriteria = this.offerItemCriteriaDataSource.createRelationshipCriteria(this.offerItemCriteriaDataSource.getPrimaryKeyValue(selectedRecord));
        this.offerItemCriteriaDataSource.fetchData(relationshipCriteria, new DSCallback(){

            public void execute(DSResponse response, Object rawData, DSRequest request) {
                boolean isItemQualifierCriteria = false;
                if (response.getTotalRows() > 0) {
                    for (Record record : response.getData()) {
                        if (Integer.parseInt(record.getAttribute("quantity")) <= 0) continue;
                        isItemQualifierCriteria = true;
                        break;
                    }
                }
                if (isItemQualifierCriteria) {
                    if (type.equals("ORDER_ITEM")) {
                        OfferPresenterInitializer.this.initBogoRule("YES");
                    } else {
                        OfferPresenterInitializer.this.initItemRule("ITEM_RULE");
                    }
                    OfferPresenterInitializer.this.getDisplay().getBogoRadio().setValue("YES");
                    OfferPresenterInitializer.this.getDisplay().getItemRuleRadio().setValue("ITEM_RULE");
                    OfferPresenterInitializer.this.getDisplay().removeAllItemBuilders();
                    for (Record record : response.getData()) {
                        if (Integer.parseInt(record.getAttribute("quantity")) <= 0) continue;
                        final ItemBuilderDisplay display = OfferPresenterInitializer.this.getDisplay().addItemBuilder((DataSource)OfferPresenterInitializer.this.orderItemDataSource);
                        OfferPresenterInitializer.this.presenter.bindItemBuilderEvents(display);
                        display.getItemFilterBuilder().clearCriteria();
                        display.setRecord(record);
                        display.getItemQuantity().setValue(Integer.parseInt(record.getAttribute("quantity")));
                        try {
                            display.getItemFilterBuilder().setVisible(true);
                            display.getRawItemForm().setVisible(false);
                            AdvancedCriteria myCriteria = TRANSLATOR.createAdvancedCriteria(record.getAttribute("orderItemMatchRule"), (DataSource)OfferPresenterInitializer.this.orderItemDataSource);
                            if (myCriteria != null) {
                                display.getItemFilterBuilder().setCriteria(myCriteria);
                            }
                        }
                        catch (IncompatibleMVELTranslationException e) {
                            GWT.log((String)"Could not translate MVEL", (Throwable)e);
                            BLCMain.MASTERVIEW.getStatus().setContents(BLCMain.getMessageManager().getString("mvelTranslationProblem"));
                            display.setIncompatibleMVEL(Boolean.valueOf(true));
                            display.getItemFilterBuilder().setVisible(false);
                            display.getRawItemForm().setVisible(true);
                            display.getRawItemTextArea().setValue(record.getAttribute("orderItemMatchRule"));
                        }
                        display.getRemoveButton().addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                OfferPresenterInitializer.this.getDisplay().removeItemBuilder(display);
                            }
                        });
                    }
                } else {
                    if (type.equals("ORDER_ITEM")) {
                        OfferPresenterInitializer.this.initBogoRule("NO");
                    } else {
                        OfferPresenterInitializer.this.initItemRule("NO");
                    }
                    OfferPresenterInitializer.this.getDisplay().getBogoRadio().setValue("NO");
                    OfferPresenterInitializer.this.getDisplay().getItemRuleRadio().setValue("NO");
                    OfferPresenterInitializer.this.getDisplay().removeAllItemBuilders();
                    OfferPresenterInitializer.this.presenter.bindItemBuilderEvents(OfferPresenterInitializer.this.getDisplay().addItemBuilder((DataSource)OfferPresenterInitializer.this.orderItemDataSource));
                }
            }
        });
        String offerItemQualifierRuleType = selectedRecord.getAttribute("offerItemQualifierRuleType");
        if (offerItemQualifierRuleType == null) {
            offerItemQualifierRuleType = "NONE";
        }
        if (offerItemQualifierRuleType.equals("NONE")) {
            this.getDisplay().getQualifyForAnotherPromoRadio().setValue("NO");
            this.getDisplay().getReceiveFromAnotherPromoRadio().setValue("NO");
        } else if (offerItemQualifierRuleType.equals("QUALIFIER")) {
            this.getDisplay().getQualifyForAnotherPromoRadio().setValue("YES");
            this.getDisplay().getReceiveFromAnotherPromoRadio().setValue("NO");
        } else if (offerItemQualifierRuleType.equals("TARGET")) {
            this.getDisplay().getQualifyForAnotherPromoRadio().setValue("NO");
            this.getDisplay().getReceiveFromAnotherPromoRadio().setValue("YES");
        } else if (offerItemQualifierRuleType.equals("QUALIFIER_TARGET")) {
            this.getDisplay().getQualifyForAnotherPromoRadio().setValue("YES");
            this.getDisplay().getReceiveFromAnotherPromoRadio().setValue("YES");
        }
        Boolean combinable = selectedRecord.getAttributeAsBoolean("combinableWithOtherOffers");
        if (combinable == null) {
            combinable = true;
        }
        this.getDisplay().getOrderItemCombineRuleRadio().setValue(combinable != false ? "YES" : "NO");
        if (this.getDisplay().getDynamicFormDisplay().getFormOnlyDisplay().getForm().getField("discountType").getValue().equals("FIX_PRICE")) {
            this.getDisplay().getOrderCombineForm().disable();
            this.getDisplay().getFGCombineForm().disable();
            this.getDisplay().getOrderItemCombineForm().disable();
            this.getDisplay().getOrderCombineRuleRadio().setValue("NO");
            this.getDisplay().getFgCombineRuleRadio().setValue("NO");
            this.getDisplay().getOrderItemCombineRuleRadio().setValue("NO");
        }
    }

    public void disable() {
        this.getDisplay().getItemQualificationSectionView().setVisible(false);
        this.getDisplay().getFgSectionView().setVisible(false);
        this.getDisplay().getBogoQuestionLayout().setVisible(false);
        this.getDisplay().getItemTargetSectionView().setVisible(false);
        this.getDisplay().getRequiredItemsLayout().setVisible(false);
        this.getDisplay().getOrderItemLayout().setVisible(false);
        this.getDisplay().getOrderCombineForm().setVisible(false);
        this.getDisplay().getOrderCombineLabel().setVisible(false);
        this.getDisplay().getCustomerLayout().setVisible(false);
        this.getDisplay().getOrderSectionLayout().setVisible(false);
        this.getDisplay().getCustomerSection().setVisible(false);
        this.getDisplay().getOrderSection().setVisible(false);
    }

    public void initDeliveryType(String deliveryType, Record selectedRecord) {
        if (deliveryType.equals("CODE")) {
            this.getDisplay().getCodeField().enable();
            this.getDisplay().getCodeField().setValue(selectedRecord.getAttribute("offerCode.offerCode"));
        } else {
            this.getDisplay().getCodeField().disable();
            this.getDisplay().getCodeField().setValue("");
        }
    }

    public void initCustomerRule(String customerRule, Record selectedRecord) {
        if (customerRule.equals("CUSTOMER_RULE")) {
            String customerRules = selectedRecord.getAttribute("appliesToCustomerRules");
            if (customerRules == null || customerRules.trim().equals("")) {
                this.customerRuleIncompatible = false;
            }
            if (this.customerRuleIncompatible) {
                this.getDisplay().getRawCustomerForm().setVisible(true);
                this.getDisplay().getCustomerFilterBuilder().setVisible(false);
            } else {
                this.getDisplay().getRawCustomerForm().setVisible(false);
                this.getDisplay().getCustomerFilterBuilder().setVisible(true);
            }
        } else {
            this.getDisplay().getRawCustomerForm().setVisible(false);
            this.getDisplay().getCustomerFilterBuilder().setVisible(false);
        }
    }

    public void initOrderRule(String orderRule, Record selectedRecord) {
        if (orderRule.equals("ORDER_RULE")) {
            String orderRules = selectedRecord.getAttribute("appliesToOrderRules");
            if (orderRules == null || orderRules.trim().equals("")) {
                this.orderRuleIncompatible = false;
            }
            if (this.orderRuleIncompatible) {
                this.getDisplay().getRawOrderForm().setVisible(true);
                this.getDisplay().getOrderFilterBuilder().setVisible(false);
            } else {
                this.getDisplay().getRawOrderForm().setVisible(false);
                this.getDisplay().getOrderFilterBuilder().setVisible(true);
            }
        } else {
            this.getDisplay().getRawOrderForm().setVisible(false);
            this.getDisplay().getOrderFilterBuilder().setVisible(false);
        }
    }

    public void initFGRule(String fgRule, Record selectedRecord) {
        if (fgRule.equals("FG_RULE")) {
            String fgRules = selectedRecord.getAttribute("appliesToFulfillmentGroupRules");
            if (fgRules == null || fgRules.trim().equals("")) {
                this.fgRuleIncompatible = false;
            }
            if (this.fgRuleIncompatible) {
                this.getDisplay().getRawFGForm().setVisible(true);
                this.getDisplay().getFulfillmentGroupFilterBuilder().setVisible(false);
            } else {
                this.getDisplay().getRawFGForm().setVisible(false);
                this.getDisplay().getFulfillmentGroupFilterBuilder().setVisible(true);
            }
        } else {
            this.getDisplay().getRawFGForm().setVisible(false);
            this.getDisplay().getFulfillmentGroupFilterBuilder().setVisible(false);
        }
    }

    public void initItemRule(String itemRule) {
        if (itemRule.equals("ITEM_RULE")) {
            this.getDisplay().getNewItemBuilderLayout().setVisible(true);
        } else {
            this.getDisplay().getNewItemBuilderLayout().setVisible(false);
        }
    }

    public void initBogoRule(String bogoRule) {
        if (bogoRule.equals("YES")) {
            this.getDisplay().getRequiredItemsLayout().setVisible(true);
            this.getDisplay().getNewItemBuilderLayout().setVisible(true);
        } else {
            this.getDisplay().getRequiredItemsLayout().setVisible(false);
            this.getDisplay().getNewItemBuilderLayout().setVisible(false);
        }
    }
}

