/*
 * #%L
 * BroadleafCommerce Open Admin Platform
 * %%
 * Copyright (C) 2009 - 2014 Broadleaf Commerce
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.broadleafcommerce.browsertest.page

import geb.Page

/**
 * The list of entity types that can show up when hitting the 'Add' button on a top-level entity. For instance, when you
 * add a new Product you can select a Product or a ProductBundle to add
 * 
 * @author Phillip Verheyden (phillipuniverse)
 */
class EntityTypeSelection extends Page {
    
    static at = { waitFor { typeList.displayed } }
    
    static content = {
        typeList { $('.modal-body .entity-type-selection li a') }
    }

}
