/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3.site.config;

import java.util.LinkedHashSet;
import java.util.Set;
import org.broadleafcommerce.common.logging.LifeCycleEvent;
import org.broadleafcommerce.common.logging.ModuleLifecycleLoggingBean;
import org.broadleafcommerce.presentation.thymeleaf3.BroadleafThymeleaf3MessageResolver;
import org.broadleafcommerce.presentation.thymeleaf3.BroadleafThymeleaf3TemplateEngine;
import org.broadleafcommerce.presentation.thymeleaf3.BroadleafThymeleafViewResolver;
import org.broadleafcommerce.presentation.thymeleaf3.cache.BroadleafThymeleaf3CacheInvalidationContext;
import org.broadleafcommerce.presentation.thymeleaf3.cache.BroadleafThymeleaf3CacheManager;
import org.broadleafcommerce.presentation.thymeleaf3.config.AbstractThymeleaf3DialectConfig;
import org.broadleafcommerce.presentation.thymeleaf3.config.AbstractThymeleaf3EngineConfig;
import org.broadleafcommerce.presentation.thymeleaf3.config.Thymeleaf3CommonConfig;
import org.broadleafcommerce.presentation.thymeleaf3.site.config.Thymeleaf3SiteTemplateConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.spring5.ISpringTemplateEngine;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
public class Thymeleaf3SiteConfig
extends Thymeleaf3CommonConfig {
    @Bean
    public ModuleLifecycleLoggingBean blThymeleaf3Lifecycle() {
        return new ModuleLifecycleLoggingBean("Broadleaf Thymeleaf 3 Support", LifeCycleEvent.LOADING);
    }

    @Bean
    public IMessageResolver blMessageResolver() {
        BroadleafThymeleaf3MessageResolver resolver = new BroadleafThymeleaf3MessageResolver();
        resolver.setOrder(100);
        return resolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={ICacheManager.class})
    public BroadleafThymeleaf3CacheManager blICacheManager() {
        return new BroadleafThymeleaf3CacheManager();
    }

    @Configuration
    static class Thymeleaf3CacheInvalidationConfig {
        protected ITemplateEngine templateEngine;

        public Thymeleaf3CacheInvalidationConfig(ITemplateEngine templateEngine) {
            this.templateEngine = templateEngine;
        }

        @Bean
        public BroadleafThymeleaf3CacheInvalidationContext blTemplateCacheInvalidationContext() {
            BroadleafThymeleaf3CacheInvalidationContext context = new BroadleafThymeleaf3CacheInvalidationContext();
            context.setTemplateEngine(this.templateEngine);
            return context;
        }
    }

    @Configuration
    static class Thymeleaf3SiteViewConfig {
        protected ISpringTemplateEngine templateEngine;
        protected Environment environment;

        public Thymeleaf3SiteViewConfig(ISpringTemplateEngine templateEngine, Environment environment) {
            this.templateEngine = templateEngine;
            this.environment = environment;
        }

        @Bean(name={"blThymeleafViewResolver", "thymeleafViewResolver"})
        public BroadleafThymeleafViewResolver blThymeleafViewResolver() {
            BroadleafThymeleafViewResolver view = new BroadleafThymeleafViewResolver();
            view.setTemplateEngine(this.templateEngine);
            view.setOrder(1);
            view.setCache((Boolean)this.environment.getProperty("thymeleaf.view.resolver.cache", Boolean.class, (Object)true));
            view.setCharacterEncoding("UTF-8");
            return view;
        }
    }

    @Configuration
    static class Thymeleaf3SiteEngineConfig
    extends AbstractThymeleaf3EngineConfig {
        protected Set<IMessageResolver> messageResolvers;
        protected ICacheManager cacheManager;

        public Thymeleaf3SiteEngineConfig(Set<IMessageResolver> messageResolvers, ICacheManager cacheManager) {
            this.messageResolvers = messageResolvers;
            this.cacheManager = cacheManager;
        }

        @Bean
        @Primary
        public BroadleafThymeleaf3TemplateEngine blWebTemplateEngine() {
            BroadleafThymeleaf3TemplateEngine engine = new BroadleafThymeleaf3TemplateEngine();
            engine.setMessageResolvers(this.messageResolvers);
            LinkedHashSet<ITemplateResolver> allResolvers = new LinkedHashSet<ITemplateResolver>();
            allResolvers.addAll(this.iTemplateResolvers);
            allResolvers.addAll(this.blWebTemplateResolvers());
            engine.setTemplateResolvers(allResolvers);
            engine.setCacheManager(this.cacheManager);
            engine.setDialects(this.dialects);
            return engine;
        }

        @Configuration
        protected static class Thymeleaf3TemplateResolverConfig
        extends Thymeleaf3SiteTemplateConfig {
            protected Thymeleaf3TemplateResolverConfig() {
            }
        }
    }

    @Configuration
    static class Thymeleaf3SiteDialectConfig
    extends AbstractThymeleaf3DialectConfig {
        Thymeleaf3SiteDialectConfig() {
        }

        @Bean
        public Set<IDialect> blWebDialects() {
            LinkedHashSet<IDialect> dialects = new LinkedHashSet<IDialect>();
            dialects.add((IDialect)this.thymeleafSpringStandardDialect());
            dialects.add((IDialect)this.blDialect());
            return dialects;
        }
    }
}

