/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3.resolver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.FilenameUtils;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.common.web.resource.BroadleafContextUtil;
import org.broadleafcommerce.core.web.resolver.DatabaseResourceResolverExtensionHandler;
import org.broadleafcommerce.core.web.resolver.DatabaseResourceResolverExtensionManager;
import org.thymeleaf.templateresource.ITemplateResource;

public class BroadleafThymeleaf3DatabaseResourceResolver
implements ITemplateResource {
    protected BroadleafContextUtil blcContextUtil;
    protected DatabaseResourceResolverExtensionManager extensionManager;
    protected String path;

    public BroadleafThymeleaf3DatabaseResourceResolver(DatabaseResourceResolverExtensionManager extensionManager, BroadleafContextUtil blcContextUtil, String path) {
        this.extensionManager = extensionManager;
        this.blcContextUtil = blcContextUtil;
        this.path = path;
    }

    public String getDescription() {
        return "BL_DATABASE";
    }

    public String getBaseName() {
        return FilenameUtils.getBaseName((String)this.path);
    }

    public boolean exists() {
        return this.resolveResource() != null;
    }

    public Reader reader() throws IOException {
        InputStream resourceStream = this.resolveResource();
        return resourceStream == null ? null : new BufferedReader(new InputStreamReader(resourceStream));
    }

    public ITemplateResource relative(String relativeLocation) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream resolveResource() {
        try {
            this.blcContextUtil.establishThinRequestContext();
            ExtensionResultHolder erh = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((DatabaseResourceResolverExtensionHandler)this.extensionManager.getProxy()).resolveResource(erh, this.path);
            if (result == ExtensionResultStatusType.HANDLED) {
                InputStream inputStream = (InputStream)erh.getContextMap().get("IS_KEY");
                return inputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            BroadleafRequestContext brc = BroadleafRequestContext.getBroadleafRequestContext();
            brc.setTheme(null);
        }
    }
}

