/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3.processor;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Resource;
import javax.cache.Cache;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.config.service.SystemPropertiesService;
import org.broadleafcommerce.common.extensibility.cache.JCacheUtil;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.presentation.cache.service.TemplateCacheKeyResolverService;
import org.broadleafcommerce.presentation.model.BroadleafTemplateContext;
import org.broadleafcommerce.presentation.thymeleaf3.model.BroadleafThymeleaf3Context;
import org.springframework.web.context.request.WebRequest;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.TemplateModel;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.AbstractAttributeModelProcessor;
import org.thymeleaf.processor.element.IElementModelStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public class BroadleafThymeleaf3CacheProcessor
extends AbstractAttributeModelProcessor {
    public static final String ATTR_NAME = "cache";
    private static final Log LOG = LogFactory.getLog(BroadleafThymeleaf3CacheProcessor.class);
    protected Cache cache;
    @Resource(name="blSystemPropertiesService")
    protected SystemPropertiesService systemPropertiesService;
    @Resource(name="blTemplateCacheKeyResolver")
    protected TemplateCacheKeyResolverService cacheKeyResolver;
    @Resource(name="blJCacheUtil")
    protected JCacheUtil jcacheUtil;

    public BroadleafThymeleaf3CacheProcessor() {
        super(TemplateMode.HTML, "blc".toString(), null, false, ATTR_NAME, true, Integer.MIN_VALUE, true);
    }

    protected void doProcess(ITemplateContext iContext, IModel model, AttributeName attributeName, String attributeValue, IElementModelStructureHandler structureHandler) {
        IProcessableElementTag rootTag = (IProcessableElementTag)model.get(0);
        String tagName = rootTag.getElementCompleteName();
        Map tagAttributes = rootTag.getAttributeMap();
        String documentName = iContext.getTemplateData().getTemplate();
        Integer lineNumber = rootTag.getLine();
        BroadleafThymeleaf3Context context = new BroadleafThymeleaf3Context(iContext, structureHandler);
        if (this.shouldCache(attributeValue, context)) {
            String cacheKey = this.cacheKeyResolver.resolveCacheKey(tagName, tagAttributes, documentName, lineNumber, (BroadleafTemplateContext)context);
            Object cacheElement = this.checkCacheForElement(tagAttributes, cacheKey);
            if (cacheElement != null) {
                this.replaceTagWithCache(cacheElement.toString(), model, iContext);
            } else {
                tagAttributes.remove("blc:cache");
                this.addToCache(cacheKey, model, iContext, tagAttributes);
            }
        }
    }

    protected boolean shouldCache(String attributeValue, BroadleafTemplateContext context) {
        if (this.isCachingEnabled()) {
            String cacheAttrValue = attributeValue;
            if (StringUtils.isEmpty((String)attributeValue)) {
                return false;
            }
            cacheAttrValue = cacheAttrValue.toLowerCase();
            if (!this.isCachingEnabled() || "false".equals(cacheAttrValue)) {
                return false;
            }
            if ("true".equals(cacheAttrValue)) {
                return true;
            }
            Object o = context.parseExpression(cacheAttrValue);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof String) {
                cacheAttrValue = (String)o;
                cacheAttrValue = cacheAttrValue.toLowerCase();
                return "true".equals(cacheAttrValue);
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Template caching disabled - not retrieving template from cache");
        }
        return false;
    }

    protected Object checkCacheForElement(Map<String, String> tagAttributes, String cacheKey) {
        if (!StringUtils.isEmpty((String)cacheKey)) {
            Object cacheElement = this.getCache().get((Object)cacheKey);
            if (cacheElement != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Template Cache Hit with cacheKey " + cacheKey + " found in cache."));
                }
                return cacheElement;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Template Cache Miss with cacheKey " + cacheKey + " not found in cache."));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Template not cached due to empty cacheKey");
        }
        return null;
    }

    protected void replaceTagWithCache(String cachedObject, IModel model, ITemplateContext context) {
        model = context.getConfiguration().getTemplateManager().parseString(context.getTemplateData(), cachedObject, model.get(0).getLine(), model.get(0).getCol(), this.getTemplateMode(), false);
    }

    protected void addToCache(String cacheKey, IModel model, ITemplateContext context, Map<String, String> tagAttributes) {
        IProcessableElementTag firstEvent = (IProcessableElementTag)model.get(0);
        IModelFactory modelFactory = context.getModelFactory();
        Map originalAttributes = firstEvent.getAttributeMap();
        IProcessableElementTag newFirstEvent = firstEvent;
        for (String attrName : originalAttributes.keySet()) {
            if (tagAttributes.containsKey(attrName)) continue;
            newFirstEvent = modelFactory.removeAttribute(newFirstEvent, attrName);
        }
        if (newFirstEvent != firstEvent) {
            model.replace(0, (ITemplateEvent)newFirstEvent);
        }
        StringWriter modelWriter = new StringWriter();
        try {
            model.write((Writer)modelWriter);
        }
        catch (IOException e) {
            throw new TemplateProcessingException("Error during creation of output", (Throwable)e);
        }
        TemplateModel cacheModel = context.getConfiguration().getTemplateManager().parseString(context.getTemplateData(), modelWriter.toString(), firstEvent.getLine(), firstEvent.getCol(), this.getTemplateMode(), false);
        StringWriter templateWriter = new StringWriter();
        context.getConfiguration().getTemplateManager().process(cacheModel, context, (Writer)templateWriter);
        if (StringUtils.isNotBlank((String)cacheKey) && templateWriter != null && StringUtils.isNotBlank((String)templateWriter.toString())) {
            this.getCache().put((Object)cacheKey, (Object)templateWriter.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache() {
        if (this.cache == null) {
            BroadleafThymeleaf3CacheProcessor broadleafThymeleaf3CacheProcessor = this;
            synchronized (broadleafThymeleaf3CacheProcessor) {
                if (this.cache == null) {
                    this.cache = this.jcacheUtil.getCache("blTemplateElements");
                }
            }
        }
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public boolean isCachingEnabled() {
        WebRequest request;
        String disableCachingParam;
        BroadleafRequestContext brc;
        boolean enabled;
        boolean bl = enabled = !this.systemPropertiesService.resolveBooleanSystemProperty("disableThymeleafTemplateCaching");
        if (enabled && (brc = BroadleafRequestContext.getBroadleafRequestContext()) != null && brc.getWebRequest() != null && "true".equals(disableCachingParam = (request = brc.getWebRequest()).getParameter("disableThymeleafTemplateCaching"))) {
            return false;
        }
        return enabled;
    }
}

