/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3.expression;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.broadleafcommerce.common.web.expression.BroadleafVariableExpression;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.expression.IExpressionObjectFactory;

public class BroadleafVariableExpressionObjectFactory
implements IExpressionObjectFactory {
    @Resource
    protected List<BroadleafVariableExpression> expressions = new ArrayList<BroadleafVariableExpression>();

    public Set<String> getAllExpressionObjectNames() {
        HashSet<String> expressionObjectNames = new HashSet<String>();
        for (BroadleafVariableExpression expression : this.expressions) {
            expressionObjectNames.add(expression.getName());
        }
        return expressionObjectNames;
    }

    public Object buildObject(IExpressionContext context, String expressionObjectName) {
        if (context instanceof IWebContext || context instanceof IEngineContext) {
            for (BroadleafVariableExpression expression : this.expressions) {
                if (!expressionObjectName.equals(expression.getName())) continue;
                return expression;
            }
        }
        return null;
    }

    public boolean isCacheable(String expressionObjectName) {
        return true;
    }
}

