/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3.email;

import java.util.Map;
import org.broadleafcommerce.common.email.service.info.EmailInfo;
import org.broadleafcommerce.common.email.service.message.MessageCreator;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;
import org.springframework.mail.javamail.JavaMailSender;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.expression.ThymeleafEvaluationContext;

public class BroadleafThymeleaf3MessageCreator
extends MessageCreator
implements ApplicationContextAware {
    protected TemplateEngine templateEngine;
    protected ApplicationContext applicationContext;

    public BroadleafThymeleaf3MessageCreator(TemplateEngine templateEngine, JavaMailSender mailSender) {
        super(mailSender);
        this.templateEngine = templateEngine;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String buildMessageBody(EmailInfo info, Map<String, Object> props) {
        BroadleafRequestContext blcContext = BroadleafRequestContext.getBroadleafRequestContext();
        Context thymeleafContext = new Context();
        if (blcContext != null && blcContext.getJavaLocale() != null) {
            thymeleafContext.setLocale(blcContext.getJavaLocale());
        }
        if (props != null) {
            if (props.get("thymeleaf::EvaluationContext") == null) {
                props.put("thymeleaf::EvaluationContext", new ThymeleafEvaluationContext(this.applicationContext, null));
            }
            for (String key : props.keySet()) {
                thymeleafContext.setVariable(key, props.get(key));
            }
        }
        return this.templateEngine.process(info.getEmailTemplate(), (IContext)thymeleafContext);
    }
}

