/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3.dialect;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.presentation.dialect.BroadleafVariableModifierProcessor;
import org.broadleafcommerce.presentation.model.BroadleafTemplateContext;
import org.broadleafcommerce.presentation.thymeleaf3.model.BroadleafThymeleaf3Context;
import org.springframework.web.context.request.WebRequest;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractElementTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public class DelegatingThymeleaf3VariableModifierProcessor
extends AbstractElementTagProcessor {
    private static final Log LOG = LogFactory.getLog(DelegatingThymeleaf3VariableModifierProcessor.class);
    protected BroadleafVariableModifierProcessor processor;

    public DelegatingThymeleaf3VariableModifierProcessor(String elementName, BroadleafVariableModifierProcessor processor, int precedence) {
        super(TemplateMode.HTML, processor.getPrefix(), elementName, true, null, false, precedence);
        this.processor = processor;
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, IElementTagStructureHandler structureHandler) {
        Map attributes = tag.getAttributeMap();
        BroadleafThymeleaf3Context blcContext = new BroadleafThymeleaf3Context(context, structureHandler);
        Map newModelVariables = this.processor.populateModelVariables(tag.getElementCompleteName(), attributes, (BroadleafTemplateContext)blcContext);
        if (MapUtils.isNotEmpty((Map)newModelVariables)) {
            for (Map.Entry entry : newModelVariables.entrySet()) {
                this.addToModel(structureHandler, context, (String)entry.getKey(), entry.getValue());
            }
        }
        structureHandler.removeTags();
    }

    private void addToModel(IElementTagStructureHandler structureHandler, ITemplateContext context, String key, Object value) {
        if (this.processor.getCollectionModelVariableNamesToAddTo() != null && this.processor.getCollectionModelVariableNamesToAddTo().contains(key)) {
            if (this.processor.useGlobalScope()) {
                this.addItemToExistingSet(key, value);
            } else {
                this.addToLocalExistingSet(context, structureHandler, key, value);
            }
        } else if (this.processor.useGlobalScope()) {
            this.addToGlobalModel(key, value);
        } else {
            this.addToLocalModel(structureHandler, key, value);
        }
    }

    private void addToLocalModel(IElementTagStructureHandler structureHandler, String key, Object value) {
        structureHandler.setLocalVariable(key, value);
    }

    private <T> void addToLocalExistingSet(ITemplateContext context, IElementTagStructureHandler structureHandler, String key, Object value) {
        Set<Object> items = new HashSet();
        if (context.containsVariable(key)) {
            items = (Set)context.getVariable(key);
        }
        if (Collection.class.isAssignableFrom(value.getClass())) {
            items.addAll((Collection)value);
        } else {
            items.add(value);
        }
        structureHandler.setLocalVariable(key, items);
    }

    @Deprecated
    private void addToGlobalModel(String key, Object value) {
        WebRequest request = BroadleafRequestContext.getBroadleafRequestContext().getWebRequest();
        if (request != null) {
            request.setAttribute(key, value, 0);
        } else {
            LOG.warn((Object)("Cannot add " + key + " to a global model since this is not inside of a web request"));
        }
    }

    @Deprecated
    protected <T> void addItemToExistingSet(String key, Object value) {
        WebRequest request = BroadleafRequestContext.getBroadleafRequestContext().getWebRequest();
        HashSet<Object> items = (HashSet<Object>)request.getAttribute(key, 0);
        if (items == null) {
            items = new HashSet<Object>();
            this.addToGlobalModel(key, items);
        }
        if (Collection.class.isAssignableFrom(value.getClass())) {
            items.addAll((Collection)value);
        } else {
            items.add(value);
        }
    }
}

