/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.web.resource.BroadleafContextUtil;
import org.broadleafcommerce.core.web.resolver.DatabaseResourceResolverExtensionManager;
import org.broadleafcommerce.presentation.dialect.BroadleafAttributeModifierProcessor;
import org.broadleafcommerce.presentation.dialect.BroadleafModelModifierProcessor;
import org.broadleafcommerce.presentation.dialect.BroadleafProcessor;
import org.broadleafcommerce.presentation.dialect.BroadleafTagReplacementProcessor;
import org.broadleafcommerce.presentation.dialect.BroadleafTagTextModifierProcessor;
import org.broadleafcommerce.presentation.dialect.BroadleafVariableModifierAttrProcessor;
import org.broadleafcommerce.presentation.dialect.BroadleafVariableModifierProcessor;
import org.broadleafcommerce.presentation.resolver.BroadleafTemplateMode;
import org.broadleafcommerce.presentation.resolver.BroadleafTemplateResolver;
import org.broadleafcommerce.presentation.resolver.BroadleafTemplateResolverType;
import org.broadleafcommerce.presentation.thymeleaf3.BroadleafThymeleaf3ThemeAwareTemplateResolver;
import org.broadleafcommerce.presentation.thymeleaf3.dialect.DelegatingThymeleaf3AttributeModelVariableModifierProcessor;
import org.broadleafcommerce.presentation.thymeleaf3.dialect.DelegatingThymeleaf3AttributeModifierProcessor;
import org.broadleafcommerce.presentation.thymeleaf3.dialect.DelegatingThymeleaf3ModelModifierProcessor;
import org.broadleafcommerce.presentation.thymeleaf3.dialect.DelegatingThymeleaf3TagReplacementProcessor;
import org.broadleafcommerce.presentation.thymeleaf3.dialect.DelegatingThymeleaf3TagTextModifierProcessor;
import org.broadleafcommerce.presentation.thymeleaf3.dialect.DelegatingThymeleaf3VariableModifierProcessor;
import org.broadleafcommerce.presentation.thymeleaf3.resolver.BroadleafThymeleaf3DatabaseTemplateResolver;
import org.broadleafcommerce.presentation.thymeleaf3.resolver.BroadleafThymeleaf3StringTemplateResolver;
import org.broadleafcommerce.presentation.thymeleaf3.resolver.DelegatingThymeleaf3TemplateResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Component(value="blThymeleaf3ConfigUtils")
public class Thymeleaf3ConfigUtils {
    protected static final Log LOG = LogFactory.getLog(Thymeleaf3ConfigUtils.class);
    @Resource
    protected ApplicationContext applicationContext;

    public Set<IProcessor> getDialectProcessors(Collection<BroadleafProcessor> blcProcessors) {
        HashSet<IProcessor> iProcessors = new HashSet<IProcessor>();
        for (BroadleafProcessor proc : blcProcessors) {
            if (BroadleafVariableModifierProcessor.class.isAssignableFrom(proc.getClass())) {
                iProcessors.add((IProcessor)this.createDelegatingModelVariableModifierProcessor((BroadleafVariableModifierProcessor)proc));
                continue;
            }
            if (BroadleafTagTextModifierProcessor.class.isAssignableFrom(proc.getClass())) {
                iProcessors.add((IProcessor)this.createDelegatingTagTextModifierProcessor((BroadleafTagTextModifierProcessor)proc));
                continue;
            }
            if (BroadleafTagReplacementProcessor.class.isAssignableFrom(proc.getClass())) {
                iProcessors.add((IProcessor)this.createDelegatingTagReplacementProcessor((BroadleafTagReplacementProcessor)proc));
                continue;
            }
            if (BroadleafModelModifierProcessor.class.isAssignableFrom(proc.getClass())) {
                iProcessors.add((IProcessor)this.createDelegatingFormReplacementProcessor((BroadleafModelModifierProcessor)proc));
                continue;
            }
            if (BroadleafAttributeModifierProcessor.class.isAssignableFrom(proc.getClass())) {
                iProcessors.add((IProcessor)this.createDelegatingAttributeModifierProcessor((BroadleafAttributeModifierProcessor)proc));
                continue;
            }
            if (BroadleafVariableModifierAttrProcessor.class.isAssignableFrom(proc.getClass())) {
                iProcessors.add((IProcessor)this.createDelegatingAttributeModelVariableModifierProcessor((BroadleafVariableModifierAttrProcessor)proc));
                continue;
            }
            LOG.warn((Object)("No known delegating processor to instantiate processor " + proc));
        }
        return iProcessors;
    }

    public Set<ITemplateResolver> getWebResolvers(Collection<BroadleafTemplateResolver> resolvers) {
        HashSet<ITemplateResolver> webResolvers = new HashSet<ITemplateResolver>();
        for (BroadleafTemplateResolver resolver : resolvers) {
            ITemplateResolver iResolver;
            if (resolver.isEmailResolver().booleanValue() || (iResolver = this.createCorrectTemplateResolver(resolver)) == null) continue;
            webResolvers.add(iResolver);
        }
        return webResolvers;
    }

    public Set<ITemplateResolver> getEmailResolvers(Collection<BroadleafTemplateResolver> resolvers) {
        HashSet<ITemplateResolver> emailResovlers = new HashSet<ITemplateResolver>();
        for (BroadleafTemplateResolver resolver : resolvers) {
            ITemplateResolver iResolver;
            if (!resolver.isEmailResolver().booleanValue() || (iResolver = this.createCorrectTemplateResolver(resolver)) == null) continue;
            emailResovlers.add(iResolver);
        }
        return emailResovlers;
    }

    protected DelegatingThymeleaf3VariableModifierProcessor createDelegatingModelVariableModifierProcessor(BroadleafVariableModifierProcessor processor) {
        return new DelegatingThymeleaf3VariableModifierProcessor(processor.getName(), processor, processor.getPrecedence());
    }

    protected DelegatingThymeleaf3TagTextModifierProcessor createDelegatingTagTextModifierProcessor(BroadleafTagTextModifierProcessor processor) {
        return new DelegatingThymeleaf3TagTextModifierProcessor(processor.getName(), processor, processor.getPrecedence());
    }

    protected DelegatingThymeleaf3TagReplacementProcessor createDelegatingTagReplacementProcessor(BroadleafTagReplacementProcessor processor) {
        return new DelegatingThymeleaf3TagReplacementProcessor(processor.getName(), processor, processor.getPrecedence());
    }

    protected DelegatingThymeleaf3ModelModifierProcessor createDelegatingFormReplacementProcessor(BroadleafModelModifierProcessor processor) {
        return new DelegatingThymeleaf3ModelModifierProcessor(processor.getName(), processor, processor.getPrecedence());
    }

    protected DelegatingThymeleaf3AttributeModifierProcessor createDelegatingAttributeModifierProcessor(BroadleafAttributeModifierProcessor processor) {
        return new DelegatingThymeleaf3AttributeModifierProcessor(processor.getName(), processor, processor.getPrecedence());
    }

    protected DelegatingThymeleaf3AttributeModelVariableModifierProcessor createDelegatingAttributeModelVariableModifierProcessor(BroadleafVariableModifierAttrProcessor processor) {
        return new DelegatingThymeleaf3AttributeModelVariableModifierProcessor(processor.getName(), processor, processor.getPrecedence());
    }

    protected ITemplateResolver createCorrectTemplateResolver(BroadleafTemplateResolver resolver) {
        if (BroadleafTemplateResolverType.CLASSPATH.equals((Object)resolver.getResolverType())) {
            return this.createClassLoaderTemplateResolver(resolver);
        }
        if (BroadleafTemplateResolverType.DATABASE.equals((Object)resolver.getResolverType())) {
            return this.createDatabaseTemplateResolver(resolver);
        }
        if (BroadleafTemplateResolverType.THEME_AWARE.equals((Object)resolver.getResolverType())) {
            return this.createServletTemplateResolver(resolver);
        }
        if (BroadleafTemplateResolverType.CUSTOM.equals((Object)resolver.getResolverType())) {
            return this.createDelegatingThymeleaf3TemplateResolver(resolver);
        }
        if (BroadleafTemplateResolverType.STRING.equals((Object)resolver.getResolverType())) {
            return this.createStringTemplateResolver(resolver);
        }
        LOG.warn((Object)("No known Thmeleaf 3 template resolver can be mapped to BroadleafThymeleafTemplateResolverType " + resolver.getResolverType()));
        return null;
    }

    protected ClassLoaderTemplateResolver createClassLoaderTemplateResolver(BroadleafTemplateResolver resolver) {
        ClassLoaderTemplateResolver classpathResolver = new ClassLoaderTemplateResolver();
        this.commonTemplateResolver(resolver, (AbstractConfigurableTemplateResolver)classpathResolver);
        classpathResolver.setCheckExistence(true);
        classpathResolver.setPrefix(resolver.getPrefix() + resolver.getTemplateFolder());
        return classpathResolver;
    }

    protected BroadleafThymeleaf3DatabaseTemplateResolver createDatabaseTemplateResolver(BroadleafTemplateResolver resolver) {
        BroadleafThymeleaf3DatabaseTemplateResolver databaseResolver = new BroadleafThymeleaf3DatabaseTemplateResolver();
        this.commonTemplateResolver(resolver, databaseResolver);
        databaseResolver.setPrefix(resolver.getPrefix() + resolver.getTemplateFolder());
        databaseResolver.setResourceResolverExtensionManager((DatabaseResourceResolverExtensionManager)this.applicationContext.getBean("blDatabaseResourceResolverExtensionManager", DatabaseResourceResolverExtensionManager.class));
        databaseResolver.setBroadleafContextUtil((BroadleafContextUtil)this.applicationContext.getBean("blBroadleafContextUtil", BroadleafContextUtil.class));
        return databaseResolver;
    }

    protected BroadleafThymeleaf3ThemeAwareTemplateResolver createServletTemplateResolver(BroadleafTemplateResolver resolver) {
        BroadleafThymeleaf3ThemeAwareTemplateResolver servletResolver = (BroadleafThymeleaf3ThemeAwareTemplateResolver)((Object)this.applicationContext.getAutowireCapableBeanFactory().createBean(BroadleafThymeleaf3ThemeAwareTemplateResolver.class));
        this.commonTemplateResolver(resolver, (AbstractConfigurableTemplateResolver)servletResolver);
        servletResolver.setCheckExistence(true);
        servletResolver.setPrefix(resolver.getPrefix());
        servletResolver.setTemplateFolder(resolver.getTemplateFolder());
        return servletResolver;
    }

    protected DelegatingThymeleaf3TemplateResolver createDelegatingThymeleaf3TemplateResolver(BroadleafTemplateResolver resolver) {
        DelegatingThymeleaf3TemplateResolver delegatingResolver = (DelegatingThymeleaf3TemplateResolver)((Object)this.applicationContext.getAutowireCapableBeanFactory().createBean(DelegatingThymeleaf3TemplateResolver.class));
        this.commonTemplateResolver(resolver, (AbstractConfigurableTemplateResolver)delegatingResolver);
        delegatingResolver.setTemplateResolver(resolver);
        delegatingResolver.setCheckExistence(true);
        delegatingResolver.setPrefix(resolver.getPrefix());
        return delegatingResolver;
    }

    protected BroadleafThymeleaf3StringTemplateResolver createStringTemplateResolver(BroadleafTemplateResolver resolver) {
        BroadleafThymeleaf3StringTemplateResolver stringResolver = new BroadleafThymeleaf3StringTemplateResolver();
        this.commonTemplateResolver(resolver, stringResolver);
        stringResolver.setPrefix(resolver.getPrefix() + resolver.getTemplateFolder());
        return stringResolver;
    }

    protected BroadleafTemplateMode translateTemplateModeForThymeleaf3(BroadleafTemplateMode mode) {
        if (BroadleafTemplateMode.HTML5.equals((Object)mode) || BroadleafTemplateMode.LEGACYHTML5.equals((Object)mode)) {
            return BroadleafTemplateMode.HTML;
        }
        return mode;
    }

    protected void commonTemplateResolver(BroadleafTemplateResolver blResolver, AbstractConfigurableTemplateResolver tlResolver) {
        tlResolver.setCacheable(blResolver.isCacheable().booleanValue());
        tlResolver.setCacheTTLMs(blResolver.getCacheTTLMs());
        tlResolver.setCharacterEncoding(blResolver.getCharacterEncoding());
        tlResolver.setTemplateMode(this.translateTemplateModeForThymeleaf3(blResolver.getTemplateMode()).toString());
        tlResolver.setOrder(blResolver.getOrder());
        tlResolver.setSuffix(blResolver.getSuffix());
    }
}

