/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3.config;

import java.util.LinkedHashSet;
import java.util.Set;
import org.broadleafcommerce.presentation.resolver.BroadleafTemplateResolver;
import org.broadleafcommerce.presentation.thymeleaf3.config.Thymeleaf3CommonTemplateConfig;
import org.broadleafcommerce.presentation.thymeleaf3.config.Thymeleaf3ConfigUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.templateresolver.ITemplateResolver;

public abstract class AbstractThymeleaf3EngineConfig {
    @Autowired(required=false)
    protected Set<ITemplateResolver> iTemplateResolvers = new LinkedHashSet<ITemplateResolver>();
    @Autowired(required=false)
    protected Set<BroadleafTemplateResolver> blcTemplateResolvers = new LinkedHashSet<BroadleafTemplateResolver>();
    @Autowired
    protected Set<IDialect> dialects;
    @Autowired
    protected Thymeleaf3ConfigUtils configUtil;

    @Bean
    public SpringTemplateEngine blEmailTemplateEngine() {
        SpringTemplateEngine engine = new SpringTemplateEngine();
        LinkedHashSet<ITemplateResolver> allResolvers = new LinkedHashSet<ITemplateResolver>();
        allResolvers.addAll(this.iTemplateResolvers);
        allResolvers.addAll(this.blEmailTemplateResolvers());
        engine.setTemplateResolvers(allResolvers);
        engine.setDialects(this.dialects);
        return engine;
    }

    @Bean
    public Set<ITemplateResolver> blEmailTemplateResolvers() {
        return this.configUtil.getEmailResolvers(this.blcTemplateResolvers);
    }

    @Bean
    @Primary
    public Set<ITemplateResolver> blWebTemplateResolvers() {
        return this.configUtil.getWebResolvers(this.blcTemplateResolvers);
    }

    @Configuration
    protected static class Thymeleaf3CommonTemplateResolverConfig
    extends Thymeleaf3CommonTemplateConfig {
        protected Thymeleaf3CommonTemplateResolverConfig() {
        }
    }
}

