/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.presentation.thymeleaf3.config;

import com.github.mxab.thymeleaf.extras.dataattribute.dialect.DataAttributeDialect;
import java.util.LinkedHashSet;
import java.util.Set;
import nz.net.ultraq.thymeleaf.layoutdialect.LayoutDialect;
import org.broadleafcommerce.presentation.dialect.BroadleafProcessor;
import org.broadleafcommerce.presentation.thymeleaf3.config.Thymeleaf3ConfigUtils;
import org.broadleafcommerce.presentation.thymeleaf3.dialect.BroadleafThymeleaf3Dialect;
import org.broadleafcommerce.presentation.thymeleaf3.processor.ArbitraryHtmlInsertionProcessor;
import org.broadleafcommerce.presentation.thymeleaf3.processor.BroadleafThymeleaf3CacheProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.system.JavaVersion;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;
import org.thymeleaf.extras.springsecurity5.dialect.SpringSecurityDialect;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.spring5.dialect.SpringStandardDialect;

public abstract class AbstractThymeleaf3DialectConfig {
    @Autowired(required=false)
    protected Set<IProcessor> iProcessors = new LinkedHashSet<IProcessor>();
    @Autowired(required=false)
    protected Set<BroadleafProcessor> blcProcessors = new LinkedHashSet<BroadleafProcessor>();
    @Autowired
    protected Thymeleaf3ConfigUtils configUtil;

    @Bean
    public SpringStandardDialect thymeleafSpringStandardDialect() {
        return new SpringStandardDialect();
    }

    @Bean
    public Set<IDialect> blEmailDialects() {
        LinkedHashSet<IDialect> dialects = new LinkedHashSet<IDialect>();
        dialects.add((IDialect)this.thymeleafSpringStandardDialect());
        dialects.add((IDialect)this.blDialect());
        return dialects;
    }

    @Bean
    public BroadleafThymeleaf3Dialect blDialect() {
        BroadleafThymeleaf3Dialect dialect = new BroadleafThymeleaf3Dialect();
        LinkedHashSet<IProcessor> allProcessors = new LinkedHashSet<IProcessor>();
        allProcessors.addAll(this.blDialectProcessors());
        allProcessors.addAll(this.iProcessors);
        dialect.setProcessors(allProcessors);
        return dialect;
    }

    @Bean
    public Set<IProcessor> blDialectProcessors() {
        return this.configUtil.getDialectProcessors(this.blcProcessors);
    }

    @Configuration
    static class AbstractThymeleaf3ProcessorConfig {
        AbstractThymeleaf3ProcessorConfig() {
        }

        @Bean
        public IProcessor blArbitraryHtmlInjectionProcessor() {
            return new ArbitraryHtmlInsertionProcessor();
        }

        @Bean
        public IProcessor blCacheProcessor() {
            return new BroadleafThymeleaf3CacheProcessor();
        }
    }

    @Configuration
    @ConditionalOnJava(value=JavaVersion.EIGHT)
    @ConditionalOnClass(value={Java8TimeDialect.class})
    protected static class ThymeleafJava8TimeDialect {
        protected ThymeleafJava8TimeDialect() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Java8TimeDialect java8TimeDialect() {
            return new Java8TimeDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={SpringSecurityDialect.class})
    protected static class ThymeleafSecurityDialectConfiguration {
        protected ThymeleafSecurityDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public SpringSecurityDialect securityDialect() {
            return new SpringSecurityDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={DataAttributeDialect.class})
    protected static class DataAttributeDialectConfiguration {
        protected DataAttributeDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DataAttributeDialect dataAttributeDialect() {
            return new DataAttributeDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"nz.net.ultraq.thymeleaf.LayoutDialect"})
    protected static class ThymeleafWebLayoutConfiguration {
        protected ThymeleafWebLayoutConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public LayoutDialect layoutDialect() {
            return new LayoutDialect();
        }
    }
}

